/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Equivalence;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class CTypes {
    public static Equivalence<CType> canonicalTypeEquivalence() {
        return CanonicalCTypeEquivalence.INSTANCE;
    }

    public static <T extends CType> T withoutConst(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (!type.isConst()) {
            return type;
        }
        CType result = type.accept(ForceConstVisitor.FALSE);
        return (T)result;
    }

    public static <T extends CType> T withConst(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (type.isConst()) {
            return type;
        }
        CType result = type.accept(ForceConstVisitor.TRUE);
        return (T)result;
    }

    public static <T extends CType> T withoutVolatile(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (!type.isVolatile()) {
            return type;
        }
        CType result = type.accept(ForceVolatileVisitor.FALSE);
        return (T)result;
    }

    public static <T extends CType> T withVolatile(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (type.isVolatile()) {
            return type;
        }
        CType result = type.accept(ForceVolatileVisitor.TRUE);
        return (T)result;
    }

    private static enum ForceVolatileVisitor implements CTypeVisitor<CType, RuntimeException>
    {
        FALSE(false),
        TRUE(true);

        private final boolean volatileValue;

        private ForceVolatileVisitor(boolean pVolatileValue) {
            this.volatileValue = pVolatileValue;
        }

        @Override
        public CArrayType visit(CArrayType t) {
            return new CArrayType(t.isConst(), this.volatileValue, t.getType(), t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            return new CCompositeType(t.isConst(), this.volatileValue, t.getKind(), t.getMembers(), t.getName(), t.getOrigName());
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            return new CElaboratedType(t.isConst(), this.volatileValue, t.getKind(), t.getName(), t.getOrigName(), t.getRealType());
        }

        @Override
        public CEnumType visit(CEnumType t) {
            return new CEnumType(t.isConst(), this.volatileValue, (List<CEnumType.CEnumerator>)t.getEnumerators(), t.getName(), t.getOrigName());
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            return new CFunctionType(t.isConst(), this.volatileValue, t.getReturnType(), t.getParameters(), t.takesVarArgs());
        }

        @Override
        public CPointerType visit(CPointerType t) {
            return new CPointerType(t.isConst(), this.volatileValue, t.getType());
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return new CSimpleType(t.isConst(), this.volatileValue, t.getType(), t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            return new CTypedefType(t.isConst(), this.volatileValue, t.getName(), t.getRealType());
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(t.isConst(), this.volatileValue);
        }
    }

    private static enum ForceConstVisitor implements CTypeVisitor<CType, RuntimeException>
    {
        FALSE(false),
        TRUE(true);

        private final boolean constValue;

        private ForceConstVisitor(boolean pConstValue) {
            this.constValue = pConstValue;
        }

        @Override
        public CArrayType visit(CArrayType t) {
            return new CArrayType(this.constValue, t.isVolatile(), t.getType(), t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            return new CCompositeType(this.constValue, t.isVolatile(), t.getKind(), t.getMembers(), t.getName(), t.getOrigName());
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            return new CElaboratedType(this.constValue, t.isVolatile(), t.getKind(), t.getName(), t.getOrigName(), t.getRealType());
        }

        @Override
        public CEnumType visit(CEnumType t) {
            return new CEnumType(this.constValue, t.isVolatile(), (List<CEnumType.CEnumerator>)t.getEnumerators(), t.getName(), t.getOrigName());
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            return new CFunctionType(this.constValue, t.isVolatile(), t.getReturnType(), t.getParameters(), t.takesVarArgs());
        }

        @Override
        public CPointerType visit(CPointerType t) {
            return new CPointerType(this.constValue, t.isVolatile(), t.getType());
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return new CSimpleType(this.constValue, t.isVolatile(), t.getType(), t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            return new CTypedefType(this.constValue, t.isVolatile(), t.getName(), t.getRealType());
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(this.constValue, t.isVolatile());
        }
    }

    private static class CanonicalCTypeEquivalence
    extends Equivalence<CType> {
        private static final CanonicalCTypeEquivalence INSTANCE = new CanonicalCTypeEquivalence();

        private CanonicalCTypeEquivalence() {
        }

        protected boolean doEquivalent(CType pA, CType pB) {
            return pA.getCanonicalType().equals(pB.getCanonicalType());
        }

        protected int doHash(CType pT) {
            return pT.getCanonicalType().hashCode();
        }
    }
}

