/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CVoidType
implements CType,
Serializable {
    private static final long serialVersionUID = 1385808708190595556L;
    public static final CVoidType VOID = new CVoidType(false, false);
    private static final CVoidType CONST_VOID = new CVoidType(true, false);
    private static final CVoidType VOLATILE_VOID = new CVoidType(false, true);
    private static final CVoidType CONST_VOLATILE_VOID = new CVoidType(true, true);
    private final boolean isConst;
    private final boolean isVolatile;

    public static CVoidType create(boolean pIsConst, boolean pIsVolatile) {
        if (pIsConst) {
            return pIsVolatile ? CONST_VOLATILE_VOID : CONST_VOID;
        }
        return pIsVolatile ? VOLATILE_VOID : VOID;
    }

    private CVoidType(boolean pIsConst, boolean pIsVolatile) {
        this.isConst = pIsConst;
        this.isVolatile = pIsVolatile;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toASTString("");
    }

    @Override
    public String toASTString(String pDeclarator) {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.isConst()) {
            parts.add("const");
        }
        if (this.isVolatile()) {
            parts.add("volatile");
        }
        parts.add("void");
        parts.add(Strings.emptyToNull((String)pDeclarator));
        return Joiner.on((char)' ').skipNulls().join(parts);
    }

    @Override
    public CVoidType getCanonicalType() {
        return this;
    }

    @Override
    public CVoidType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return CVoidType.create(this.isConst || pForceConst, this.isVolatile || pForceVolatile);
    }
}

