/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;

public abstract class JClassOrInterfaceType
implements JReferenceType {
    private final VisibilityModifier visibility;
    private final String name;
    private final String simpleName;
    private final JClassOrInterfaceType enclosingType;
    private final Set<JClassOrInterfaceType> nestedTypes = new HashSet<JClassOrInterfaceType>();

    protected JClassOrInterfaceType(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility) {
        this.name = fullyQualifiedName;
        this.visibility = pVisibility;
        this.simpleName = pSimpleName;
        this.enclosingType = null;
        Preconditions.checkNotNull((Object)fullyQualifiedName);
        Preconditions.checkNotNull((Object)pSimpleName);
        Preconditions.checkArgument((this.getVisibility() != VisibilityModifier.PRIVATE || this.getVisibility() != VisibilityModifier.PROTECTED ? 1 : 0) != 0, (Object)" Interfaces can't be private or protected");
    }

    protected JClassOrInterfaceType(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, JClassOrInterfaceType pEnclosingType) {
        this.name = fullyQualifiedName;
        this.simpleName = pSimpleName;
        this.visibility = pVisibility;
        this.enclosingType = pEnclosingType;
        Preconditions.checkNotNull((Object)fullyQualifiedName);
        Preconditions.checkNotNull((Object)pSimpleName);
        Preconditions.checkArgument((boolean)fullyQualifiedName.endsWith(pSimpleName));
        Preconditions.checkNotNull((Object)pEnclosingType);
        Preconditions.checkArgument((this.getVisibility() != VisibilityModifier.PRIVATE || this.getVisibility() != VisibilityModifier.PROTECTED ? 1 : 0) != 0, (Object)" Interfaces can't be private or protected");
        this.enclosingType.notifyEnclosingTypeOfNestedType(this);
        this.checkEnclosingTypeConsistency();
    }

    private void checkEnclosingTypeConsistency() {
        Preconditions.checkArgument((!this.isTopLevel() ? 1 : 0) != 0);
        HashSet<JClassOrInterfaceType> found = new HashSet<JClassOrInterfaceType>();
        JClassOrInterfaceType nextEnclosingType = this.enclosingType;
        found.add(this.enclosingType);
        while (!nextEnclosingType.isTopLevel()) {
            nextEnclosingType = nextEnclosingType.getEnclosingType();
            Preconditions.checkArgument((!found.contains(this) ? 1 : 0) != 0, (Object)("Class " + this.getName() + " may not be a nested type of itself."));
            found.add(nextEnclosingType);
        }
    }

    @Override
    public String toASTString(String pDeclarator) {
        return pDeclarator.isEmpty() ? this.getName() : this.getName() + " " + pDeclarator;
    }

    public String getName() {
        return this.name;
    }

    public VisibilityModifier getVisibility() {
        return this.visibility;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (!(pObj instanceof JClassOrInterfaceType)) {
            return false;
        }
        JClassOrInterfaceType other = (JClassOrInterfaceType)pObj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public String toString() {
        return this.name;
    }

    public List<JClassOrInterfaceType> getAllSuperTypesOfType() {
        LinkedList<JClassOrInterfaceType> result = new LinkedList<JClassOrInterfaceType>();
        if (this instanceof JClassType) {
            result.addAll(((JClassType)this).getAllSuperTypesOfClass());
        } else if (this instanceof JInterfaceType) {
            result.addAll(((JInterfaceType)this).getAllSuperInterfaces());
            return result;
        }
        return result;
    }

    public List<JClassOrInterfaceType> getAllSubTypesOfType() {
        LinkedList<JClassOrInterfaceType> result = new LinkedList<JClassOrInterfaceType>();
        if (this instanceof JClassType) {
            result.addAll(((JClassType)this).getAllSubTypesOfClass());
        } else if (this instanceof JInterfaceType) {
            result.addAll(((JInterfaceType)this).getAllSuperInterfaces());
            return result;
        }
        return result;
    }

    public JClassOrInterfaceType getEnclosingType() {
        Preconditions.checkNotNull((Object)this.enclosingType, (Object)"Top-level-classes do not have an enclosing type.");
        return this.enclosingType;
    }

    public Set<JClassOrInterfaceType> getNestedTypes() {
        return ImmutableSet.copyOf(this.nestedTypes);
    }

    public final Set<JClassOrInterfaceType> getAllEnclosingTypes() {
        HashSet<JClassOrInterfaceType> result = new HashSet<JClassOrInterfaceType>();
        JClassOrInterfaceType nextEnclosingInstance = this.enclosingType;
        while (!nextEnclosingInstance.isTopLevel()) {
            result.add(nextEnclosingInstance);
            nextEnclosingInstance = nextEnclosingInstance.getEnclosingType();
        }
        return result;
    }

    public boolean isTopLevel() {
        return this.enclosingType == null;
    }

    private void notifyEnclosingTypeOfNestedType(JClassOrInterfaceType nestedType) {
        Preconditions.checkArgument((!this.nestedTypes.contains(nestedType) ? 1 : 0) != 0);
        this.nestedTypes.add(nestedType);
    }

    public String getSimpleName() {
        return this.simpleName;
    }
}

