/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JSimpleType
implements JType {
    private final JBasicType type;
    private final boolean isPrimitive;
    private static final JSimpleType SINGLETON_BOOL = new JSimpleType(JBasicType.BOOLEAN);
    private static final JSimpleType SINGLETON_BYTE = new JSimpleType(JBasicType.BYTE);
    private static final JSimpleType SINGLETON_SHORT = new JSimpleType(JBasicType.SHORT);
    private static final JSimpleType SINGLETON_CHAR = new JSimpleType(JBasicType.CHAR);
    private static final JSimpleType SINGLETON_INT = new JSimpleType(JBasicType.INT);
    private static final JSimpleType SINGLETON_LONG = new JSimpleType(JBasicType.LONG);
    private static final JSimpleType SINGLETON_FLOAT = new JSimpleType(JBasicType.FLOAT);
    private static final JSimpleType SINGLETON_DOUBLE = new JSimpleType(JBasicType.DOUBLE);
    private static final JSimpleType SINGLETON_NULL = new JSimpleType(JBasicType.NULL);
    private static final JSimpleType SINGLETON_UNSPECIFIED = new JSimpleType(JBasicType.UNSPECIFIED);
    private static final JSimpleType SINGLETON_VOID = new JSimpleType(JBasicType.VOID);

    public static JSimpleType getBoolean() {
        return SINGLETON_BOOL;
    }

    public static JSimpleType getByte() {
        return SINGLETON_BYTE;
    }

    public static JSimpleType getShort() {
        return SINGLETON_SHORT;
    }

    public static JSimpleType getChar() {
        return SINGLETON_CHAR;
    }

    public static JSimpleType getInt() {
        return SINGLETON_INT;
    }

    public static JSimpleType getLong() {
        return SINGLETON_LONG;
    }

    public static JSimpleType getFloat() {
        return SINGLETON_FLOAT;
    }

    public static JSimpleType getDouble() {
        return SINGLETON_DOUBLE;
    }

    public static JSimpleType getNull() {
        return SINGLETON_NULL;
    }

    public static JSimpleType getUnspecified() {
        return SINGLETON_UNSPECIFIED;
    }

    public static JSimpleType getVoid() {
        return SINGLETON_VOID;
    }

    private JSimpleType(JBasicType pType) {
        this.type = pType;
        switch (this.type) {
            case BOOLEAN: 
            case BYTE: 
            case INT: 
            case SHORT: 
            case FLOAT: 
            case DOUBLE: {
                this.isPrimitive = true;
                break;
            }
            default: {
                this.isPrimitive = false;
            }
        }
    }

    public JBasicType getType() {
        return this.type;
    }

    @Override
    public String toASTString(String pDeclarator) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(Strings.emptyToNull((String)this.type.toASTString()));
        parts.add(Strings.emptyToNull((String)pDeclarator));
        return Joiner.on((char)' ').skipNulls().join(parts);
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode((Object)this.type);
        result = 31 * result + Objects.hashCode(this.isPrimitive);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JSimpleType)) {
            return false;
        }
        JSimpleType other = (JSimpleType)obj;
        return this.type == other.type && this.isPrimitive == other.isPrimitive;
    }

    public String toString() {
        switch (this.type) {
            case UNSPECIFIED: {
                return "unspecified";
            }
        }
        return this.type.toASTString();
    }
}

