/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Strings;
import com.google.common.io.Closer;
import com.google.common.io.FileWriteMode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.DuplicateOutputStream;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cmdline.CmdLineArguments;
import org.sosy_lab.cpachecker.cmdline.ForceTerminationOnShutdown;
import org.sosy_lab.cpachecker.cmdline.ShutdownHook;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofGenerator;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

public class CPAMain {
    static final PrintStream ERROR_OUTPUT = System.err;
    static final int ERROR_EXIT_CODE = 1;

    public static void main(String[] args) {
        Configuration cpaConfig = null;
        BasicLogManager logManager = null;
        String outputDirectory = null;
        try {
            try {
                Pair<Configuration, String> p = CPAMain.createConfiguration(args);
                cpaConfig = (Configuration)p.getFirst();
                outputDirectory = (String)p.getSecond();
            }
            catch (CmdLineArguments.InvalidCmdlineArgumentException e) {
                ERROR_OUTPUT.println("Could not process command line arguments: " + e.getMessage());
                System.exit(1);
            }
            catch (IOException e) {
                ERROR_OUTPUT.println("Could not read config file " + e.getMessage());
                System.exit(1);
            }
            logManager = new BasicLogManager(cpaConfig);
        }
        catch (InvalidConfigurationException e) {
            ERROR_OUTPUT.println("Invalid configuration: " + e.getMessage());
            System.exit(1);
            return;
        }
        cpaConfig.enableLogging((LogManager)logManager);
        GlobalInfo.getInstance().storeLogManager((LogManager)logManager);
        ShutdownNotifier shutdownNotifier = ShutdownNotifier.create();
        CPAchecker cpachecker = null;
        ProofGenerator proofGenerator = null;
        ResourceLimitChecker limits = null;
        MainOptions options = new MainOptions();
        try {
            cpaConfig.inject((Object)options);
            if (Strings.isNullOrEmpty((String)options.programs)) {
                throw new InvalidConfigurationException("Please specify a program to analyze on the command line.");
            }
            CPAMain.dumpConfiguration(options, cpaConfig, (LogManager)logManager);
            limits = ResourceLimitChecker.fromConfiguration(cpaConfig, (LogManager)logManager, shutdownNotifier);
            limits.start();
            cpachecker = new CPAchecker(cpaConfig, (LogManager)logManager, shutdownNotifier);
            if (options.doPCC) {
                proofGenerator = new ProofGenerator(cpaConfig, (LogManager)logManager, shutdownNotifier);
            }
        }
        catch (InvalidConfigurationException e) {
            logManager.logUserException(Level.SEVERE, (Throwable)e, "Invalid configuration");
            System.exit(1);
            return;
        }
        ShutdownHook shutdownHook = new ShutdownHook(shutdownNotifier);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        ShutdownNotifier.ShutdownRequestListener forcedExitOnShutdown = ForceTerminationOnShutdown.createShutdownListener((LogManager)logManager, shutdownHook);
        shutdownNotifier.register(forcedExitOnShutdown);
        CPAcheckerResult result = cpachecker.run(options.programs);
        if (proofGenerator != null) {
            proofGenerator.generateProof(result);
        }
        shutdownHook.disable();
        shutdownNotifier.unregister(forcedExitOnShutdown);
        ForceTerminationOnShutdown.cancelPendingTermination();
        limits.cancel();
        Thread.interrupted();
        try {
            CPAMain.printResultAndStatistics(result, outputDirectory, options, (LogManager)logManager);
        }
        catch (IOException e) {
            logManager.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
        }
        System.out.flush();
        System.err.flush();
        logManager.flush();
    }

    private static void dumpConfiguration(MainOptions options, Configuration config, LogManager logManager) {
        if (options.configurationOutputFile != null) {
            try {
                Files.writeFile((Path)options.configurationOutputFile, (Object)config.asPropertiesString());
            }
            catch (IOException e) {
                logManager.logUserException(Level.WARNING, (Throwable)e, "Could not dump configuration to file");
            }
        }
    }

    private static Pair<Configuration, String> createConfiguration(String[] args) throws InvalidConfigurationException, CmdLineArguments.InvalidCmdlineArgumentException, IOException {
        boolean secureMode;
        Map<String, String> cmdLineOptions = CmdLineArguments.processArguments(args);
        boolean bl = secureMode = cmdLineOptions.remove("secureMode") != null;
        if (secureMode) {
            Configuration.enableSecureModeGlobally();
        }
        String configFile = cmdLineOptions.remove("configuration.file");
        ConfigurationBuilder configBuilder = Configuration.builder();
        if (configFile != null) {
            configBuilder.loadFromFile(configFile);
        }
        configBuilder.setOptions(cmdLineOptions);
        Configuration config = configBuilder.build();
        Pair<Configuration, String> p = CPAMain.setupPaths(config, secureMode);
        config = (Configuration)p.getFirst();
        String outputDirectory = (String)p.getSecond();
        BootstrapOptions options = new BootstrapOptions();
        config.inject((Object)options);
        if (options.checkMemsafety) {
            if (options.memsafetyConfig == null) {
                throw new InvalidConfigurationException("Verifying memory safety is not supported if option memorysafety.config is not specified.");
            }
            config = Configuration.builder().loadFromFile(options.memsafetyConfig).setOptions(cmdLineOptions).clearOption("memorysafety.check").clearOption("memorysafety.config").clearOption("output.disable").clearOption("output.path").clearOption("rootDirectory").build();
        }
        return Pair.of((Object)config, (Object)outputDirectory);
    }

    private static Pair<Configuration, String> setupPaths(Configuration pConfig, boolean pSecureMode) throws InvalidConfigurationException {
        FileTypeConverter fileTypeConverter = pSecureMode ? FileTypeConverter.createWithSafePathsOnly((Configuration)pConfig) : FileTypeConverter.create((Configuration)pConfig);
        String outputDirectory = fileTypeConverter.getOutputDirectory();
        Configuration config = Configuration.builder().copyFrom(pConfig).addConverter(FileOption.class, (TypeConverter)fileTypeConverter).build();
        Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
        return Pair.of((Object)config, (Object)outputDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printResultAndStatistics(CPAcheckerResult mResult, String outputDirectory, MainOptions options, LogManager logManager) throws IOException {
        PrintStream console = options.printStatistics ? System.out : null;
        OutputStream file = null;
        Closer closer = Closer.create();
        if (options.exportStatistics && options.exportStatisticsFile != null) {
            try {
                Files.createParentDirs((Path)options.exportStatisticsFile);
                file = (OutputStream)closer.register((Closeable)options.exportStatisticsFile.asByteSink(new FileWriteMode[0]).openStream());
            }
            catch (IOException e) {
                logManager.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
            }
        }
        PrintStream stream = CPAMain.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)console, file));
        try {
            mResult.printStatistics(stream);
            stream.println();
            if (!options.printStatistics) {
                stream = CPAMain.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)System.out, (OutputStream)file));
            }
            mResult.printResult(stream);
            if (outputDirectory != null) {
                stream.println("More details about the verification run can be found in the directory \"" + outputDirectory + "\".");
            }
            stream.flush();
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Default encoding is the correct one for stdout.")
    private static PrintStream makePrintStream(OutputStream stream) {
        if (stream instanceof PrintStream) {
            return (PrintStream)stream;
        }
        return new PrintStream(stream);
    }

    private CPAMain() {
    }

    @Options
    private static class MainOptions {
        @Option(secure=true, name="analysis.programNames", description="A String, denoting the programs to be analyzed")
        private String programs;
        @Option(secure=true, name="configuration.dumpFile", description="Dump the complete configuration to a file.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path configurationOutputFile = Paths.get((String)"UsedConfiguration.properties", (String[])new String[0]);
        @Option(secure=true, name="statistics.export", description="write some statistics to disk")
        private boolean exportStatistics = true;
        @Option(secure=true, name="statistics.file", description="write some statistics to disk")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path exportStatisticsFile = Paths.get((String)"Statistics.txt", (String[])new String[0]);
        @Option(secure=true, name="statistics.print", description="print statistics to console")
        private boolean printStatistics = false;
        @Option(secure=true, name="pcc.proofgen.doPCC", description="Generate and dump a proof")
        private boolean doPCC = false;

        private MainOptions() {
        }
    }

    @Options
    private static class BootstrapOptions {
        @Option(secure=true, name="memorysafety.check", description="Whether to check for memory safety properties (this can be specified by passing an appropriate .prp file to the -spec parameter).")
        private boolean checkMemsafety = false;
        @Option(secure=true, name="memorysafety.config", description="When checking for memory safety properties, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private Path memsafetyConfig = null;

        private BootstrapOptions() {
        }
    }
}

