/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.cmdline.CPAMain;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.util.PropertyFileParser;

class CmdLineArguments {
    private static final Splitter SETPROP_OPTION_SPLITTER = Splitter.on((char)'=').trimResults().limit(2);
    private static final Pattern DEFAULT_CONFIG_FILES_PATTERN;
    private static final String DEFAULT_CONFIG_FILES_DIR = "config/%s.properties";
    static final String CONFIGURATION_FILE_OPTION = "configuration.file";
    private static final String CMC_CONFIGURATION_FILES_OPTION = "restartAlgorithm.configFiles";
    private static final Pattern SPECIFICATION_FILES_PATTERN;
    private static final String SPECIFICATION_FILES_TEMPLATE = "config/specification/%s.spc";
    private static final String REACHABILITY_LABEL_SPECIFICATION_FILE = "config/specification/sv-comp.spc";
    private static final String REACHABILITY_SPECIFICATION_FILE = "config/specification/sv-comp-reachability.spc";
    private static final Pattern PROPERTY_FILE_PATTERN;
    static final String SECURE_MODE_OPTION = "secureMode";

    private CmdLineArguments() {
    }

    static Map<String, String> processArguments(String[] args) throws InvalidCmdlineArgumentException {
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<String> programs = new ArrayList<String>();
        Iterator<String> argsIt = Arrays.asList(args).iterator();
        while (argsIt.hasNext()) {
            String arg = argsIt.next();
            if (CmdLineArguments.handleArgument0("-stats", "statistics.print", "true", arg, properties) || CmdLineArguments.handleArgument0("-noout", "output.disable", "true", arg, properties) || CmdLineArguments.handleArgument0("-java", "language", "JAVA", arg, properties) || CmdLineArguments.handleArgument0("-32", "analysis.machineModel", "Linux32", arg, properties) || CmdLineArguments.handleArgument0("-64", "analysis.machineModel", "Linux64", arg, properties) || CmdLineArguments.handleArgument0("-preprocess", "parser.usePreprocessor", "true", arg, properties) || CmdLineArguments.handleArgument0("-secureMode", SECURE_MODE_OPTION, "true", arg, properties) || CmdLineArguments.handleArgument1("-outputpath", "output.path", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-logfile", "log.file", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-entryfunction", "analysis.entryFunction", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-config", CONFIGURATION_FILE_OPTION, arg, argsIt, properties) || CmdLineArguments.handleArgument1("-timelimit", "limits.time.cpu", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-sourcepath", "java.sourcepath", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-cp", "java.classpath", arg, argsIt, properties) || CmdLineArguments.handleArgument1("-classpath", "java.classpath", arg, argsIt, properties) || CmdLineArguments.handleMultipleArgument1("-spec", "specification", arg, argsIt, properties)) continue;
            if (arg.equals("-cmc")) {
                CmdLineArguments.handleCmc(argsIt, properties);
                continue;
            }
            if (arg.equals("-cpas")) {
                if (argsIt.hasNext()) {
                    properties.put("cpa", CompositeCPA.class.getName());
                    properties.put(CompositeCPA.class.getSimpleName() + ".cpas", argsIt.next());
                    continue;
                }
                throw new InvalidCmdlineArgumentException("-cpas argument missing.");
            }
            if (arg.equals("-cbmc")) {
                CmdLineArguments.putIfNotExistent(properties, "analysis.checkCounterexamples", "true");
                CmdLineArguments.putIfNotExistent(properties, "counterexample.checker", "CBMC");
                continue;
            }
            if (arg.equals("-nolog")) {
                CmdLineArguments.putIfNotExistent(properties, "log.level", "off");
                CmdLineArguments.putIfNotExistent(properties, "log.consoleLevel", "off");
                continue;
            }
            if (arg.equals("-skipRecursion")) {
                CmdLineArguments.putIfNotExistent(properties, "analysis.summaryEdges", "true");
                CmdLineArguments.putIfNotExistent(properties, "cpa.callstack.skipRecursion", "true");
                continue;
            }
            if (arg.equals("-setprop")) {
                if (argsIt.hasNext()) {
                    String s = argsIt.next();
                    ArrayList bits = Lists.newArrayList((Iterable)SETPROP_OPTION_SPLITTER.split((CharSequence)s));
                    if (bits.size() != 2) {
                        throw new InvalidCmdlineArgumentException("-setprop argument must be a key=value pair, but \"" + s + "\" is not.");
                    }
                    CmdLineArguments.putIfNotExistent(properties, (String)bits.get(0), (String)bits.get(1));
                    continue;
                }
                throw new InvalidCmdlineArgumentException("-setprop argument missing.");
            }
            if ("-printOptions".equals(arg)) {
                boolean verbose = false;
                if (argsIt.hasNext()) {
                    String nextArg = argsIt.next();
                    verbose = "-v".equals(nextArg) || "-verbose".equals(nextArg);
                }
                PrintStream out = System.out;
                out.println(OptionCollector.getCollectedOptions((boolean)verbose));
                System.exit(0);
                continue;
            }
            if ("-printUsedOptions".equals(arg)) {
                CmdLineArguments.putIfNotExistent(properties, "log.usedOptions.export", "true");
                CmdLineArguments.putIfNotExistent(properties, "analysis.disable", "true");
                properties.put("log.consoleLevel", "SEVERE");
                continue;
            }
            if (arg.equals("-help") || arg.equals("-h")) {
                CmdLineArguments.printHelp(System.out);
                System.exit(0);
                continue;
            }
            if (arg.startsWith("-") && !Paths.get((String)arg, (String[])new String[0]).exists()) {
                String argName = arg.substring(1);
                if (DEFAULT_CONFIG_FILES_PATTERN.matcher(argName).matches()) {
                    Path configFile = CmdLineArguments.findFile(DEFAULT_CONFIG_FILES_DIR, argName);
                    if (configFile != null) {
                        try {
                            Files.checkReadableFile((Path)configFile);
                            CmdLineArguments.putIfNotExistent(properties, CONFIGURATION_FILE_OPTION, configFile.toString());
                        }
                        catch (FileNotFoundException e) {
                            CPAMain.ERROR_OUTPUT.println("Invalid configuration " + argName + " (" + e.getMessage() + ")");
                            System.exit(1);
                        }
                        continue;
                    }
                    CPAMain.ERROR_OUTPUT.println("Invalid option " + arg);
                    CPAMain.ERROR_OUTPUT.println("If you meant to specify a configuration file, the file " + String.format(DEFAULT_CONFIG_FILES_DIR, argName) + " does not exist.");
                    CPAMain.ERROR_OUTPUT.println("");
                    CmdLineArguments.printHelp(CPAMain.ERROR_OUTPUT);
                    System.exit(1);
                    continue;
                }
                CPAMain.ERROR_OUTPUT.println("Invalid option " + arg);
                CPAMain.ERROR_OUTPUT.println("");
                CmdLineArguments.printHelp(CPAMain.ERROR_OUTPUT);
                System.exit(1);
                continue;
            }
            programs.add(arg);
        }
        if (!programs.isEmpty()) {
            CmdLineArguments.putIfNotExistent(properties, "analysis.programNames", Joiner.on((String)", ").join(programs));
        }
        return properties;
    }

    private static void handleCmc(Iterator<String> argsIt, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        String newValue;
        properties.put("analysis.restartAfterUnknown", "true");
        if (argsIt.hasNext()) {
            Path configFile;
            newValue = argsIt.next();
            if (DEFAULT_CONFIG_FILES_PATTERN.matcher(newValue).matches() && !Paths.get((String)newValue, (String[])new String[0]).exists() && (configFile = CmdLineArguments.findFile(DEFAULT_CONFIG_FILES_DIR, newValue)) != null) {
                newValue = configFile.toString();
            }
        } else {
            throw new InvalidCmdlineArgumentException("-cmc argument missing.");
        }
        String value = properties.get(CMC_CONFIGURATION_FILES_OPTION);
        value = value != null ? value + "," + newValue : newValue;
        properties.put(CMC_CONFIGURATION_FILES_OPTION, value);
    }

    private static void printHelp(PrintStream out) {
        out.println("CPAchecker " + CPAchecker.getVersion());
        out.println();
        out.println("OPTIONS:");
        out.println(" -config");
        out.println(" -cpas");
        out.println(" -spec");
        out.println(" -outputpath");
        out.println(" -logfile");
        out.println(" -entryfunction");
        out.println(" -timelimit");
        out.println(" -cbmc");
        out.println(" -stats");
        out.println(" -nolog");
        out.println(" -noout");
        out.println(" -java");
        out.println(" -32");
        out.println(" -64");
        out.println(" -secureMode");
        out.println(" -skipRecursion");
        out.println(" -setprop");
        out.println(" -printOptions [-v|-verbose]");
        out.println(" -printUsedOptions");
        out.println(" -help");
        out.println();
        out.println("You can also specify any of the configuration files in the directory config/");
        out.println("with -CONFIG_FILE, e.g., -predicateAnalysis for config/predicateAnalysis.properties.");
        out.println();
        out.println("More information on how to configure CPAchecker can be found in 'doc/Configuration.txt'.");
    }

    private static void putIfNotExistent(Map<String, String> properties, String key, String value) throws InvalidCmdlineArgumentException {
        if (properties.containsKey(key)) {
            throw new InvalidCmdlineArgumentException("Duplicate option " + key + " specified on command-line.");
        }
        properties.put(key, value);
    }

    private static boolean handleArgument0(String arg, String option, String value, String currentArg, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            CmdLineArguments.putIfNotExistent(properties, option, value);
            return true;
        }
        return false;
    }

    private static boolean handleArgument1(String arg, String option, String currentArg, Iterator<String> args, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            if (!args.hasNext()) {
                throw new InvalidCmdlineArgumentException(currentArg + " argument missing.");
            }
            CmdLineArguments.putIfNotExistent(properties, option, args.next());
            return true;
        }
        return false;
    }

    private static boolean handleMultipleArgument1(String arg, String option, String currentArg, Iterator<String> args, Map<String, String> options) throws InvalidCmdlineArgumentException {
        if (currentArg.equals(arg)) {
            if (args.hasNext()) {
                String newValue = args.next();
                if (arg.equals("-spec")) {
                    if (SPECIFICATION_FILES_PATTERN.matcher(newValue).matches()) {
                        Path specFile = CmdLineArguments.findFile(SPECIFICATION_FILES_TEMPLATE, newValue);
                        if (specFile != null) {
                            newValue = specFile.toString();
                        } else {
                            CPAMain.ERROR_OUTPUT.println("Checking for property " + newValue + " is currently not supported by CPAchecker.");
                            System.exit(1);
                        }
                    } else if (PROPERTY_FILE_PATTERN.matcher(newValue).matches()) {
                        Path propertyFile = Paths.get((String)newValue, (String[])new String[0]);
                        if (propertyFile.toFile().exists()) {
                            PropertyFileParser parser = new PropertyFileParser(propertyFile);
                            try {
                                parser.parse();
                            }
                            catch (PropertyFileParser.InvalidPropertyFileException e) {
                                throw new InvalidCmdlineArgumentException("Invalid property file: " + e.getMessage(), e);
                            }
                            CmdLineArguments.putIfNotExistent(options, "analysis.entryFunction", parser.getEntryFunction());
                            EnumSet<PropertyFileParser.PropertyType> properties = parser.getProperties();
                            assert (!properties.isEmpty());
                            if (properties.equals(EnumSet.of(PropertyFileParser.PropertyType.VALID_DEREF, PropertyFileParser.PropertyType.VALID_FREE, PropertyFileParser.PropertyType.VALID_MEMTRACK))) {
                                CmdLineArguments.putIfNotExistent(options, "memorysafety.check", "true");
                                newValue = null;
                            } else if (properties.equals(EnumSet.of(PropertyFileParser.PropertyType.REACHABILITY_LABEL))) {
                                newValue = REACHABILITY_LABEL_SPECIFICATION_FILE;
                            } else if (properties.equals(EnumSet.of(PropertyFileParser.PropertyType.REACHABILITY))) {
                                newValue = REACHABILITY_SPECIFICATION_FILE;
                            } else {
                                CPAMain.ERROR_OUTPUT.println("Checking for the properties " + properties + " is currently not supported by CPAchecker.");
                                System.exit(1);
                            }
                        } else {
                            CPAMain.ERROR_OUTPUT.println("Checking for property " + newValue + " is currently not supported by CPAchecker.");
                            System.exit(1);
                        }
                    }
                }
                if (newValue != null) {
                    String value = options.get(option);
                    value = value != null ? value + "," + newValue : newValue;
                    options.put(option, value);
                }
            } else {
                throw new InvalidCmdlineArgumentException(currentArg + " argument missing.");
            }
            return true;
        }
        return false;
    }

    private static Path findFile(String template, String name) {
        String fileName = String.format(template, name);
        Path file = Paths.get((String)fileName, (String[])new String[0]);
        if (file.toFile().exists()) {
            return file;
        }
        Path codeLocation = Paths.get((String)CmdLineArguments.class.getProtectionDomain().getCodeSource().getLocation().getPath(), (String[])new String[0]);
        Path baseDir = codeLocation.getParent();
        file = baseDir.resolve(fileName);
        if (file.toFile().exists()) {
            return file;
        }
        return null;
    }

    static {
        SPECIFICATION_FILES_PATTERN = DEFAULT_CONFIG_FILES_PATTERN = Pattern.compile("^[a-zA-Z0-9-+]+$");
        PROPERTY_FILE_PATTERN = Pattern.compile("(.)+\\.prp");
    }

    public static class InvalidCmdlineArgumentException
    extends Exception {
        private static final long serialVersionUID = -6526968677815416436L;

        private InvalidCmdlineArgumentException(String msg) {
            super(msg);
        }

        public InvalidCmdlineArgumentException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

