/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;

class ShutdownHook
extends Thread {
    private final Thread mainThread;
    private final ShutdownNotifier shutdownNotifier;
    private volatile boolean enabled = true;

    public ShutdownHook(ShutdownNotifier pShutdownNotifier) {
        super("Shutdown Hook");
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.mainThread = Thread.currentThread();
    }

    public void disableAndStop() {
        this.enabled = false;
        this.interrupt();
    }

    public void disable() {
        this.enabled = false;
    }

    @Override
    public void run() {
        if (this.enabled && this.mainThread.isAlive()) {
            this.shutdownNotifier.requestShutdown("The JVM is shutting down, probably because Ctrl+C was pressed.");
            try {
                this.mainThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

