/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.MainCPAStatistics;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.ExternalCBMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.ImpactAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="analysis")
public class CPAchecker {
    @Option(secure=true, description="stop after the first error has been found")
    private boolean stopAfterError = true;
    @Option(secure=true, name="disable", description="stop CPAchecker after startup (internal option, not intended for users)")
    private boolean disableAnalysis = false;
    @Option(secure=true, name="initialStatesFor", description="What CFA nodes should be the starting point of the analysis?")
    private Set<InitialStatesFor> initialStatesFor = Sets.newHashSet((Object[])new InitialStatesFor[]{InitialStatesFor.ENTRY});
    @Option(secure=true, description="Partition the initial states based on the type of location they were created for (see 'initialStatesFor')")
    private boolean partitionInitialStates = false;
    @Option(secure=true, name="algorithm.CBMC", description="use CBMC as an external tool from CPAchecker")
    private boolean runCBMCasExternalTool = false;
    @Option(secure=true, description="Do not report unknown if analysis terminated, report true (UNSOUND!).")
    private boolean unknownAsTrue = false;
    @Option(secure=true, description="Do not report 'False' result, return UNKNOWN instead.  Useful for incomplete analysis with no counterexample checking.")
    private boolean reportFalseAsUnknown = false;
    private final LogManager logger;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final CoreComponentsFactory factory;
    private static final String version;

    public static String getVersion() {
        return CPAchecker.getCPAcheckerVersion() + " (" + StandardSystemProperty.JAVA_VM_NAME.value() + " " + StandardSystemProperty.JAVA_VERSION.value() + ")";
    }

    public static String getCPAcheckerVersion() {
        return version;
    }

    public CPAchecker(Configuration pConfiguration, LogManager pLogManager, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.config = pConfiguration;
        this.logger = pLogManager;
        this.shutdownNotifier = pShutdownNotifier;
        this.config.inject((Object)this);
        this.factory = new CoreComponentsFactory(pConfiguration, pLogManager, this.shutdownNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPAcheckerResult run(String programDenotation) {
        this.logger.log(Level.INFO, new Object[]{"CPAchecker", CPAchecker.getVersion(), "started"});
        MainCPAStatistics stats = null;
        ReachedSet reached = null;
        CPAcheckerResult.Result result = CPAcheckerResult.Result.NOT_YET_STARTED;
        String violatedPropertyDescription = "";
        ShutdownNotifier.ShutdownRequestListener interruptThreadOnShutdown = ShutdownNotifier.interruptCurrentThreadOnShutdown();
        this.shutdownNotifier.register(interruptThreadOnShutdown);
        try {
            Object cfa;
            Algorithm algorithm;
            stats = new MainCPAStatistics(this.config, this.logger);
            stats.creationTime.start();
            reached = this.factory.createReachedSet();
            if (this.runCBMCasExternalTool) {
                this.checkIfOneValidFile(programDenotation);
                algorithm = new ExternalCBMCAlgorithm(programDenotation, this.config, this.logger);
            } else {
                cfa = this.parse(programDenotation, stats);
                GlobalInfo.getInstance().storeCFA((CFA)cfa);
                this.shutdownNotifier.shutdownIfNecessary();
                CoreComponentsFactory.SpecAutomatonCompositionType speComposition = this.initialStatesFor.contains((Object)InitialStatesFor.TARGET) ? CoreComponentsFactory.SpecAutomatonCompositionType.BACKWARD_TO_ENTRY_SPEC : CoreComponentsFactory.SpecAutomatonCompositionType.TARGET_SPEC;
                ConfigurableProgramAnalysis cpa = this.factory.createCPA((CFA)cfa, stats, speComposition);
                GlobalInfo.getInstance().storeCPA(cpa);
                algorithm = this.factory.createAlgorithm(cpa, programDenotation, (CFA)cfa, stats);
                if (algorithm instanceof ImpactAlgorithm) {
                    ImpactAlgorithm mcmillan = (ImpactAlgorithm)algorithm;
                    reached.add(mcmillan.getInitialState(cfa.getMainFunction()), mcmillan.getInitialPrecision(cfa.getMainFunction()));
                } else {
                    this.initializeReachedSet(reached, cpa, cfa.getMainFunction(), (CFA)cfa);
                }
            }
            this.printConfigurationWarnings();
            stats.creationTime.stop();
            this.shutdownNotifier.shutdownIfNecessary();
            if (this.disableAnalysis) {
                cfa = new CPAcheckerResult(CPAcheckerResult.Result.NOT_YET_STARTED, violatedPropertyDescription, null, stats);
                return cfa;
            }
            result = CPAcheckerResult.Result.UNKNOWN;
            boolean isComplete = this.runAlgorithm(algorithm, reached, stats);
            violatedPropertyDescription = this.findViolatedProperties(reached);
            if (violatedPropertyDescription != null) {
                result = this.reportFalseAsUnknown ? CPAcheckerResult.Result.UNKNOWN : CPAcheckerResult.Result.FALSE;
            } else {
                violatedPropertyDescription = "";
                result = this.analyzeResult(reached, isComplete);
                if (this.unknownAsTrue && result == CPAcheckerResult.Result.UNKNOWN) {
                    result = CPAcheckerResult.Result.TRUE;
                }
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Could not read file");
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Parsing failed");
            StringBuilder msg = new StringBuilder();
            msg.append("Please make sure that the code can be compiled by a compiler.\n");
            if (e.getLanguage() == Language.C) {
                msg.append("If the code was not preprocessed, please use a C preprocessor\nor specify the -preprocess command-line argument.\n");
            }
            msg.append("If the error still occurs, please send this error message\ntogether with the input file to cpachecker-users@googlegroups.com.\n");
            this.logger.log(Level.INFO, new Object[]{msg});
        }
        catch (InvalidConfigurationException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, "Invalid configuration");
        }
        catch (InterruptedException e) {
            if (!Strings.isNullOrEmpty((String)e.getMessage())) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Analysis stopped");
            }
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, null);
        }
        finally {
            this.shutdownNotifier.unregister(interruptThreadOnShutdown);
        }
        return new CPAcheckerResult(result, violatedPropertyDescription, reached, stats);
    }

    private void checkIfOneValidFile(String fileDenotation) throws InvalidConfigurationException {
        if (!this.denotesOneFile(fileDenotation)) {
            throw new InvalidConfigurationException("Exactly one code file has to be given.");
        }
        Path file = Paths.get((String)fileDenotation, (String[])new String[0]);
        try {
            Files.checkReadableFile((Path)file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
    }

    private boolean denotesOneFile(String programDenotation) {
        return !programDenotation.contains(",");
    }

    private CFA parse(String fileNamesCommaSeparated, MainCPAStatistics stats) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        CFACreator cfaCreator = new CFACreator(this.config, this.logger, this.shutdownNotifier);
        stats.setCFACreator(cfaCreator);
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        CFA cfa = cfaCreator.parseFileAndCreateCFA(commaSplitter.splitToList((CharSequence)fileNamesCommaSeparated));
        stats.setCFA(cfa);
        return cfa;
    }

    private void printConfigurationWarnings() {
        Set deprecatedProperties;
        Set unusedProperties = this.config.getUnusedProperties();
        if (!unusedProperties.isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following configuration options were specified but are not used:\n", Joiner.on((String)"\n ").join((Iterable)unusedProperties), "\n"});
        }
        if (!(deprecatedProperties = this.config.getDeprecatedProperties()).isEmpty()) {
            this.logger.log(Level.WARNING, new Object[]{"The following options are deprecated and will be removed in the future:\n", Joiner.on((String)"\n ").join((Iterable)deprecatedProperties), "\n"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAlgorithm(Algorithm algorithm, ReachedSet reached, MainCPAStatistics stats) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Starting analysis ..."});
        boolean isComplete = true;
        CPAcheckerBean mxbean = new CPAcheckerBean(reached, this.logger, this.shutdownNotifier);
        stats.startAnalysisTimer();
        try {
            do {
                isComplete &= algorithm.run(reached);
            } while (!this.stopAfterError && reached.hasWaitingState());
            this.logger.log(Level.INFO, new Object[]{"Stopping analysis ..."});
            boolean bl = isComplete;
            return bl;
        }
        finally {
            stats.stopAnalysisTimer();
            mxbean.unregister();
        }
    }

    @Nullable
    private String findViolatedProperties(ReachedSet reached) {
        Set descriptions = (Set)FluentIterable.from((Iterable)reached).filter(AbstractStates.IS_TARGET_STATE).transform((Function)new Function<AbstractState, String>(){

            public String apply(AbstractState s) {
                return ((Targetable)((Object)s)).getViolatedPropertyDescription();
            }
        }).copyInto(new HashSet());
        if (descriptions.isEmpty()) {
            return null;
        }
        descriptions.remove("");
        return Joiner.on((String)", ").join((Iterable)descriptions);
    }

    private CPAcheckerResult.Result analyzeResult(ReachedSet reached, boolean isSound) {
        if (reached.hasWaitingState()) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis not completed: there are still states to be processed."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        if (!isSound) {
            this.logger.log(Level.WARNING, new Object[]{"Analysis incomplete: no errors found, but not everything could be checked."});
            return CPAcheckerResult.Result.UNKNOWN;
        }
        return CPAcheckerResult.Result.TRUE;
    }

    private void addToInitialReachedSet(Set<? extends CFANode> pLocations, Object pPartitionKey, ReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        for (CFANode cFANode : pLocations) {
            StateSpacePartition putIntoPartition = this.partitionInitialStates ? StateSpacePartition.getPartitionWithKey(pPartitionKey) : StateSpacePartition.getDefaultPartition();
            AbstractState initialState = pCpa.getInitialState(cFANode, putIntoPartition);
            Precision initialPrecision = pCpa.getInitialPrecision(cFANode, putIntoPartition);
            pReached.add(initialState, initialPrecision);
        }
    }

    private void initializeReachedSet(ReachedSet pReached, ConfigurableProgramAnalysis pCpa, FunctionEntryNode pAnalysisEntryFunction, CFA pCfa) throws InvalidConfigurationException {
        this.logger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        for (InitialStatesFor isf : this.initialStatesFor) {
            ImmutableSet<CFANode> initialLocations;
            switch (isf) {
                case ENTRY: {
                    initialLocations = ImmutableSet.of((Object)pAnalysisEntryFunction);
                    break;
                }
                case EXIT: {
                    initialLocations = ImmutableSet.of((Object)pAnalysisEntryFunction.getExitNode());
                    break;
                }
                case FUNCTION_ENTRIES: {
                    initialLocations = ImmutableSet.copyOf(pCfa.getAllFunctionHeads());
                    break;
                }
                case FUNCTION_SINKS: {
                    initialLocations = ImmutableSet.builder().addAll(this.getAllEndlessLoopHeads((LoopStructure)pCfa.getLoopStructure().get())).addAll(this.getAllFunctionExitNodes(pCfa)).build();
                    break;
                }
                case PROGRAM_SINKS: {
                    ImmutableSet.Builder builder = ImmutableSet.builder().addAll(this.getAllEndlessLoopHeads((LoopStructure)pCfa.getLoopStructure().get()));
                    if (pCfa.getAllNodes().contains(pAnalysisEntryFunction.getExitNode())) {
                        builder.add((Object)pAnalysisEntryFunction.getExitNode());
                    }
                    initialLocations = builder.build();
                    break;
                }
                case TARGET: {
                    TargetLocationProvider tlp = new TargetLocationProvider(this.factory.getReachedSetFactory(), this.shutdownNotifier, this.logger, this.config, pCfa);
                    initialLocations = tlp.tryGetAutomatonTargetLocations(pAnalysisEntryFunction);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled case statement: " + this.initialStatesFor));
                }
            }
            this.addToInitialReachedSet((Set<? extends CFANode>)initialLocations, (Object)isf, pReached, pCpa);
        }
        if (pReached.getWaitlistSize() == 0) {
            throw new InvalidConfigurationException("Initialization of the set of initial states failed: No analysis target found!");
        }
    }

    private Set<CFANode> getAllFunctionExitNodes(CFA cfa) {
        HashSet<CFANode> functionExitNodes = new HashSet<CFANode>();
        for (FunctionEntryNode node : cfa.getAllFunctionHeads()) {
            FunctionExitNode exitNode = node.getExitNode();
            if (!cfa.getAllNodes().contains(exitNode)) continue;
            functionExitNodes.add(exitNode);
        }
        return functionExitNodes;
    }

    private Set<CFANode> getAllEndlessLoopHeads(LoopStructure structure) {
        ImmutableCollection<LoopStructure.Loop> loops = structure.getAllLoops();
        HashSet<CFANode> loopHeads = new HashSet<CFANode>();
        for (LoopStructure.Loop l : loops) {
            if (!l.getOutgoingEdges().isEmpty()) continue;
            for (CFANode head : l.getLoopHeads()) {
                loopHeads.add(head);
            }
        }
        return loopHeads;
    }

    static {
        String v = "(unknown version)";
        try {
            String content;
            URL url = CPAchecker.class.getClassLoader().getResource("org/sosy_lab/cpachecker/VERSION.txt");
            if (url != null && (content = Resources.toString((URL)url, (Charset)StandardCharsets.US_ASCII).trim()).matches("[a-zA-Z0-9 ._+:-]+")) {
                v = content;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = v;
    }

    public static enum InitialStatesFor {
        ENTRY,
        FUNCTION_ENTRIES,
        TARGET,
        EXIT,
        FUNCTION_SINKS,
        PROGRAM_SINKS;

    }

    private static class CPAcheckerBean
    extends AbstractMBean
    implements CPAcheckerMXBean {
        private final ReachedSet reached;
        private final ShutdownNotifier shutdownNotifier;

        public CPAcheckerBean(ReachedSet pReached, LogManager logger, ShutdownNotifier pShutdownNotifier) {
            super("org.sosy_lab.cpachecker:type=CPAchecker", logger);
            this.reached = pReached;
            this.shutdownNotifier = pShutdownNotifier;
            this.register();
        }

        @Override
        public int getReachedSetSize() {
            return this.reached.size();
        }

        @Override
        public void stop() {
            this.shutdownNotifier.requestShutdown("A stop request was received via the JMX interface.");
        }
    }

    public static interface CPAcheckerMXBean {
        public int getReachedSetSize();

        public void stop();
    }
}

