/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class CPAcheckerResult {
    private final Result result;
    private final String violatedPropertyDescription;
    @Nullable
    private final ReachedSet reached;
    @Nullable
    private final Statistics stats;
    @Nullable
    private Statistics proofGeneratorStats = null;

    CPAcheckerResult(Result result, String violatedPropertyDescription, @Nullable ReachedSet reached, @Nullable Statistics stats) {
        this.violatedPropertyDescription = (String)Preconditions.checkNotNull((Object)violatedPropertyDescription);
        this.result = (Result)((Object)Preconditions.checkNotNull((Object)((Object)result)));
        this.reached = reached;
        this.stats = stats;
    }

    public Result getResult() {
        return this.result;
    }

    public UnmodifiableReachedSet getReached() {
        return this.reached;
    }

    public void addProofGeneratorStatistics(Statistics pProofGeneratorStatistics) {
        this.proofGeneratorStats = pProofGeneratorStatistics;
    }

    public void printStatistics(PrintStream target) {
        if (this.stats != null) {
            this.stats.printStatistics(target, this.result, this.reached);
        }
        if (this.proofGeneratorStats != null) {
            this.proofGeneratorStats.printStatistics(target, this.result, this.reached);
        }
    }

    public void printResult(PrintStream out) {
        if (this.result == Result.NOT_YET_STARTED) {
            return;
        }
        out.print("Verification result: ");
        out.println(this.getResultString());
    }

    public String getResultString() {
        switch (this.result) {
            case UNKNOWN: {
                return "UNKNOWN, incomplete analysis.";
            }
            case FALSE: {
                StringBuilder sb = new StringBuilder();
                sb.append("FALSE. Property violation");
                if (!this.violatedPropertyDescription.isEmpty()) {
                    sb.append(" (").append(this.violatedPropertyDescription).append(")");
                }
                sb.append(" found by chosen configuration.");
                return sb.toString();
            }
            case TRUE: {
                return "TRUE. No property violation found by chosen configuration.";
            }
        }
        return "UNKNOWN result: " + (Object)((Object)this.result);
    }

    public static enum Result {
        NOT_YET_STARTED,
        UNKNOWN,
        FALSE,
        TRUE;

    }
}

