/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.MainCPAStatistics;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.BDDCPARestrictionAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CustomInstructionRequirementsExtractingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.PredicatedAnalysisAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestartWithConditionsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.ImpactAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.AlgorithmWithPropertyCheck;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ResultCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionRefinerAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="analysis")
public class CoreComponentsFactory {
    @Option(secure=true, description="use assumption collecting algorithm")
    private boolean collectAssumptions = false;
    @Option(secure=true, name="algorithm.conditionAdjustment", description="use adjustable conditions algorithm")
    private boolean useAdjustableConditions = false;
    @Option(secure=true, name="algorithm.CEGAR", description="use CEGAR algorithm for lazy counter-example guided analysis\nYou need to specify a refiner with the cegar.refiner option.\nCurrently all refiner require the use of the ARGCPA.")
    private boolean useCEGAR = false;
    @Option(secure=true, description="use a second model checking run (e.g., with CBMC or a different CPAchecker configuration) to double-check counter-examples")
    private boolean checkCounterexamples = false;
    @Option(secure=true, name="checkCounterexamplesWithBDDCPARestriction", description="use counterexample check and the BDDCPA Restriction option")
    private boolean useBDDCPARestriction = false;
    @Option(secure=true, name="algorithm.BMC", description="use a BMC like algorithm that checks for satisfiability after the analysis has finished, works only with PredicateCPA")
    private boolean useBMC = false;
    @Option(secure=true, name="algorithm.impact", description="Use McMillan's Impact algorithm for lazy interpolation")
    private boolean useImpactAlgorithm = false;
    @Option(secure=true, name="restartAfterUnknown", description="restart the analysis using a different configuration after unknown result")
    private boolean useRestartingAlgorithm = false;
    @Option(secure=true, name="algorithm.predicatedAnalysis", description="use a predicated analysis which proves if the program satisfies a specified property with the help of a PredicateCPA to separate differnt program paths")
    private boolean usePredicatedAnalysisAlgorithm = false;
    @Option(secure=true, name="algorithm.proofCheck", description="use a proof check algorithm to validate a previously generated proof")
    private boolean useProofCheckAlgorithm = false;
    @Option(secure=true, name="algorithm.propertyCheck", description="do analysis and then check if reached set fulfills property specified by ConfigurableProgramAnalysisWithPropertyChecker")
    private boolean usePropertyCheckingAlgorithm = false;
    @Option(secure=true, name="algorithm.testGen", description="use the TestGen Algorithm")
    private boolean useTestGenAlgorithm = false;
    @Option(secure=true, name="checkProof", description="do analysis and then check analysis result")
    private boolean useResultCheckAlgorithm = false;
    @Option(secure=true, name="extractRequirements.customInstruction", description="do analysis and then extract pre- and post conditions for custom instruction from analysis result")
    private boolean useCustomInstructionRequirementExtraction = false;
    @Option(secure=true, name="refinePreconditions", description="Refine the preconditions until the set of unsafe and safe states are disjoint.")
    private boolean usePreconditionRefinementAlgorithm = false;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final ReachedSetFactory reachedSetFactory;
    private final CPABuilder cpaFactory;

    public CoreComponentsFactory(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.config.inject((Object)this);
        this.reachedSetFactory = new ReachedSetFactory(this.config, this.logger);
        this.cpaFactory = new CPABuilder(this.config, this.logger, this.shutdownNotifier, this.reachedSetFactory);
    }

    public Algorithm createAlgorithm(ConfigurableProgramAnalysis cpa, String programDenotation, CFA cfa, @Nullable MainCPAStatistics stats) throws InvalidConfigurationException, CPAException {
        Algorithm algorithm;
        this.logger.log(Level.FINE, new Object[]{"Creating algorithms"});
        if (this.useProofCheckAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Proof Check Algorithm"});
            algorithm = new ProofCheckAlgorithm(cpa, this.config, this.logger, this.shutdownNotifier);
        } else if (this.useRestartingAlgorithm) {
            this.logger.log(Level.INFO, new Object[]{"Using Restarting Algorithm"});
            algorithm = new RestartAlgorithm(this.config, this.logger, this.shutdownNotifier, programDenotation, cfa);
        } else if (this.useImpactAlgorithm) {
            algorithm = new ImpactAlgorithm(this.config, this.logger, this.shutdownNotifier, cpa, cfa);
        } else {
            algorithm = CPAAlgorithm.create(cpa, this.logger, this.config, this.shutdownNotifier, stats);
            if (this.usePredicatedAnalysisAlgorithm) {
                algorithm = new PredicatedAnalysisAlgorithm(algorithm, cpa, cfa, this.logger, this.config, this.shutdownNotifier);
            }
            if (this.useCEGAR) {
                algorithm = new CEGARAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useBMC) {
                algorithm = new BMCAlgorithm(algorithm, cpa, this.config, this.logger, this.reachedSetFactory, this.shutdownNotifier, cfa);
            }
            if (this.checkCounterexamples) {
                algorithm = new CounterexampleCheckAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier, cfa, programDenotation);
            }
            if (this.useBDDCPARestriction) {
                algorithm = new BDDCPARestrictionAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier, cfa, programDenotation);
            }
            if (this.collectAssumptions) {
                algorithm = new AssumptionCollectorAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useAdjustableConditions) {
                algorithm = new RestartWithConditionsAlgorithm(algorithm, cpa, this.config, this.logger);
            }
            if (this.useTestGenAlgorithm) {
                algorithm = new TestGenAlgorithm(algorithm, cpa, this.shutdownNotifier, cfa, this.config, this.logger);
            }
            if (this.usePropertyCheckingAlgorithm) {
                if (!(cpa instanceof PropertyCheckerCPA)) {
                    throw new InvalidConfigurationException("Property checking algorithm requires CPAWithPropertyChecker as Top CPA");
                }
                algorithm = new AlgorithmWithPropertyCheck(algorithm, this.logger, (PropertyCheckerCPA)cpa);
            }
            if (this.useResultCheckAlgorithm) {
                algorithm = new ResultCheckAlgorithm(algorithm, cpa, cfa, this.config, this.logger, this.shutdownNotifier);
            }
            if (this.useCustomInstructionRequirementExtraction) {
                algorithm = new CustomInstructionRequirementsExtractingAlgorithm(algorithm, cpa, this.config, this.logger, this.shutdownNotifier, cfa);
            }
            if (this.usePreconditionRefinementAlgorithm) {
                algorithm = new PreconditionRefinerAlgorithm(algorithm, cpa, cfa, this.config, this.logger, this.shutdownNotifier);
            }
        }
        if (stats != null && algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)algorithm)).collectStatistics(stats.getSubStatistics());
        }
        return algorithm;
    }

    public ReachedSetFactory getReachedSetFactory() {
        return this.reachedSetFactory;
    }

    public ReachedSet createReachedSet() {
        ReachedSet reached = this.reachedSetFactory.create();
        if (this.useRestartingAlgorithm) {
            reached = new ForwardingReachedSet(reached);
        }
        return reached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableProgramAnalysis createCPA(CFA cfa, @Nullable MainCPAStatistics stats, SpecAutomatonCompositionType composeWithSpecificationCPAs) throws InvalidConfigurationException, CPAException {
        this.logger.log(Level.FINE, new Object[]{"Creating CPAs"});
        if (stats != null) {
            stats.cpaCreationTime.start();
        }
        try {
            ConfigurableProgramAnalysis cpa;
            if (this.useRestartingAlgorithm) {
                ConfigurableProgramAnalysis configurableProgramAnalysis = LocationCPA.factory().set(cfa, CFA.class).setConfiguration(this.config).createInstance();
                return configurableProgramAnalysis;
            }
            switch (composeWithSpecificationCPAs) {
                case TARGET_SPEC: {
                    cpa = this.cpaFactory.buildCPAWithSpecAutomatas(cfa);
                    break;
                }
                case BACKWARD_TO_ENTRY_SPEC: {
                    cpa = this.cpaFactory.buildCPAWithBackwardSpecAutomatas(cfa);
                    break;
                }
                default: {
                    cpa = this.cpaFactory.buildCPAs(cfa, null);
                }
            }
            if (stats != null && cpa instanceof StatisticsProvider) {
                ((StatisticsProvider)((Object)cpa)).collectStatistics(stats.getSubStatistics());
            }
            ConfigurableProgramAnalysis configurableProgramAnalysis = cpa;
            return configurableProgramAnalysis;
        }
        finally {
            if (stats != null) {
                stats.cpaCreationTime.stop();
            }
        }
    }

    public static enum SpecAutomatonCompositionType {
        NONE,
        TARGET_SPEC,
        BACKWARD_TO_ENTRY_SPEC;

    }
}

