/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;

public class CounterexampleInfo {
    private final boolean spurious;
    private final ARGPath targetPath;
    private final Model model;
    private final Collection<Pair<Object, PathTemplate>> furtherInfo;
    private static final CounterexampleInfo SPURIOUS = new CounterexampleInfo(true, null, null);

    private CounterexampleInfo(boolean pSpurious, ARGPath pTargetPath, Model pModel) {
        this.spurious = pSpurious;
        this.targetPath = pTargetPath;
        this.model = pModel;
        this.furtherInfo = !this.spurious ? Lists.newArrayListWithExpectedSize((int)1) : null;
    }

    public static CounterexampleInfo spurious() {
        return SPURIOUS;
    }

    public static CounterexampleInfo feasible(ARGPath pTargetPath, Model pModel) {
        return new CounterexampleInfo(false, (ARGPath)Preconditions.checkNotNull((Object)pTargetPath), (Model)((Object)Preconditions.checkNotNull((Object)((Object)pModel))));
    }

    public boolean isSpurious() {
        return this.spurious;
    }

    public ARGPath getTargetPath() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.targetPath;
    }

    public Model getTargetPathModel() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return this.model;
    }

    public void addFurtherInformation(Object info, PathTemplate dumpFile) {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        this.furtherInfo.add((Pair<Object, PathTemplate>)Pair.of((Object)Preconditions.checkNotNull((Object)info), (Object)dumpFile));
    }

    public Collection<Pair<Object, PathTemplate>> getAllFurtherInformation() {
        Preconditions.checkState((!this.spurious ? 1 : 0) != 0);
        return Collections.unmodifiableCollection(this.furtherInfo);
    }
}

