/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.management.JMException;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.export.DOTBuilder;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AlgorithmIterationListener;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.IterationStatistics;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;
import org.sosy_lab.cpachecker.util.coverage.CoverageInformation;
import org.sosy_lab.cpachecker.util.resources.MemoryStatistics;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTime;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options
class MainCPAStatistics
implements Statistics,
AlgorithmIterationListener {
    private static final int MAX_SIZE_FOR_REACHED_STATISTICS = 1000000;
    @Option(secure=true, name="reachedSet.export", description="print reached set to text file")
    private boolean exportReachedSet = false;
    @Option(secure=true, name="reachedSet.file", description="print reached set to text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reachedSetFile = Paths.get((String)"reached.txt", (String[])new String[0]);
    @Option(secure=true, name="reachedSet.dot", description="print reached set to graph file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path reachedSetGraphDumpPath = Paths.get((String)"reached.dot", (String[])new String[0]);
    @Option(secure=true, name="coverage.export", description="print coverage info to file")
    private boolean exportCoverage = true;
    @Option(secure=true, name="coverage.file", description="print coverage info to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputCoverageFile = Paths.get((String)"coverage.info", (String[])new String[0]);
    @Option(secure=true, name="statistics.memory", description="track memory usage of JVM during runtime")
    private boolean monitorMemoryUsage = true;
    private final LogManager logger;
    private final Collection<Statistics> subStats;
    private final MemoryStatistics memStats;
    private Thread memStatsThread;
    private Collection<IterationStatistics> iterationStats;
    private final Timer programTime = new Timer();
    final Timer creationTime = new Timer();
    final Timer cpaCreationTime = new Timer();
    private final Timer analysisTime = new Timer();
    private long programCpuTime;
    private long analysisCpuTime = 0L;
    private Statistics cfaCreatorStatistics;
    private CFA cfa;

    public MainCPAStatistics(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        config.inject((Object)this);
        this.subStats = new ArrayList<Statistics>();
        if (this.monitorMemoryUsage) {
            this.memStats = new MemoryStatistics(pLogger);
            this.memStatsThread = Threads.newThread((Runnable)this.memStats, (String)"CPAchecker memory statistics collector", (boolean)true);
            this.memStatsThread.start();
        } else {
            this.memStats = null;
        }
        this.programTime.start();
        try {
            this.programCpuTime = ProcessCpuTime.read();
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Your Java VM does not support measuring the cpu time, some statistics will be missing."});
            this.programCpuTime = -1L;
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
            this.programCpuTime = -1L;
        }
    }

    public Collection<Statistics> getSubStatistics() {
        return this.subStats;
    }

    @Override
    public String getName() {
        return "CPAchecker";
    }

    void startAnalysisTimer() {
        this.analysisTime.start();
        try {
            this.analysisCpuTime = ProcessCpuTime.read();
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.analysisCpuTime = -1L;
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
            this.analysisCpuTime = -1L;
        }
    }

    void stopAnalysisTimer() {
        this.analysisTime.stop();
        this.programTime.stop();
        try {
            long stopCpuTime = ProcessCpuTime.read();
            if (this.programCpuTime >= 0L) {
                this.programCpuTime = stopCpuTime - this.programCpuTime;
            }
            if (this.analysisCpuTime >= 0L) {
                this.analysisCpuTime = stopCpuTime - this.analysisCpuTime;
            }
        }
        catch (JMException e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
        }
        catch (NoClassDefFoundError e) {
            this.logger.logDebugException((Throwable)e, "Querying cpu time failed");
            this.logger.log(Level.WARNING, new Object[]{"Google App Engine does not support measuring the cpu time."});
        }
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        Preconditions.checkNotNull((Object)out);
        Preconditions.checkNotNull((Object)((Object)result));
        Preconditions.checkArgument((result == CPAcheckerResult.Result.NOT_YET_STARTED || reached != null ? 1 : 0) != 0);
        if (this.analysisTime.isRunning()) {
            this.analysisTime.stop();
        }
        if (this.programTime.isRunning()) {
            this.programTime.stop();
        }
        if (this.memStats != null) {
            this.memStatsThread.interrupt();
        }
        if (result != CPAcheckerResult.Result.NOT_YET_STARTED) {
            this.dumpReachedSet(reached);
            this.printSubStatistics(out, result, reached);
            if (this.exportCoverage && this.outputCoverageFile != null && this.cfa != null) {
                CoverageInformation.writeCoverageInfo(this.outputCoverageFile, reached, this.cfa, this.logger);
            }
        }
        out.println("CPAchecker general statistics");
        out.println("-----------------------------");
        this.printCfaStatistics(out);
        if (result != CPAcheckerResult.Result.NOT_YET_STARTED) {
            try {
                this.printReachedSetStatistics(reached, out);
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Out of memory while generating statistics about final reached set");
            }
        }
        out.println();
        this.printTimeStatistics(out, result, reached);
        out.println();
        this.printMemoryStatistics(out);
    }

    private void dumpReachedSet(ReachedSet reached) {
        this.dumpReachedSet(reached, this.reachedSetFile, false);
        this.dumpReachedSet(reached, this.reachedSetGraphDumpPath, true);
    }

    private void dumpReachedSet(ReachedSet reached, Path pOutputFile, boolean writeDotFormat) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        if (this.exportReachedSet && pOutputFile != null) {
            try (Writer w = Files.openOutputFile((Path)pOutputFile, (FileWriteMode[])new FileWriteMode[0]);){
                if (writeDotFormat) {
                    this.dumpLocationMappedReachedSet(reached, this.cfa, w);
                } else {
                    Joiner.on((char)'\n').appendTo((Appendable)w, (Iterable)reached);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file");
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file due to memory problems");
            }
        }
    }

    private void dumpLocationMappedReachedSet(ReachedSet pReachedSet, CFA cfa, Appendable sb) throws IOException {
        ImmutableListMultimap locationIndex = Multimaps.index((Iterable)pReachedSet, AbstractStates.EXTRACT_LOCATION);
        Function<CFANode, String> nodeLabelFormatter = new Function<CFANode, String>((ListMultimap)locationIndex){
            final /* synthetic */ ListMultimap val$locationIndex;
            {
                this.val$locationIndex = listMultimap;
            }

            public String apply(CFANode node) {
                StringBuilder buf = new StringBuilder();
                buf.append(node.getNodeNumber()).append("\n");
                for (AbstractState state : this.val$locationIndex.get((Object)node)) {
                    if (!(state instanceof Graphable)) continue;
                    buf.append(((Graphable)((Object)state)).toDOTLabel());
                }
                return buf.toString();
            }
        };
        DOTBuilder.generateDOT(sb, cfa, nodeLabelFormatter);
    }

    private void printSubStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        for (Statistics s : this.subStats) {
            String name = s.getName();
            if (!Strings.isNullOrEmpty((String)name)) {
                name = name + " statistics";
                out.println(name);
                out.println(Strings.repeat((String)"-", (int)name.length()));
            }
            try {
                s.printStatistics(out, result, reached);
            }
            catch (OutOfMemoryError e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Out of memory while generating statistics and writing output files");
            }
            if (Strings.isNullOrEmpty((String)name)) continue;
            out.println();
        }
    }

    private void printReachedSetStatistics(ReachedSet reached, PrintStream out) {
        assert (reached != null) : "ReachedSet may be null only if analysis not yet started";
        if (reached instanceof ForwardingReachedSet) {
            reached = ((ForwardingReachedSet)reached).getDelegate();
        }
        int reachedSize = reached.size();
        out.println("Size of reached set:             " + reachedSize);
        if (!reached.isEmpty()) {
            if (reachedSize < 1000000) {
                this.printReachedSetStatisticsDetails(reached, out);
            }
            if (reached.hasWaitingState()) {
                out.println("  Size of final wait list        " + reached.getWaitlistSize());
            }
        }
    }

    private void printReachedSetStatisticsDetails(ReachedSet reached, PrintStream out) {
        Set locations;
        int reachedSize = reached.size();
        CFANode mostFrequentLocation = null;
        int mostFrequentLocationCount = 0;
        if (reached instanceof LocationMappedReachedSet) {
            LocationMappedReachedSet l = (LocationMappedReachedSet)reached;
            locations = l.getLocations();
            Map.Entry<Object, Collection<AbstractState>> maxPartition = l.getMaxPartition();
            mostFrequentLocation = (CFANode)maxPartition.getKey();
            mostFrequentLocationCount = maxPartition.getValue().size();
        } else {
            HashMultiset allLocations = HashMultiset.create((Iterable)FluentIterable.from((Iterable)reached).transform(AbstractStates.EXTRACT_LOCATION).filter(Predicates.notNull()));
            locations = allLocations.elementSet();
            for (Multiset.Entry location : allLocations.entrySet()) {
                int size = location.getCount();
                if (size > mostFrequentLocationCount) {
                    mostFrequentLocationCount = size;
                    mostFrequentLocation = (CFANode)location.getElement();
                    continue;
                }
                if (size != mostFrequentLocationCount) continue;
                mostFrequentLocation = (CFANode)Ordering.natural().min((Object)mostFrequentLocation, location.getElement());
            }
        }
        if (!locations.isEmpty()) {
            int locs = locations.size();
            out.println("  Number of reached locations:   " + locs + " (" + StatisticsUtils.toPercent(locs, this.cfa.getAllNodes().size()) + ")");
            out.println("    Avg states per location:     " + reachedSize / locs);
            out.println("    Max states per location:     " + mostFrequentLocationCount + " (at node " + mostFrequentLocation + ")");
            ImmutableSet functions = FluentIterable.from((Iterable)locations).transform(CFAUtils.GET_FUNCTION).toSet();
            out.println("  Number of reached functions:   " + functions.size() + " (" + StatisticsUtils.toPercent(functions.size(), this.cfa.getNumberOfFunctions()) + ")");
        }
        if (reached instanceof PartitionedReachedSet) {
            PartitionedReachedSet p = (PartitionedReachedSet)reached;
            int partitions = p.getNumberOfPartitions();
            out.println("  Number of partitions:          " + partitions);
            out.println("    Avg size of partitions:      " + reachedSize / partitions);
            Map.Entry<Object, Collection<AbstractState>> maxPartition = p.getMaxPartition();
            out.print("    Max size of partitions:      " + maxPartition.getValue().size());
            if (maxPartition.getValue().size() > 1) {
                out.println(" (with key " + maxPartition.getKey() + ")");
            } else {
                out.println();
            }
        }
        out.println("  Number of target states:       " + FluentIterable.from((Iterable)reached).filter(AbstractStates.IS_TARGET_STATE).size());
    }

    private void printCfaStatistics(PrintStream out) {
        if (this.cfa != null) {
            int edges = 0;
            for (CFANode n : this.cfa.getAllNodes()) {
                edges += n.getNumEnteringEdges();
            }
            out.println("Number of program locations:     " + this.cfa.getAllNodes().size());
            out.println("Number of CFA edges:             " + edges);
            if (this.cfa.getVarClassification().isPresent()) {
                out.println("Number of relevant variables:    " + ((VariableClassification)this.cfa.getVarClassification().get()).getRelevantVariables().size());
            }
            out.println("Number of functions:             " + this.cfa.getNumberOfFunctions());
            if (this.cfa.getLoopStructure().isPresent()) {
                int loops = ((LoopStructure)this.cfa.getLoopStructure().get()).getCount();
                out.println("Number of loops:                 " + loops);
            }
        }
    }

    private void printTimeStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        out.println("Time for analysis setup:      " + this.creationTime);
        out.println("  Time for loading CPAs:      " + this.cpaCreationTime);
        if (this.cfaCreatorStatistics != null) {
            this.cfaCreatorStatistics.printStatistics(out, result, reached);
        }
        out.println("Time for Analysis:            " + this.analysisTime);
        out.println("CPU time for analysis:        " + TimeSpan.ofNanos((long)this.analysisCpuTime).formatAs(TimeUnit.SECONDS));
        out.println("Total time for CPAchecker:    " + this.programTime);
        out.println("Total CPU time for CPAchecker:" + TimeSpan.ofNanos((long)this.programCpuTime).formatAs(TimeUnit.SECONDS));
    }

    private void printMemoryStatistics(PrintStream out) {
        if (this.monitorMemoryUsage) {
            MemoryStatistics.printGcStatistics(out);
            if (this.memStats != null) {
                try {
                    this.memStatsThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.memStatsThread.isAlive()) {
                    this.memStats.printStatistics(out);
                }
            }
        }
    }

    public void setCFACreator(CFACreator pCfaCreator) {
        Preconditions.checkState((this.cfaCreatorStatistics == null ? 1 : 0) != 0);
        this.cfaCreatorStatistics = pCfaCreator.getStatistics();
    }

    public void setCFA(CFA pCfa) {
        Preconditions.checkState((this.cfa == null ? 1 : 0) != 0);
        this.cfa = pCfa;
    }

    @Override
    public void afterAlgorithmIteration(Algorithm pAlg, ReachedSet pReached) {
        if (this.iterationStats == null) {
            this.iterationStats = Lists.newArrayList();
            for (Statistics statistics : this.subStats) {
                if (!(statistics instanceof IterationStatistics)) continue;
                this.iterationStats.add((IterationStatistics)statistics);
            }
        }
        for (IterationStatistics iterationStatistics : this.iterationStats) {
            iterationStatistics.printIterationStatistics(System.out, pReached);
        }
    }
}

