/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
public final class ShutdownNotifier {
    private final AtomicReference<String> shutdownRequested = new AtomicReference();
    private final Set<ShutdownRequestListener> listeners = Collections.newSetFromMap(new MapMaker().concurrencyLevel(1).weakKeys().makeMap());
    @GuardedBy(value="listeners")
    private boolean listenersNotified = false;
    private final ShutdownRequestListener ourListener = new ShutdownRequestListener(){

        @Override
        public void shutdownRequested(String reason) {
            ShutdownNotifier.this.requestShutdown(reason);
        }
    };

    private ShutdownNotifier() {
    }

    public static ShutdownNotifier create() {
        return new ShutdownNotifier();
    }

    public static ShutdownNotifier createWithParent(ShutdownNotifier parent) {
        ShutdownNotifier child = ShutdownNotifier.create();
        parent.registerAndCheckImmediately(child.ourListener);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShutdown(String pReason) {
        Preconditions.checkNotNull((Object)pReason);
        if (this.shutdownRequested.compareAndSet(null, pReason)) {
            Set<ShutdownRequestListener> set = this.listeners;
            synchronized (set) {
                assert (!this.listenersNotified);
                this.listenersNotified = true;
                for (ShutdownRequestListener listener : this.listeners) {
                    listener.shutdownRequested(pReason);
                }
                this.listeners.clear();
            }
        }
    }

    public boolean shouldShutdown() {
        return this.shutdownRequested.get() != null;
    }

    public void shutdownIfNecessary() throws InterruptedException {
        if (this.shouldShutdown()) {
            throw new InterruptedException(this.getReason());
        }
    }

    public String getReason() {
        String reason = this.shutdownRequested.get();
        Preconditions.checkState((reason != null ? 1 : 0) != 0, (Object)"Cannot call getReason() on an instance with no shutdown request.");
        return reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ShutdownRequestListener listener) {
        Preconditions.checkNotNull((Object)listener);
        Set<ShutdownRequestListener> set = this.listeners;
        synchronized (set) {
            if (!this.listenersNotified) {
                boolean freshListener = this.listeners.add(listener);
                Preconditions.checkArgument((boolean)freshListener, (Object)"Not allowed to register listeners twice");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAndCheckImmediately(ShutdownRequestListener listener) {
        Set<ShutdownRequestListener> set = this.listeners;
        synchronized (set) {
            this.register(listener);
            if (this.listenersNotified) {
                String reason = this.getReason();
                listener.shutdownRequested(reason);
            }
        }
    }

    public void unregister(ShutdownRequestListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    public static ShutdownRequestListener interruptCurrentThreadOnShutdown() {
        final Thread currentThread = Thread.currentThread();
        return new ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String pReason) {
                currentThread.interrupt();
            }
        };
    }

    public static interface ShutdownRequestListener {
        public void shutdownRequested(String var1);
    }
}

