/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;

public class ShutdownNotifierTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final String reason = "Shutdown Request Reason";
    private ShutdownNotifier instance = null;

    @Before
    public void setUp() {
        this.instance = ShutdownNotifier.create();
    }

    @After
    public void tearDown() {
        this.instance = null;
    }

    @Test
    public void testNotRequested() throws InterruptedException {
        Assert.assertFalse((boolean)this.instance.shouldShutdown());
        this.instance.shutdownIfNecessary();
    }

    @Test
    public void testNotRequestedReason() throws InterruptedException {
        this.thrown.expect(IllegalStateException.class);
        this.instance.getReason();
    }

    @Test
    public void testRequested() throws InterruptedException {
        this.instance.requestShutdown(reason);
        Assert.assertTrue((boolean)this.instance.shouldShutdown());
        Assert.assertEquals((Object)reason, (Object)this.instance.getReason());
    }

    @Test
    public void testRequestedException() throws InterruptedException {
        this.instance.requestShutdown(reason);
        this.thrown.expect(InterruptedException.class);
        this.thrown.expectMessage(reason);
        this.instance.shutdownIfNecessary();
    }

    @Test
    public void testRegisterListenerTwice() {
        ShutdownNotifier.ShutdownRequestListener l = new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
            }
        };
        this.instance.register(l);
        this.thrown.expect(IllegalArgumentException.class);
        this.instance.register(l);
    }

    @Test
    public void testListenerNotification() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        this.instance.register(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                flag.set(true);
            }
        });
        this.instance.requestShutdown(reason);
        Assert.assertTrue((boolean)flag.get());
    }

    @Test
    public void testListenerNotificationReason() {
        final AtomicReference reasonReference = new AtomicReference();
        this.instance.register(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String pReason) {
                reasonReference.set(pReason);
            }
        });
        this.instance.requestShutdown(reason);
        Assert.assertEquals((Object)reason, reasonReference.get());
    }

    @Test
    public void testListenerNotification10() {
        int count = 10;
        final AtomicInteger i = new AtomicInteger(0);
        for (int j = 0; j < 10; ++j) {
            this.instance.register(new ShutdownNotifier.ShutdownRequestListener(){

                @Override
                public void shutdownRequested(String reason) {
                    i.incrementAndGet();
                }
            });
        }
        this.instance.requestShutdown(reason);
        Assert.assertEquals((long)10L, (long)i.get());
    }

    @Test
    public void testUnregisterListener() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        ShutdownNotifier.ShutdownRequestListener l = new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                flag.set(true);
            }
        };
        this.instance.register(l);
        this.instance.unregister(l);
        this.instance.requestShutdown(reason);
        Assert.assertFalse((boolean)flag.get());
    }

    @Test
    public void testListenerRegisterAndCheck() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        this.instance.registerAndCheckImmediately(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                flag.set(true);
            }
        });
        Assert.assertFalse((boolean)flag.get());
        this.instance.requestShutdown(reason);
        Assert.assertTrue((boolean)flag.get());
    }

    @Test
    public void testListenerNotificationOnRegister() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        this.instance.requestShutdown(reason);
        this.instance.registerAndCheckImmediately(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                flag.set(true);
            }
        });
        Assert.assertTrue((boolean)flag.get());
    }

    @Test
    public void testListenerNotificationReasonOnRegister() {
        final AtomicReference reasonReference = new AtomicReference();
        this.instance.requestShutdown(reason);
        this.instance.registerAndCheckImmediately(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String pReason) {
                reasonReference.set(pReason);
            }
        });
        Assert.assertEquals((Object)reason, reasonReference.get());
    }

    @Test
    public void testParentChild() {
        ShutdownNotifier child = ShutdownNotifier.createWithParent(this.instance);
        Assert.assertFalse((boolean)this.instance.shouldShutdown());
        Assert.assertFalse((boolean)child.shouldShutdown());
        this.instance.requestShutdown(reason);
        Assert.assertTrue((boolean)child.shouldShutdown());
        Assert.assertEquals((Object)reason, (Object)child.getReason());
    }

    @Test
    public void testChildParent() {
        ShutdownNotifier child = ShutdownNotifier.createWithParent(this.instance);
        Assert.assertFalse((boolean)this.instance.shouldShutdown());
        Assert.assertFalse((boolean)child.shouldShutdown());
        child.requestShutdown(reason);
        Assert.assertFalse((boolean)this.instance.shouldShutdown());
        Assert.assertTrue((boolean)child.shouldShutdown());
        Assert.assertEquals((Object)reason, (Object)child.getReason());
    }

    @Test
    public void testParentChildListenerNotification() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        ShutdownNotifier child = ShutdownNotifier.createWithParent(this.instance);
        child.register(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                flag.set(true);
            }
        });
        this.instance.requestShutdown(reason);
        Assert.assertTrue((boolean)flag.get());
    }

    @Test
    public void testParentChildListenerNotificationReason() {
        final AtomicReference reasonReference = new AtomicReference();
        ShutdownNotifier child = ShutdownNotifier.createWithParent(this.instance);
        child.register(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String pReason) {
                reasonReference.set(pReason);
            }
        });
        this.instance.requestShutdown(reason);
        Assert.assertEquals((Object)reason, reasonReference.get());
    }
}

