/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.assumptions.AssumptionWithLocation;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;

@Options(prefix="assumptions")
public class AssumptionCollectorAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="export", description="write collected assumptions to file")
    private boolean exportAssumptions = true;
    @Option(secure=true, name="file", description="write collected assumptions to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionsFile = Paths.get((String)"assumptions.txt", (String[])new String[0]);
    @Option(secure=true, name="automatonFile", description="write collected assumptions as automaton to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionAutomatonFile = Paths.get((String)"AssumptionAutomaton.txt", (String[])new String[0]);
    @Option(secure=true, description="Add a threshold to the automaton, after so many branches on a path the automaton will be ignored (0 to disable)")
    @IntegerOption(min=0L)
    private int automatonBranchingThreshold = 0;
    private final LogManager logger;
    private final Algorithm innerAlgorithm;
    private final FormulaManagerView formulaManager;
    private final AssumptionWithLocation exceptionAssumptions;
    private final AssumptionStorageCPA cpa;
    private final BooleanFormulaManager bfmgr;
    private final Set<Integer> exceptionStates = new HashSet<Integer>();
    private int automatonStates = 0;

    public AssumptionCollectorAlgorithm(Algorithm algo, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = logger;
        this.innerAlgorithm = algo;
        this.cpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(AssumptionStorageCPA.class);
        if (this.cpa == null) {
            throw new InvalidConfigurationException("AssumptionStorageCPA needed for AssumptionCollectionAlgorithm");
        }
        this.formulaManager = this.cpa.getFormulaManager();
        this.bfmgr = this.formulaManager.getBooleanFormulaManager();
        this.exceptionAssumptions = new AssumptionWithLocation(this.formulaManager);
    }

    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean isComplete = true;
        boolean restartCPA = false;
        do {
            restartCPA = false;
            try {
                isComplete &= this.innerAlgorithm.run(reached);
            }
            catch (RefinementFailedException failedRefinement) {
                this.logger.log(Level.FINER, new Object[]{"Dumping assumptions due to:", failedRefinement});
                ARGPath path = failedRefinement.getErrorPath();
                ARGState errorState = path.getLastState();
                assert (errorState == reached.getLastState());
                ARGState parent = (ARGState)Iterables.getOnlyElement(errorState.getParents());
                reached.removeOnlyFromWaitlist(parent);
                this.exceptionStates.add(parent.getStateId());
                this.addAvoidingAssumptions(this.exceptionAssumptions, parent);
                reached.remove(errorState);
                errorState.removeFromARG();
                restartCPA = true;
                isComplete = false;
            }
        } while (restartCPA);
        return isComplete;
    }

    private AssumptionWithLocation collectLocationAssumptions(ReachedSet reached, AssumptionWithLocation exceptionAssumptions) {
        AssumptionWithLocation result = AssumptionWithLocation.copyOf(exceptionAssumptions);
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from tool assumptions"});
        for (AbstractState state : reached) {
            if (AbstractStates.isTargetState(state)) {
                this.addAvoidingAssumptions(result, state);
                continue;
            }
            AssumptionStorageState e = AbstractStates.extractStateByType(state, AssumptionStorageState.class);
            BooleanFormula assumption = this.bfmgr.and(e.getAssumption(), e.getStopFormula());
            if (this.bfmgr.isTrue(assumption)) continue;
            this.addAssumption(result, assumption, state);
        }
        this.logger.log(Level.FINER, new Object[]{"Dumping assumptions resulting from waitlist states"});
        for (AbstractState state : reached.getWaitlist()) {
            this.addAvoidingAssumptions(result, state);
        }
        return result;
    }

    private void addAssumption(AssumptionWithLocation invariant, BooleanFormula assumption, AbstractState state) {
        BooleanFormula dataRegion = AbstractStates.extractReportedFormulas(this.formulaManager, state);
        CFANode loc = AbstractStates.extractLocation(state);
        assert (loc != null);
        invariant.add(loc, this.bfmgr.or(assumption, this.bfmgr.not(dataRegion)));
    }

    private void addAvoidingAssumptions(AssumptionWithLocation invariant, AbstractState state) {
        this.addAssumption(invariant, this.bfmgr.makeBoolean(false), state);
    }

    private void produceAssumptionAutomaton(Appendable output, ReachedSet reached) throws IOException {
        AbstractState firstState = reached.getFirstState();
        if (!(firstState instanceof ARGState)) {
            output.append("Cannot dump assumption as automaton if ARGCPA is not used.");
        }
        HashSet falseAssumptionStates = Sets.newHashSet(reached.getWaitlist());
        TreeSet<ARGState> relevantStates = new TreeSet<ARGState>();
        for (AbstractState state : reached) {
            boolean isRelevant;
            ARGState e = (ARGState)state;
            AssumptionStorageState asmptState = AbstractStates.extractStateByType(e, AssumptionStorageState.class);
            boolean hasFalseAssumption = e.isTarget() || asmptState.isStop() || this.exceptionStates.contains(e.getStateId());
            boolean bl = isRelevant = !asmptState.isAssumptionTrue();
            if (e.isCovered()) {
                e = e.getCoveringState();
                assert (!e.isCovered());
                asmptState = null;
            }
            if (hasFalseAssumption) {
                falseAssumptionStates.add(e);
            }
            if (relevantStates.contains(e) || !isRelevant && !falseAssumptionStates.contains(e)) continue;
            this.findAllParents(e, relevantStates);
        }
        this.writeAutomaton(output, (ARGState)firstState, relevantStates, falseAssumptionStates);
    }

    private void writeAutomaton(Appendable sb, ARGState initialState, Set<ARGState> relevantStates, Set<AbstractState> falseAssumptionStates) throws IOException {
        sb.append("OBSERVER AUTOMATON AssumptionAutomaton\n\n");
        String actionOnFinalEdges = "";
        if (this.automatonBranchingThreshold > 0) {
            sb.append("LOCAL int branchingThreshold = " + this.automatonBranchingThreshold + ";\n");
            sb.append("LOCAL int branchingCount = 0;\n\n");
            actionOnFinalEdges = "DO branchingCount = 0 ";
        }
        sb.append("INITIAL STATE ARG" + initialState.getStateId() + ";\n\n");
        sb.append("STATE __TRUE :\n");
        sb.append("    TRUE -> ASSUME {true} GOTO __TRUE;\n\n");
        if (!falseAssumptionStates.isEmpty()) {
            sb.append("STATE __FALSE :\n");
            sb.append("    TRUE -> ASSUME {false} GOTO __FALSE;\n\n");
        }
        for (ARGState s : relevantStates) {
            assert (!s.isCovered());
            if (falseAssumptionStates.contains(s)) continue;
            sb.append("STATE USEFIRST ARG" + s.getStateId() + " :\n");
            ++this.automatonStates;
            boolean branching = false;
            if (this.automatonBranchingThreshold > 0 && s.getChildren().size() > 1) {
                branching = true;
                sb.append("    branchingCount == branchingThreshold -> " + actionOnFinalEdges + "GOTO __FALSE;\n");
            }
            CFANode loc = AbstractStates.extractLocation(s);
            for (ARGState child : ARGUtils.getUncoveredChildrenView(s)) {
                assert (!child.isCovered());
                CFAEdge edge = loc.getEdgeTo(AbstractStates.extractLocation(child));
                sb.append("    MATCH \"");
                AssumptionCollectorAlgorithm.escape(edge.getRawStatement(), sb);
                sb.append("\" -> ");
                AssumptionStorageState assumptionChild = AbstractStates.extractStateByType(child, AssumptionStorageState.class);
                BooleanFormula assumption = this.bfmgr.and(assumptionChild.getAssumption(), assumptionChild.getStopFormula());
                sb.append("ASSUME {");
                AssumptionCollectorAlgorithm.escape(assumption.toString(), sb);
                sb.append("} ");
                if (falseAssumptionStates.contains(child)) {
                    sb.append(actionOnFinalEdges + "GOTO __FALSE");
                } else if (relevantStates.contains(child)) {
                    if (branching) {
                        sb.append("DO branchingCount = branchingCount+1 ");
                    }
                    sb.append("GOTO ARG" + child.getStateId());
                } else {
                    sb.append(actionOnFinalEdges + "GOTO __TRUE");
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> " + actionOnFinalEdges + "GOTO __TRUE;\n\n");
        }
        sb.append("END AUTOMATON\n");
    }

    private void findAllParents(ARGState s, Set<ARGState> parentSet) {
        ArrayDeque<ARGState> toAdd = new ArrayDeque<ARGState>();
        toAdd.add(s);
        while (!toAdd.isEmpty()) {
            ARGState current = (ARGState)toAdd.pop();
            assert (!current.isCovered());
            if (!parentSet.add(current)) continue;
            toAdd.addAll(current.getParents());
            for (ARGState coveredByCurrent : current.getCoveredByThis()) {
                toAdd.addAll(coveredByCurrent.getParents());
            }
        }
    }

    private static void escape(String s, Appendable appendTo) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    appendTo.append("\\n");
                    continue block6;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block6;
                }
                case '`': {
                    continue block6;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.innerAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.innerAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(new AssumptionCollectionStatistics());
    }

    private class AssumptionCollectionStatistics
    extends AbstractStatistics {
        private AssumptionCollectionStatistics() {
        }

        @Override
        public String getName() {
            return "Assumption Collection algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            AssumptionWithLocation resultAssumption = AssumptionCollectorAlgorithm.this.collectLocationAssumptions(pReached, AssumptionCollectorAlgorithm.this.exceptionAssumptions);
            this.put(out, "Number of locations with assumptions", resultAssumption.getNumberOfLocations());
            if (AssumptionCollectorAlgorithm.this.exportAssumptions) {
                if (AssumptionCollectorAlgorithm.this.assumptionsFile != null) {
                    try {
                        Files.writeFile((Path)AssumptionCollectorAlgorithm.this.assumptionsFile, (Object)resultAssumption);
                    }
                    catch (IOException e) {
                        AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                    }
                }
                if (AssumptionCollectorAlgorithm.this.assumptionAutomatonFile != null) {
                    try (Writer w = Files.openOutputFile((Path)AssumptionCollectorAlgorithm.this.assumptionAutomatonFile, (FileWriteMode[])new FileWriteMode[0]);){
                        AssumptionCollectorAlgorithm.this.produceAssumptionAutomaton(w, pReached);
                    }
                    catch (IOException e) {
                        AssumptionCollectorAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write assumptions to file");
                    }
                    this.put(out, "Number of states in automaton", AssumptionCollectorAlgorithm.this.automatonStates);
                }
            }
        }
    }
}

