/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.value.refiner.UnsoundRefiner;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidComponentException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cegar")
public class CEGARAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CEGARStatistics stats = new CEGARStatistics();
    private volatile int sizeOfReachedSetBeforeRefinement = 0;
    @Option(secure=true, name="refiner", required=true, description="Which refinement algorithm to use? (give class name, required for CEGAR) If the package name starts with 'org.sosy_lab.cpachecker.', this prefix can be omitted.")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
    private Class<? extends Refiner> refiner = null;
    @Option(secure=true, name="globalRefinement", description="Whether to do refinement immediately after finding an error state, or globally after the ARG has been unrolled completely.")
    private boolean globalRefinement = false;
    private final LogManager logger;
    private final Algorithm algorithm;
    private final Refiner mRefiner;

    private Refiner createInstance(ConfigurableProgramAnalysis pCpa) throws CPAException, InvalidConfigurationException {
        Object refinerObj;
        Method factoryMethod;
        try {
            factoryMethod = this.refiner.getMethod("create", ConfigurableProgramAnalysis.class);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidComponentException(this.refiner, "Refiner", "No public static method \"create\" with exactly one parameter of type ConfigurableProgramAnalysis.");
        }
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method is not static");
        }
        String exception = Classes.verifyDeclaredExceptions((Method)factoryMethod, (Class[])new Class[]{CPAException.class, InvalidConfigurationException.class});
        if (exception != null) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method declares the unsupported checked exception " + exception + ".");
        }
        try {
            refinerObj = factoryMethod.invoke(null, pCpa);
        }
        catch (IllegalAccessException e) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method is not public.");
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, CPAException.class, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("instantiation of refiner " + this.refiner.getSimpleName(), cause);
        }
        if (refinerObj == null || !(refinerObj instanceof Refiner)) {
            throw new InvalidComponentException(this.refiner, "Refiner", "Factory method did not return a Refiner instance.");
        }
        return (Refiner)refinerObj;
    }

    public CEGARAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.algorithm = algorithm;
        this.logger = logger;
        this.mRefiner = this.createInstance(pCpa);
        new CEGARMBean();
    }

    public CEGARAlgorithm(Algorithm algorithm, Refiner pRefiner, Configuration config, LogManager logger) throws InvalidConfigurationException, CPAException {
        config.inject((Object)this);
        this.algorithm = algorithm;
        this.logger = logger;
        this.mRefiner = (Refiner)Preconditions.checkNotNull((Object)pRefiner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean isComplete = true;
        int initialReachedSetSize = reached.size();
        boolean refinedInPreviousIteration = false;
        this.stats.totalTimer.start();
        try {
            boolean refinementSuccessful;
            do {
                refinementSuccessful = false;
                isComplete &= this.algorithm.run(reached);
                if (this.refinementNecessary(reached)) {
                    refinementSuccessful = this.refine(reached);
                    refinedInPreviousIteration = true;
                    if (refinementSuccessful && initialReachedSetSize == 1) assert (!FluentIterable.from((Iterable)reached).anyMatch(AbstractStates.IS_TARGET_STATE));
                    continue;
                }
                if (!(this.mRefiner instanceof UnsoundRefiner)) continue;
                if (!refinedInPreviousIteration) {
                    break;
                }
                ((UnsoundRefiner)this.mRefiner).forceRestart(reached);
                refinementSuccessful = true;
                refinedInPreviousIteration = false;
            } while (refinementSuccessful);
        }
        finally {
            this.stats.totalTimer.stop();
        }
        return isComplete;
    }

    private boolean refinementNecessary(ReachedSet reached) {
        if (this.globalRefinement) {
            return FluentIterable.from((Iterable)reached).anyMatch(AbstractStates.IS_TARGET_STATE);
        }
        return AbstractStates.isTargetState(reached.getLastState());
    }

    private boolean refine(ReachedSet reached) throws CPAException, InterruptedException {
        boolean refinementResult;
        this.logger.log(Level.FINE, new Object[]{"Error found, performing CEGAR"});
        this.stats.countRefinements++;
        this.stats.totalReachedSizeBeforeRefinement += reached.size();
        this.stats.maxReachedSizeBeforeRefinement = Math.max(this.stats.maxReachedSizeBeforeRefinement, reached.size());
        this.sizeOfReachedSetBeforeRefinement = reached.size();
        this.stats.refinementTimer.start();
        try {
            refinementResult = this.mRefiner.performRefinement(reached);
        }
        catch (RefinementFailedException e) {
            this.stats.countFailedRefinements++;
            throw e;
        }
        finally {
            this.stats.refinementTimer.stop();
        }
        this.logger.log(Level.FINE, new Object[]{"Refinement successful:", refinementResult});
        if (refinementResult) {
            this.stats.countSuccessfulRefinements++;
            this.stats.totalReachedSizeAfterRefinement += reached.size();
            this.stats.maxReachedSizeAfterRefinement = Math.max(this.stats.maxReachedSizeAfterRefinement, reached.size());
        }
        return refinementResult;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        if (this.mRefiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.mRefiner)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private class CEGARMBean
    extends AbstractMBean
    implements CEGARMXBean {
        public CEGARMBean() {
            super("org.sosy_lab.cpachecker:type=CEGAR", CEGARAlgorithm.this.logger);
            this.register();
        }

        @Override
        public int getNumberOfRefinements() {
            return CEGARAlgorithm.this.stats.countRefinements;
        }

        @Override
        public int getSizeOfReachedSetBeforeLastRefinement() {
            return CEGARAlgorithm.this.sizeOfReachedSetBeforeRefinement;
        }

        @Override
        public boolean isRefinementActive() {
            return CEGARAlgorithm.this.stats.refinementTimer.isRunning();
        }
    }

    public static interface CEGARMXBean {
        public int getNumberOfRefinements();

        public int getSizeOfReachedSetBeforeLastRefinement();

        public boolean isRefinementActive();
    }

    private static class CEGARStatistics
    implements Statistics {
        private final Timer totalTimer = new Timer();
        private final Timer refinementTimer = new Timer();
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="only one thread writes, others read")
        private volatile int countRefinements = 0;
        private int countSuccessfulRefinements = 0;
        private int countFailedRefinements = 0;
        private int maxReachedSizeBeforeRefinement = 0;
        private int maxReachedSizeAfterRefinement = 0;
        private long totalReachedSizeBeforeRefinement = 0L;
        private long totalReachedSizeAfterRefinement = 0L;

        private CEGARStatistics() {
        }

        @Override
        public String getName() {
            return "CEGAR algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of refinements:                " + this.countRefinements);
            if (this.countRefinements > 0) {
                out.println("Number of successful refinements:     " + this.countSuccessfulRefinements);
                out.println("Number of failed refinements:         " + this.countFailedRefinements);
                out.println("Max. size of reached set before ref.: " + this.maxReachedSizeBeforeRefinement);
                out.println("Max. size of reached set after ref.:  " + this.maxReachedSizeAfterRefinement);
                out.println("Avg. size of reached set before ref.: " + StatisticsUtils.div(this.totalReachedSizeBeforeRefinement, this.countRefinements));
                out.println("Avg. size of reached set after ref.:  " + StatisticsUtils.div(this.totalReachedSizeAfterRefinement, this.countSuccessfulRefinements));
                out.println("");
                out.println("Total time for CEGAR algorithm:   " + this.totalTimer);
                out.println("Time for refinements:             " + this.refinementTimer);
                out.println("Average time for refinement:      " + this.refinementTimer.getAvgTime().formatAs(TimeUnit.SECONDS));
                out.println("Max time for refinement:          " + this.refinementTimer.getMaxTime().formatAs(TimeUnit.SECONDS));
            }
        }
    }
}

