/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AlgorithmIterationListener;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCovering;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinPredicatedAnalysis;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class CPAAlgorithm
implements Algorithm,
StatisticsProvider {
    private final ForcedCovering forcedCovering;
    private final CPAStatistics stats = new CPAStatistics();
    private final ConfigurableProgramAnalysis cpa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final AlgorithmIterationListener iterationListener;

    public static CPAAlgorithm create(ConfigurableProgramAnalysis cpa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, AlgorithmIterationListener pIterationListener) throws InvalidConfigurationException {
        return new CPAAlgorithmFactory(cpa, logger, config, pShutdownNotifier, pIterationListener).newInstance();
    }

    public static CPAAlgorithm create(ConfigurableProgramAnalysis cpa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        return new CPAAlgorithmFactory(cpa, logger, config, pShutdownNotifier, null).newInstance();
    }

    private CPAAlgorithm(ConfigurableProgramAnalysis cpa, LogManager logger, ShutdownNotifier pShutdownNotifier, ForcedCovering pForcedCovering, AlgorithmIterationListener pIterationListener) {
        this.cpa = cpa;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.forcedCovering = pForcedCovering;
        this.iterationListener = pIterationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.stats.totalTimer.start();
        try {
            boolean bl = this.run0(reachedSet);
            return bl;
        }
        finally {
            this.stats.totalTimer.stopIfRunning();
            this.stats.chooseTimer.stopIfRunning();
            this.stats.precisionTimer.stopIfRunning();
            this.stats.transferTimer.stopIfRunning();
            this.stats.mergeTimer.stopIfRunning();
            this.stats.stopTimer.stopIfRunning();
            this.stats.addTimer.stopIfRunning();
            this.stats.forcedCoveringTimer.stopIfRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run0(ReachedSet reachedSet) throws CPAException, InterruptedException {
        TransferRelation transferRelation = this.cpa.getTransferRelation();
        MergeOperator mergeOperator = this.cpa.getMergeOperator();
        StopOperator stopOperator = this.cpa.getStopOperator();
        PrecisionAdjustment precisionAdjustment = this.cpa.getPrecisionAdjustment();
        while (reachedSet.hasWaitingState()) {
            Collection<? extends AbstractState> successors;
            this.shutdownNotifier.shutdownIfNecessary();
            this.stats.countIterations++;
            int size = reachedSet.getWaitlistSize();
            if (size >= this.stats.maxWaitlistSize) {
                this.stats.maxWaitlistSize = size;
            }
            this.stats.countWaitlistSize += size;
            this.stats.chooseTimer.start();
            AbstractState state = reachedSet.popFromWaitlist();
            Precision precision = reachedSet.getPrecision(state);
            this.stats.chooseTimer.stop();
            this.logger.log(Level.FINER, new Object[]{"Retrieved state from waitlist"});
            this.logger.log(Level.ALL, new Object[]{"Current state is", state, "with precision", precision});
            if (this.forcedCovering != null) {
                this.stats.forcedCoveringTimer.start();
                try {
                    boolean stop = this.forcedCovering.tryForcedCovering(state, precision, reachedSet);
                    if (stop) {
                        continue;
                    }
                }
                finally {
                    this.stats.forcedCoveringTimer.stop();
                    continue;
                }
            }
            this.stats.transferTimer.start();
            try {
                successors = transferRelation.getAbstractSuccessors(state, precision);
            }
            finally {
                this.stats.transferTimer.stop();
            }
            int numSuccessors = successors.size();
            this.logger.log(Level.FINER, new Object[]{"Current state has", numSuccessors, "successors"});
            this.stats.countSuccessors += numSuccessors;
            this.stats.maxSuccessors = Math.max(numSuccessors, this.stats.maxSuccessors);
            for (AbstractState successor : Iterables.consumingIterable(successors)) {
                boolean stop;
                PrecisionAdjustment.PrecisionAdjustmentResult precAdjustmentResult;
                this.logger.log(Level.FINER, new Object[]{"Considering successor of current state"});
                this.logger.log(Level.ALL, new Object[]{"Successor of", state, "\nis", successor});
                this.stats.precisionTimer.start();
                try {
                    precAdjustmentResult = precisionAdjustment.prec(successor, precision, reachedSet, successor);
                }
                finally {
                    this.stats.precisionTimer.stop();
                }
                successor = precAdjustmentResult.abstractState();
                Precision successorPrecision = precAdjustmentResult.precision();
                PrecisionAdjustment.Action action = precAdjustmentResult.action();
                if (action == PrecisionAdjustment.Action.BREAK) {
                    boolean stop2;
                    this.stats.stopTimer.start();
                    try {
                        stop2 = stopOperator.stop(successor, reachedSet.getReached(successor), successorPrecision);
                    }
                    finally {
                        this.stats.stopTimer.stop();
                    }
                    if (AbstractStates.isTargetState(successor) && stop2) {
                        this.stats.countStop++;
                        this.logger.log(Level.FINER, new Object[]{"Break was signalled but ignored because the state is covered."});
                        continue;
                    }
                    this.stats.countBreak++;
                    this.logger.log(Level.FINER, new Object[]{"Break signalled, CPAAlgorithm will stop."});
                    reachedSet.add(successor, successorPrecision);
                    if (!successors.isEmpty()) {
                        reachedSet.reAddToWaitlist(state);
                    }
                    return true;
                }
                assert (action == PrecisionAdjustment.Action.CONTINUE) : "Enum Action has unhandled values!";
                Collection<AbstractState> reached = reachedSet.getReached(successor);
                if (mergeOperator != MergeSepOperator.getInstance() && !reached.isEmpty()) {
                    this.stats.mergeTimer.start();
                    try {
                        ArrayList<AbstractState> toRemove = new ArrayList<AbstractState>();
                        ArrayList<Pair<AbstractState, Precision>> toAdd = new ArrayList<Pair<AbstractState, Precision>>();
                        this.logger.log(Level.FINER, new Object[]{"Considering", reached.size(), "states from reached set for merge"});
                        for (AbstractState reachedState : reached) {
                            AbstractState mergedState = mergeOperator.merge(successor, reachedState, successorPrecision);
                            if (mergedState.equals(reachedState)) continue;
                            this.logger.log(Level.FINER, new Object[]{"Successor was merged with state from reached set"});
                            this.logger.log(Level.ALL, new Object[]{"Merged", successor, "\nand", reachedState, "\n-->", mergedState});
                            this.stats.countMerge++;
                            toRemove.add(reachedState);
                            toAdd.add((Pair<AbstractState, Precision>)Pair.of((Object)mergedState, (Object)successorPrecision));
                        }
                        reachedSet.removeAll(toRemove);
                        reachedSet.addAll(toAdd);
                        if (mergeOperator instanceof ARGMergeJoinPredicatedAnalysis) {
                            ((ARGMergeJoinPredicatedAnalysis)mergeOperator).cleanUp(reachedSet);
                        }
                    }
                    finally {
                        this.stats.mergeTimer.stop();
                    }
                }
                this.stats.stopTimer.start();
                try {
                    stop = stopOperator.stop(successor, reached, successorPrecision);
                }
                finally {
                    this.stats.stopTimer.stop();
                }
                if (stop) {
                    this.logger.log(Level.FINER, new Object[]{"Successor is covered or unreachable, not adding to waitlist"});
                    this.stats.countStop++;
                    continue;
                }
                this.logger.log(Level.FINER, new Object[]{"No need to stop, adding successor to waitlist"});
                this.stats.addTimer.start();
                reachedSet.add(successor, successorPrecision);
                this.stats.addTimer.stop();
            }
            if (this.iterationListener == null) continue;
            this.iterationListener.afterAlgorithmIteration(this, reachedSet);
        }
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.forcedCovering instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.forcedCovering)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Options(prefix="cpa")
    public static class CPAAlgorithmFactory {
        @Option(secure=true, description="Which strategy to use for forced coverings (empty for none)", name="forcedCovering")
        @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
        private Class<? extends ForcedCovering> forcedCoveringClass = null;
        private final ForcedCovering forcedCovering;
        private final ConfigurableProgramAnalysis cpa;
        private final LogManager logger;
        private final ShutdownNotifier shutdownNotifier;
        private final AlgorithmIterationListener iterationListener;

        public CPAAlgorithmFactory(ConfigurableProgramAnalysis cpa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable AlgorithmIterationListener pIterationListener) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.cpa = cpa;
            this.logger = logger;
            this.shutdownNotifier = pShutdownNotifier;
            this.iterationListener = pIterationListener;
            this.forcedCovering = this.forcedCoveringClass != null ? (ForcedCovering)Classes.createInstance(ForcedCovering.class, this.forcedCoveringClass, (Class[])new Class[]{Configuration.class, LogManager.class, ConfigurableProgramAnalysis.class}, (Object[])new Object[]{config, logger, cpa}) : null;
        }

        public CPAAlgorithm newInstance() {
            return new CPAAlgorithm(this.cpa, this.logger, this.shutdownNotifier, this.forcedCovering, this.iterationListener);
        }
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer chooseTimer = new Timer();
        private Timer precisionTimer = new Timer();
        private Timer transferTimer = new Timer();
        private Timer mergeTimer = new Timer();
        private Timer stopTimer = new Timer();
        private Timer addTimer = new Timer();
        private Timer forcedCoveringTimer = new Timer();
        private int countIterations = 0;
        private int maxWaitlistSize = 0;
        private long countWaitlistSize = 0L;
        private int countSuccessors = 0;
        private int maxSuccessors = 0;
        private int countMerge = 0;
        private int countStop = 0;
        private int countBreak = 0;

        private CPAStatistics() {
        }

        @Override
        public String getName() {
            return "CPA algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println("Number of iterations:            " + this.countIterations);
            if (this.countIterations == 0) {
                return;
            }
            out.println("Max size of waitlist:            " + this.maxWaitlistSize);
            out.println("Average size of waitlist:        " + this.countWaitlistSize / (long)this.countIterations);
            out.println("Number of computed successors:   " + this.countSuccessors);
            out.println("Max successors for one state:    " + this.maxSuccessors);
            out.println("Number of times merged:          " + this.countMerge);
            out.println("Number of times stopped:         " + this.countStop);
            out.println("Number of times breaked:         " + this.countBreak);
            out.println();
            out.println("Total time for CPA algorithm:     " + this.totalTimer + " (Max: " + this.totalTimer.getMaxTime().formatAs(TimeUnit.SECONDS) + ")");
            out.println("  Time for choose from waitlist:  " + this.chooseTimer);
            if (this.forcedCoveringTimer.getNumberOfIntervals() > 0) {
                out.println("  Time for forced covering:       " + this.forcedCoveringTimer);
            }
            out.println("  Time for precision adjustment:  " + this.precisionTimer);
            out.println("  Time for transfer relation:     " + this.transferTimer);
            if (this.mergeTimer.getNumberOfIntervals() > 0) {
                out.println("  Time for merge operator:        " + this.mergeTimer);
            }
            out.println("  Time for stop operator:         " + this.stopTimer);
            out.println("  Time for adding to reached set: " + this.addTimer);
        }
    }
}

