/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

@Options(prefix="counterexample.checker")
public class CounterexampleCPAChecker
implements CounterexampleChecker {
    private static final ImmutableSet<String> OVERWRITE_OPTIONS = ImmutableSet.of((Object)"analysis.machineModel", (Object)"cpa.predicate.handlePointerAliasing");
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final CFA cfa;
    private final String filename;
    private final ARGCPA cpa;
    @Option(secure=true, name="path.file", description="File name where to put the path specification that is generated as input for the counterexample check. A temporary file is used if this is unspecified.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path specFile;
    @Option(secure=true, name="config", description="configuration file for counterexample checks with CPAchecker")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path configFile = Paths.get((String)"config/valueAnalysis-no-cbmc.properties", (String[])new String[0]);

    public CounterexampleCPAChecker(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA pCfa, String pFilename) throws InvalidConfigurationException {
        this.logger = logger;
        this.config = config;
        config.inject((Object)this);
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.filename = pFilename;
        this.cpa = null;
    }

    public CounterexampleCPAChecker(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA pCfa, String pFilename, ARGCPA pCpa) throws InvalidConfigurationException {
        this.logger = logger;
        this.config = config;
        config.inject((Object)this);
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.filename = pFilename;
        this.cpa = pCpa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates) throws CPAException, InterruptedException {
        try {
            if (this.specFile != null) {
                return this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, this.specFile);
            }
            try (Files.DeleteOnCloseFile automatonFile = Files.createTempFile((String)"counterexample-automaton", (String)".txt");){
                boolean bl = this.checkCounterexample(pRootState, pErrorState, pErrorPathStates, automatonFile.toPath());
                return bl;
            }
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed("Could not write path automaton to file " + e.getMessage(), e);
        }
    }

    private boolean checkCounterexample(ARGState pRootState, ARGState pErrorState, Set<ARGState> pErrorPathStates, Path automatonFile) throws IOException, CPAException, InterruptedException {
        try (Writer w = Files.openOutputFile((Path)automatonFile, (FileWriteMode[])new FileWriteMode[0]);){
            ARGUtils.producePathAutomaton(w, pRootState, pErrorPathStates, "CounterexampleToCheck", this.cpa.getCounterexamples().get(pErrorState));
        }
        CFANode entryNode = AbstractStates.extractLocation(pRootState);
        LogManager lLogger = this.logger.withComponentName("CounterexampleCheck");
        try {
            ConfigurationBuilder lConfigBuilder = Configuration.builder().loadFromFile(this.configFile).setOption("specification", automatonFile.toAbsolutePath().toString());
            for (String option : OVERWRITE_OPTIONS) {
                if (this.config.hasProperty(option)) {
                    lConfigBuilder.copyOptionFrom(this.config, option);
                    continue;
                }
                lConfigBuilder.clearOption(option);
            }
            Configuration lConfig = lConfigBuilder.build();
            ShutdownNotifier lShutdownNotifier = ShutdownNotifier.createWithParent(this.shutdownNotifier);
            ResourceLimitChecker.fromConfiguration(lConfig, lLogger, lShutdownNotifier).start();
            CoreComponentsFactory factory = new CoreComponentsFactory(lConfig, lLogger, lShutdownNotifier);
            ConfigurableProgramAnalysis lCpas = factory.createCPA(this.cfa, null, CoreComponentsFactory.SpecAutomatonCompositionType.TARGET_SPEC);
            Algorithm lAlgorithm = factory.createAlgorithm(lCpas, this.filename, this.cfa, null);
            ReachedSet lReached = factory.createReachedSet();
            lReached.add(lCpas.getInitialState(entryNode, StateSpacePartition.getDefaultPartition()), lCpas.getInitialPrecision(entryNode, StateSpacePartition.getDefaultPartition()));
            lAlgorithm.run(lReached);
            lShutdownNotifier.requestShutdown("Analysis terminated");
            CPAs.closeCpaIfPossible(lCpas, lLogger);
            CPAs.closeIfPossible(lAlgorithm, lLogger);
            return FluentIterable.from((Iterable)lReached).anyMatch(AbstractStates.IS_TARGET_STATE);
        }
        catch (InvalidConfigurationException e) {
            throw new CounterexampleAnalysisFailed("Invalid configuration in counterexample-check config: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CounterexampleAnalysisFailed(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.shutdownNotifier.shutdownIfNecessary();
            throw new CounterexampleAnalysisFailed("Counterexample check aborted", e);
        }
    }
}

