/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCPAChecker;
import org.sosy_lab.cpachecker.core.algorithm.cbmctools.CBMCChecker;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="counterexample")
public class CounterexampleCheckAlgorithm
implements Algorithm,
StatisticsProvider,
Statistics {
    private final Algorithm algorithm;
    private final CounterexampleChecker checker;
    private final LogManager logger;
    private final ARGCPA cpa;
    private final Timer checkTime = new Timer();
    private int numberOfInfeasiblePaths = 0;
    private final Set<ARGState> checkedTargetStates = Collections.newSetFromMap(new WeakHashMap());
    @Option(secure=true, name="checker", toUppercase=true, values={"CBMC", "CPACHECKER"}, description="which model checker to use for verifying counterexamples as a second check\nCurrently CBMC or CPAchecker with a different config can be used.")
    private String checkerName = "CBMC";
    @Option(secure=true, description="continue analysis after an counterexample was found that was denied by the second check")
    private boolean continueAfterInfeasibleError = true;
    @Option(secure=true, description="If continueAfterInfeasibleError is true, remove the infeasible counterexample before continuing.Setting this to false may prevent a lot of similar infeasible counterexamples to get discovered, but is unsound")
    private boolean removeInfeasibleErrors = false;

    public CounterexampleCheckAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa, String filename) throws InvalidConfigurationException, CPAException {
        this.algorithm = algorithm;
        this.logger = logger;
        config.inject((Object)this);
        if (!(pCpa instanceof ARGCPA)) {
            throw new InvalidConfigurationException("ARG CPA needed for counterexample check");
        }
        this.cpa = (ARGCPA)pCpa;
        if (this.checkerName.equals("CBMC")) {
            this.checker = new CBMCChecker(config, logger, cfa);
        } else if (this.checkerName.equals("CPACHECKER")) {
            this.checker = new CounterexampleCPAChecker(config, logger, pShutdownNotifier, cfa, filename, this.cpa);
        } else {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(ReachedSet reached) throws CPAException, InterruptedException {
        boolean sound = true;
        while (reached.hasWaitingState()) {
            sound &= this.algorithm.run(reached);
            assert (ARGUtils.checkARG(reached));
            ARGState lastState = (ARGState)reached.getLastState();
            ArrayDeque<ARGState> errorStates = new ArrayDeque<ARGState>();
            if (lastState != null && lastState.isTarget()) {
                errorStates.add(lastState);
            } else {
                FluentIterable.from((Iterable)reached).transform(AbstractStates.toState(ARGState.class)).filter(AbstractStates.IS_TARGET_STATE).filter(Predicates.not((Predicate)Predicates.in(this.checkedTargetStates))).copyInto(errorStates);
            }
            if (errorStates.isEmpty()) break;
            this.checkTime.start();
            try {
                boolean foundCounterexample = false;
                while (!errorStates.isEmpty()) {
                    ARGState errorState = (ARGState)errorStates.pollFirst();
                    if (!reached.contains(errorState)) continue;
                    sound = this.checkCounterexample(errorState, reached, sound);
                    if (!reached.contains(errorState)) continue;
                    this.checkedTargetStates.add(errorState);
                    foundCounterexample = true;
                }
                if (!foundCounterexample) continue;
                break;
            }
            finally {
                this.checkTime.stop();
            }
        }
        return sound;
    }

    private boolean checkCounterexample(ARGState errorState, ReachedSet reached, boolean sound) throws InterruptedException, CPAException, RefinementFailedException {
        boolean feasibility;
        ARGState rootState = (ARGState)reached.getFirstState();
        Set<ARGState> statesOnErrorPath = ARGUtils.getAllStatesOnPathsTo(errorState);
        this.logger.log(Level.INFO, new Object[]{"Error path found, starting counterexample check with " + this.checkerName + "."});
        try {
            feasibility = this.checker.checkCounterexample(rootState, errorState, statesOnErrorPath);
        }
        catch (CPAException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Counterexample found, but feasibility could not be verified");
            throw e;
        }
        if (feasibility) {
            this.logger.log(Level.INFO, new Object[]{"Error path found and confirmed by counterexample check with " + this.checkerName + "."});
            return sound;
        }
        ++this.numberOfInfeasiblePaths;
        this.logger.log(Level.INFO, new Object[]{"Error path found, but identified as infeasible by counterexample check with " + this.checkerName + "."});
        if (this.continueAfterInfeasibleError) {
            if (this.removeInfeasibleErrors) {
                sound &= this.handleInfeasibleCounterexample(reached, statesOnErrorPath);
            } else if (sound) {
                this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG. Therefore, we cannot prove safety."});
                sound = false;
            }
            sound &= this.removeErrorState(reached, errorState);
            assert (ARGUtils.checkARG(reached));
        } else {
            ARGPath path = ARGUtils.getOnePathTo(errorState);
            throw new RefinementFailedException(RefinementFailedException.Reason.InfeasibleCounterexample, path);
        }
        return sound;
    }

    private boolean handleInfeasibleCounterexample(ReachedSet reached, Set<ARGState> statesOnErrorPath) {
        boolean sound = true;
        ArrayList<ARGState> coveredByErrorPath = new ArrayList<ARGState>();
        for (ARGState errorPathState : statesOnErrorPath) {
            coveredByErrorPath.addAll(errorPathState.getCoveredByThis());
            errorPathState.setNotCovering();
        }
        for (ARGState coveredState : coveredByErrorPath) {
            if (this.isTransitiveChildOf(coveredState, coveredState.getCoveringState())) {
                this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG due to loops in the counterexample path. Therefore, we cannot prove safety."});
                sound = false;
                continue;
            }
            for (ARGState parentOfCovered : coveredState.getParents()) {
                if (statesOnErrorPath.contains(parentOfCovered)) {
                    this.logger.log(Level.WARNING, new Object[]{"Infeasible counterexample found, but could not remove it from the ARG. Therefore, we cannot prove safety."});
                    sound = false;
                    continue;
                }
                reached.reAddToWaitlist(parentOfCovered);
            }
            assert (!reached.contains(coveredState)) : "covered state in reached set";
            coveredState.removeFromARG();
        }
        return sound;
    }

    private boolean isTransitiveChildOf(ARGState potentialChild, ARGState potentialParent) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.addAll(potentialChild.getParents());
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)waitlist.pollFirst();
            for (ARGState currentParent : current.getParents()) {
                if (currentParent.equals(potentialParent)) {
                    return true;
                }
                if (seen.add(currentParent)) continue;
                waitlist.addLast(currentParent);
            }
        }
        return false;
    }

    private boolean removeErrorState(ReachedSet reached, ARGState errorState) {
        boolean sound = true;
        assert (errorState.getChildren().isEmpty());
        assert (errorState.getCoveredByThis().isEmpty());
        Collection<ARGState> parents = errorState.getParents();
        assert (parents.size() == 1) : "error state that was merged";
        ARGState parent = (ARGState)Iterables.getOnlyElement(parents);
        if (parent.getChildren().size() > 1 || parent.getCoveredByThis().isEmpty()) {
            sound = false;
        }
        ImmutableList siblings = ImmutableList.copyOf(parent.getChildren());
        for (ARGState toRemove : siblings) {
            assert (toRemove.getChildren().isEmpty());
            assert (siblings.containsAll(toRemove.getCoveredByThis()));
            reached.remove(toRemove);
            toRemove.removeFromARG();
        }
        ImmutableList coveredByParent = ImmutableList.copyOf(parent.getCoveredByThis());
        for (ARGState covered : coveredByParent) {
            assert (covered.getChildren().isEmpty());
            assert (covered.getCoveredByThis().isEmpty());
            covered.removeFromARG();
        }
        this.cpa.clearCounterexamples((Set<ARGState>)ImmutableSet.of((Object)errorState));
        reached.remove(parent);
        parent.removeFromARG();
        assert (errorState.isDestroyed()) : "errorState is not the child of its parent";
        assert (!reached.contains(errorState)) : "reached.remove() didn't work";
        return sound;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        out.println("Number of counterexample checks:    " + this.checkTime.getNumberOfIntervals());
        if (this.checkTime.getNumberOfIntervals() > 0) {
            out.println("Number of infeasible paths:         " + this.numberOfInfeasiblePaths + " (" + StatisticsUtils.toPercent(this.numberOfInfeasiblePaths, this.checkTime.getNumberOfIntervals()) + ")");
            out.println("Time for counterexample checks:     " + this.checkTime);
            if (this.checker instanceof Statistics) {
                ((Statistics)((Object)this.checker)).printStatistics(out, pResult, pReached);
            }
        }
    }

    @Override
    public String getName() {
        return "Counterexample-Check Algorithm";
    }
}

