/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstruction;
import org.sosy_lab.cpachecker.util.ci.AppliedCustomInstructionParser;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionRequirementsWriter;

@Options(prefix="custominstructions")
public class CustomInstructionRequirementsExtractingAlgorithm
implements Algorithm {
    private final Algorithm analysis;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    @Option(secure=true, name="definitionFile", description="File to be parsed")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path appliedCustomInstructionsDefinition;
    @Option(secure=true, description="Prefix for files containing the custom instruction requirements.")
    private String ciFilePrefix = "ci";
    @Option(secure=true, description="Qualified name of class for abstract state which provides custom instruction requirements.")
    private String requirementsStateClassName;
    private Class<AbstractState> requirementsStateClass;

    public CustomInstructionRequirementsExtractingAlgorithm(Algorithm analysisAlgorithm, ConfigurableProgramAnalysis cpa, Configuration config, LogManager logger, ShutdownNotifier sdNotifier, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.analysis = analysisAlgorithm;
        this.logger = logger;
        this.shutdownNotifier = sdNotifier;
        if (cpa instanceof ARGCPA) {
            throw new InvalidConfigurationException("The given cpa " + cpa + "is not an instance of ARGCPA");
        }
        if (!this.appliedCustomInstructionsDefinition.toFile().exists()) {
            throw new InvalidConfigurationException("The given path '" + this.appliedCustomInstructionsDefinition + "' is not a valid path to a file.");
        }
        try {
            this.requirementsStateClass = Class.forName(this.requirementsStateClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("The abstract state " + this.requirementsStateClassName + " is unknown.");
        }
        if (AbstractStates.extractStateByType(cpa.getInitialState(cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()), this.requirementsStateClass) == null) {
            throw new InvalidConfigurationException(this.requirementsStateClassName + "is not an abstract state.");
        }
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException, PredicatedAnalysisPropertyViolationException {
        this.logger.log(Level.INFO, new Object[]{" Start analysing to compute requirements."});
        if (!this.analysis.run(pReachedSet)) {
            this.logger.log(Level.SEVERE, new Object[]{"Do not extract requirements since analysis failed."});
            return false;
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.INFO, new Object[]{"Get custom instruction applications in program."});
        CustomInstructionApplications aci = null;
        try {
            aci = new CustomInstructionApplications((Map<CFANode, AppliedCustomInstruction>)new AppliedCustomInstructionParser(this.shutdownNotifier).parse(this.appliedCustomInstructionsDefinition));
        }
        catch (FileNotFoundException ex) {
            this.logger.log(Level.SEVERE, new Object[]{"The file '" + this.appliedCustomInstructionsDefinition + "' was not found", ex});
            return false;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Parsing the file '" + this.appliedCustomInstructionsDefinition + "' failed.", e});
            return false;
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.logger.log(Level.INFO, new Object[]{"Start extracting requirements for applied custom instructions"});
        this.extractRequirements((ARGState)pReachedSet.getFirstState(), aci);
        return true;
    }

    private void extractRequirements(ARGState root, CustomInstructionApplications cia) throws InterruptedException, CPAException {
        CustomInstructionRequirementsWriter writer = new CustomInstructionRequirementsWriter(this.ciFilePrefix, this.requirementsStateClass);
        Collection<ARGState> ciStartNodes = this.getCustomInstructionStartNodes(root, cia);
        for (ARGState node : ciStartNodes) {
            this.shutdownNotifier.shutdownIfNecessary();
            try {
                writer.writeCIRequirement(node, this.findEndStatesFor(node, cia), cia.getAppliedCustomInstructionFor(node));
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, new Object[]{"Writing  the CIRequirement failed at node " + node + ".", e});
            }
        }
    }

    private Collection<ARGState> getCustomInstructionStartNodes(ARGState root, CustomInstructionApplications pCustomIA) throws InterruptedException, CPAException {
        ImmutableSet.Builder set = new ImmutableSet.Builder();
        HashSet<ARGState> visitedNodes = new HashSet<ARGState>();
        ArrayDeque<ARGState> queue = new ArrayDeque<ARGState>();
        queue.add(root);
        visitedNodes.add(root);
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState tmp = (ARGState)queue.poll();
            visitedNodes.add(tmp);
            if (pCustomIA.isStartState(tmp)) {
                set.add((Object)tmp);
            }
            for (ARGState child : tmp.getChildren()) {
                if (visitedNodes.contains(child)) continue;
                queue.add(child);
                visitedNodes.add(child);
            }
        }
        return set.build();
    }

    private Collection<ARGState> findEndStatesFor(ARGState ciStart, CustomInstructionApplications pCustomIA) throws InterruptedException, CPAException {
        ArrayList<ARGState> list = new ArrayList<ARGState>();
        ArrayDeque<ARGState> queue = new ArrayDeque<ARGState>();
        HashSet<ARGState> visitedNodes = new HashSet<ARGState>();
        queue.add(ciStart);
        visitedNodes.add(ciStart);
        while (!queue.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ARGState tmp = (ARGState)queue.poll();
            if (pCustomIA.isEndState((AbstractState)tmp, ciStart)) {
                list.add(tmp);
                continue;
            }
            for (ARGState child : tmp.getChildren()) {
                if (visitedNodes.contains(child)) continue;
                queue.add(child);
                visitedNodes.add(child);
            }
        }
        return list;
    }
}

