/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinPredicatedAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeMergeAgreePredicatedAnalysisOperator;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwards;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class PredicatedAnalysisAlgorithm
implements Algorithm,
StatisticsProvider {
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final PredicateCPA predCPA;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final List<CAssumeEdge> fakeEdgesFromLastRun = new ArrayList<CAssumeEdge>();
    private AbstractState initialWrappedState = null;
    private ARGPath pathToFailure = null;
    private boolean repeatedFailure = false;
    private PredicatePrecision oldPrecision = null;
    private Constructor<? extends AbstractState> locConstructor = null;

    public PredicatedAnalysisAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis cpa, CFA pCfa, LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.algorithm = pAlgorithm;
        this.cpa = cpa;
        this.cfa = pCfa;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.predCPA = CPAs.retrieveCPA(cpa, PredicateCPA.class);
        if (!(cpa instanceof ARGCPA) || CPAs.retrieveCPA(cpa, LocationCPA.class) == null && CPAs.retrieveCPA(cpa, LocationCPABackwards.class) == null || CPAs.retrieveCPA(cpa, PredicateCPA.class) == null || CPAs.retrieveCPA(cpa, CompositeCPA.class) == null) {
            throw new InvalidConfigurationException("Predicated Analysis requires ARG as top CPA and Composite CPA as child. Furthermore, it needs Location CPA and Predicate CPA to work.");
        }
        if (CPAs.retrieveCPA(cpa, LocationCPABackwards.class) != null) {
            throw new InvalidConfigurationException("Currently only support forward analyses.");
        }
        if (!(CPAs.retrieveCPA(cpa, CompositeCPA.class).getMergeOperator() instanceof CompositeMergeAgreePredicatedAnalysisOperator)) {
            throw new InvalidConfigurationException("Composite CPA must be informed about predicated analysis. Add cpa.composite.inPredicatedAnalysis=true to your configuration options.");
        }
        if (!(cpa.getMergeOperator() instanceof ARGMergeJoinPredicatedAnalysis)) {
            throw new InvalidConfigurationException("ARG CPA must be informed about predicated analysis. Add cpa.arg.inPredicatedAnalysis=true to your configuration options.");
        }
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Clean up from previous run"});
        for (CAssumeEdge edge : this.fakeEdgesFromLastRun) {
            edge.getPredecessor().removeLeavingEdge(edge);
            edge.getSuccessor().removeEnteringEdge(edge);
        }
        this.fakeEdgesFromLastRun.clear();
        this.logger.log(Level.FINEST, new Object[]{"Start analysis."});
        boolean result = false;
        try {
            result = this.algorithm.run(pReachedSet);
        }
        catch (PredicatedAnalysisPropertyViolationException e) {
            if (e.getFailureCause() == null) {
                throw new CPAException("Error state not known to predicated analysis algorithm. Cannot continue analysis.");
            }
            Precision precision = pReachedSet.getPrecision(((ARGState)e.getFailureCause()).getParents().iterator().next());
            if (e.getFailureCause() != null && !pReachedSet.contains(e.getFailureCause()) && ((ARGState)e.getFailureCause()).getParents().size() != 0) {
                pReachedSet.add(e.getFailureCause(), precision);
                for (ARGState parent : ((ARGState)e.getFailureCause()).getParents()) {
                    pReachedSet.reAddToWaitlist(parent);
                }
            }
            if (e.isMergeViolationCause()) {
                pReachedSet.add(((ARGState)e.getFailureCause()).getMergedWith(), precision);
                ((ARGMergeJoinPredicatedAnalysis)this.cpa.getMergeOperator()).cleanUp(pReachedSet);
            }
            this.logger.log(Level.FINEST, new Object[]{"Analysis aborted because error state found"});
            ARGState predecessor = (ARGState)pReachedSet.getLastState();
            CFANode node = AbstractStates.extractLocation(predecessor);
            this.logger.log(Level.FINEST, new Object[]{"Prepare for refinement by CEGAR algorithm"});
            PredicateAbstractState errorPred = AbstractStates.extractStateByType(predecessor, PredicateAbstractState.class);
            CompositeState comp = AbstractStates.extractStateByType(predecessor, CompositeState.class);
            if (!e.isMergeViolationCause() && errorPred.isAbstractionState()) {
                PredicateAbstractState prevErrorState = AbstractStates.extractStateByType(predecessor.getParents().iterator().next(), PredicateAbstractState.class);
                errorPred = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(errorPred.getAbstractionFormula().getBlockFormula(), prevErrorState);
                ImmutableList.Builder wrappedStates = ImmutableList.builder();
                for (AbstractState state : comp.getWrappedStates()) {
                    if (!(state instanceof PredicateAbstractState)) {
                        wrappedStates.add((Object)state);
                        continue;
                    }
                    wrappedStates.add((Object)errorPred);
                }
                comp = new CompositeState((List<AbstractState>)wrappedStates.build());
                assert (predecessor.getChildren().size() == 0);
                assert (predecessor.getParents().size() == 1);
                assert (predecessor.getCoveredByThis().size() == 0);
                ARGState newPred = new ARGState(comp, predecessor.getParents().iterator().next());
                predecessor.removeFromARG();
                pReachedSet.add(newPred, pReachedSet.getPrecision(predecessor));
                pReachedSet.remove(predecessor);
                predecessor = newPred;
            }
            CFANode predNode = node;
            try {
                for (AutomatonState s : AbstractStates.asIterable(predecessor).filter(AutomatonState.class)) {
                    if (!s.isTarget()) continue;
                    for (AssumeEdge assume : s.getAsAssumeEdges(node.getFunctionName())) {
                        predNode = this.createFakeEdge(assume.getRawStatement(), (CExpression)assume.getExpression(), predNode);
                    }
                }
            }
            catch (ClassCastException e2) {
                throw new CPAException("Predicated Analysis requires that the error condition is specified as a CExpression (statement) in the specification (automata).");
            }
            if (this.fakeEdgesFromLastRun.isEmpty()) {
                this.createFakeEdge("1", CIntegerLiteralExpression.ONE, predNode);
            }
            if (this.locConstructor == null) {
                try {
                    this.locConstructor = LocationState.class.getDeclaredConstructor(CFANode.class, Boolean.TYPE);
                    this.locConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException | SecurityException e1) {
                    throw new CPAException("Cannot prepare for refinement because cannot get constructor for location states.", e1);
                }
            }
            PathFormulaManager pfm = this.predCPA.getPathFormulaManager();
            PredicateAbstractionManager pam = this.predCPA.getPredicateManager();
            FormulaManagerView fm = this.predCPA.getSolver().getFormulaManager();
            PredicateAbstractState fakePred = errorPred;
            int i = 1;
            for (CAssumeEdge assumeEdge : this.fakeEdgesFromLastRun) {
                errorPred = fakePred;
                PathFormula pf = fakePred.getPathFormula();
                pf = pfm.makeAnd(pf, assumeEdge);
                if (i == this.fakeEdgesFromLastRun.size()) {
                    AbstractionFormula abf = pam.makeTrueAbstractionFormula(pf);
                    pf = pfm.makeEmptyPathFormula(pf);
                    PersistentMap abstractionLocations = errorPred.getAbstractionLocationsOnPath();
                    Integer newLocInstance = (Integer)MoreObjects.firstNonNull((Object)abstractionLocations.get((Object)assumeEdge.getSuccessor()), (Object)0) + 1;
                    abstractionLocations = abstractionLocations.putAndCopy((Object)assumeEdge.getSuccessor(), (Object)newLocInstance);
                    fakePred = PredicateAbstractState.mkAbstractionState(fm.getBooleanFormulaManager(), pf, abf, (PersistentMap<CFANode, Integer>)abstractionLocations);
                } else {
                    fakePred = PredicateAbstractState.mkNonAbstractionStateWithNewPathFormula(pf, fakePred);
                }
                ImmutableList.Builder wrappedStates = ImmutableList.builder();
                for (AbstractState state : comp.getWrappedStates()) {
                    if (state != errorPred) {
                        if (state instanceof LocationState) {
                            try {
                                wrappedStates.add((Object)this.locConstructor.newInstance(assumeEdge.getSuccessor(), true));
                                continue;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
                                throw new CPAException("Cannot prepare for refinement, cannot build necessary fake states.", e1);
                            }
                        }
                        wrappedStates.add((Object)state);
                        continue;
                    }
                    wrappedStates.add((Object)fakePred);
                }
                comp = new CompositeState((List<AbstractState>)wrappedStates.build());
                ARGState successor = new ARGState(comp, predecessor);
                pReachedSet.add(successor, pReachedSet.getPrecision(predecessor));
                predecessor = successor;
                ++i;
            }
            assert (ARGUtils.checkARG(pReachedSet));
            return true;
        }
        return result;
    }

    private CFANode createFakeEdge(String pRawAssumeExpr, CExpression pAssumeExpr, CFANode pPredecessor) {
        CFANode successor = new CFANode(pPredecessor.getFunctionName());
        CAssumeEdge assumeEdge = new CAssumeEdge(pRawAssumeExpr, FileLocation.DUMMY, pPredecessor, successor, pAssumeExpr, true);
        pPredecessor.addLeavingEdge(assumeEdge);
        successor.addEnteringEdge(assumeEdge);
        this.fakeEdgesFromLastRun.add(assumeEdge);
        return successor;
    }

    private void restartFromScratchAfterRefinement(ReachedSet pReachedSet) throws RefinementFailedException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Construct precision for current run"});
        Precision precision = this.buildInitialPrecision(pReachedSet.getPrecisions(), this.cpa.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()));
        this.oldPrecision = Precisions.extractPrecisionByType(precision, PredicatePrecision.class);
        pReachedSet.clear();
        if (this.initialWrappedState == null) {
            this.initialWrappedState = ((ARGState)this.cpa.getInitialState(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition())).getWrappedState();
        }
        pReachedSet.add(new ARGState(this.initialWrappedState, null), precision);
    }

    private Precision buildInitialPrecision(Collection<Precision> precisions, Precision initialPrecision) throws InterruptedException, RefinementFailedException {
        if (precisions.size() == 0) {
            return initialPrecision;
        }
        HashMultimap locationInstancPreds = HashMultimap.create();
        HashMultimap localPreds = HashMultimap.create();
        HashMultimap functionPreds = HashMultimap.create();
        HashSet<AbstractionPredicate> globalPreds = new HashSet<AbstractionPredicate>();
        HashSet<PredicatePrecision> seenPrecisions = new HashSet<PredicatePrecision>();
        PredicatePrecision predPrec = Precisions.extractPrecisionByType(initialPrecision, PredicatePrecision.class);
        locationInstancPreds.putAll(predPrec.getLocationInstancePredicates());
        localPreds.putAll(predPrec.getLocalPredicates());
        functionPreds.putAll(predPrec.getFunctionPredicates());
        globalPreds.addAll(predPrec.getGlobalPredicates());
        seenPrecisions.add(predPrec);
        for (Precision nextPrec : precisions) {
            predPrec = Precisions.extractPrecisionByType(nextPrec, PredicatePrecision.class);
            this.shutdownNotifier.shutdownIfNecessary();
            if (seenPrecisions.contains(predPrec)) continue;
            seenPrecisions.add(predPrec);
            locationInstancPreds.putAll(predPrec.getLocationInstancePredicates());
            localPreds.putAll(predPrec.getLocalPredicates());
            functionPreds.putAll(predPrec.getFunctionPredicates());
            globalPreds.addAll(predPrec.getGlobalPredicates());
        }
        PredicatePrecision newPredPrec = new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)locationInstancPreds, (Multimap<CFANode, AbstractionPredicate>)localPreds, (Multimap<String, AbstractionPredicate>)functionPreds, globalPreds);
        try {
            if (this.repeatedFailure && this.noNewPredicates(this.oldPrecision, newPredPrec)) {
                throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, this.pathToFailure);
            }
        }
        catch (SolverException e) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, this.pathToFailure, e);
        }
        return Precisions.replaceByType(initialPrecision, newPredPrec, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
    }

    private boolean noNewPredicates(PredicatePrecision oldPrecision, PredicatePrecision newPrecision) throws SolverException, InterruptedException {
        if (this.isMorePrecise(oldPrecision.getGlobalPredicates(), newPrecision.getGlobalPredicates())) {
            return false;
        }
        HashSet<String> funNames = new HashSet<String>();
        HashSet<CFANode> nodesOnPath = new HashSet<CFANode>();
        for (CFAEdge edge : this.pathToFailure.getInnerEdges()) {
            CFANode current = edge.getSuccessor();
            funNames.add(current.getFunctionName());
            nodesOnPath.add(current);
        }
        for (String funName : funNames) {
            if (!this.isMorePrecise((Set<AbstractionPredicate>)oldPrecision.getFunctionPredicates().get((Object)funName), (Set<AbstractionPredicate>)newPrecision.getFunctionPredicates().get((Object)funName))) continue;
            return false;
        }
        for (CFANode node : nodesOnPath) {
            if (!this.isMorePrecise((Set<AbstractionPredicate>)oldPrecision.getLocalPredicates().get((Object)node), (Set<AbstractionPredicate>)newPrecision.getLocalPredicates().get((Object)node))) continue;
            return false;
        }
        return true;
    }

    private boolean isMorePrecise(Set<AbstractionPredicate> lessPrecise, Set<AbstractionPredicate> morePrecise) throws SolverException, InterruptedException {
        if (lessPrecise != null && morePrecise != null) {
            if (lessPrecise.size() == morePrecise.size() && lessPrecise.equals(morePrecise)) {
                return false;
            }
            ArrayList<BooleanFormula> list = new ArrayList<BooleanFormula>(Math.max(lessPrecise.size(), morePrecise.size()));
            for (AbstractionPredicate abs : lessPrecise) {
                list.add(abs.getSymbolicAtom());
            }
            Solver solver = this.predCPA.getSolver();
            BooleanFormulaManagerView bfmgr = solver.getFormulaManager().getBooleanFormulaManager();
            BooleanFormula fLess = bfmgr.and(list);
            list.clear();
            for (AbstractionPredicate abs : lessPrecise) {
                list.add(abs.getSymbolicAtom());
            }
            BooleanFormula fMore = bfmgr.and(list);
            fMore = bfmgr.not(fMore);
            fMore = bfmgr.and(fLess, fMore);
            return solver.isUnsat(fMore);
        }
        return lessPrecise == null && morePrecise != null;
    }

    private boolean isSamePathInCFA(ARGPath path1, ARGPath path2) {
        if (path1.size() != path2.size()) {
            return false;
        }
        List edges1 = Lists.transform((List)path1.asStatesList().reverse(), AbstractStates.EXTRACT_LOCATION);
        List edges2 = Lists.transform((List)path2.asStatesList().reverse(), AbstractStates.EXTRACT_LOCATION);
        return edges1.equals(edges2);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
    }
}

