/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ExternalCBMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.RestrictedProgramDomainAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

@Options(prefix="restartAlgorithm")
public class RestartAlgorithm
implements Algorithm,
StatisticsProvider {
    private static final Splitter CONFIG_FILE_CONDITION_SPLITTER = Splitter.on((String)"::").trimResults().limit(2);
    @Option(secure=true, required=true, description="List of files with configurations to use. A filename can be suffixed with :if-interrupted, :if-failed, and :if-terminated which means that this configuration will only be used if the previous configuration ended with a matching condition.")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> configFiles;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final RestartAlgorithmStatistics stats;
    private final String filename;
    private final CFA cfa;
    private final Configuration globalConfig;
    private Algorithm currentAlgorithm;

    public RestartAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, String pFilename, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        if (this.configFiles.isEmpty()) {
            throw new InvalidConfigurationException("Need at least one configuration for restart algorithm!");
        }
        this.stats = new RestartAlgorithmStatistics(this.configFiles.size());
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.filename = pFilename;
        this.cfa = pCfa;
        this.globalConfig = config;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean run(ReachedSet pReached) throws CPAException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createNextAlgorithm(Path singleConfigFileName, CFANode mainFunction, ShutdownNotifier singleShutdownNotifier) throws InvalidConfigurationException, CPAException, InterruptedException, IOException {
        ReachedSet reached;
        ConfigurableProgramAnalysis cpa;
        Algorithm algorithm;
        ConfigurationBuilder singleConfigBuilder = Configuration.builder();
        singleConfigBuilder.copyFrom(this.globalConfig);
        singleConfigBuilder.clearOption("restartAlgorithm.configFiles");
        singleConfigBuilder.clearOption("analysis.restartAfterUnknown");
        singleConfigBuilder.loadFromFile(singleConfigFileName);
        if (this.globalConfig.hasProperty("specification")) {
            singleConfigBuilder.copyOptionFrom(this.globalConfig, "specification");
        }
        Configuration singleConfig = singleConfigBuilder.build();
        LogManager singleLogger = this.logger.withComponentName("Analysis" + (this.stats.noOfAlgorithmsUsed + 1));
        RestartAlgorithmOptions singleOptions = new RestartAlgorithmOptions();
        singleConfig.inject((Object)singleOptions);
        ResourceLimitChecker singleLimits = ResourceLimitChecker.fromConfiguration(singleConfig, singleLogger, singleShutdownNotifier);
        singleLimits.start();
        if (singleOptions.runCBMCasExternalTool) {
            algorithm = new ExternalCBMCAlgorithm(this.filename, singleConfig, singleLogger);
            cpa = null;
            reached = new ReachedSetFactory(singleConfig, singleLogger).create();
        } else {
            ReachedSetFactory singleReachedSetFactory = new ReachedSetFactory(singleConfig, singleLogger);
            cpa = this.createCPA(singleReachedSetFactory, singleConfig, singleLogger, singleShutdownNotifier, this.stats);
            algorithm = this.createAlgorithm(cpa, singleConfig, singleLogger, singleShutdownNotifier, this.stats, singleReachedSetFactory, singleOptions);
            reached = this.createInitialReachedSetForRestart(cpa, mainFunction, singleReachedSetFactory, singleLogger);
        }
        return Triple.of((Object)algorithm, (Object)cpa, (Object)reached);
    }

    private ReachedSet createInitialReachedSetForRestart(ConfigurableProgramAnalysis cpa, CFANode mainFunction, ReachedSetFactory pReachedSetFactory, LogManager singleLogger) {
        singleLogger.log(Level.FINE, new Object[]{"Creating initial reached set"});
        AbstractState initialState = cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition());
        Precision initialPrecision = cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition());
        ReachedSet reached = pReachedSetFactory.create();
        reached.add(initialState, initialPrecision);
        return reached;
    }

    private ConfigurableProgramAnalysis createCPA(ReachedSetFactory pReachedSetFactory, Configuration pConfig, LogManager singleLogger, ShutdownNotifier singleShutdownNotifier, RestartAlgorithmStatistics stats) throws InvalidConfigurationException, CPAException {
        singleLogger.log(Level.FINE, new Object[]{"Creating CPAs"});
        CPABuilder builder = new CPABuilder(pConfig, singleLogger, singleShutdownNotifier, pReachedSetFactory);
        ConfigurableProgramAnalysis cpa = builder.buildCPAWithSpecAutomatas(this.cfa);
        if (cpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)cpa)).collectStatistics(stats.getSubStatistics());
        }
        return cpa;
    }

    private Algorithm createAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, LogManager singleLogger, ShutdownNotifier singleShutdownNotifier, RestartAlgorithmStatistics stats, ReachedSetFactory singleReachedSetFactory, RestartAlgorithmOptions pOptions) throws InvalidConfigurationException, CPAException {
        singleLogger.log(Level.FINE, new Object[]{"Creating algorithms"});
        Algorithm algorithm = CPAAlgorithm.create(cpa, singleLogger, pConfig, singleShutdownNotifier);
        if (pOptions.useCEGAR) {
            algorithm = new CEGARAlgorithm(algorithm, cpa, pConfig, singleLogger);
        }
        if (pOptions.useBMC) {
            algorithm = new BMCAlgorithm(algorithm, cpa, pConfig, singleLogger, singleReachedSetFactory, singleShutdownNotifier, this.cfa);
        }
        if (pOptions.checkCounterexamples) {
            algorithm = new CounterexampleCheckAlgorithm(algorithm, cpa, pConfig, singleLogger, singleShutdownNotifier, this.cfa, this.filename);
        }
        if (pOptions.collectAssumptions) {
            algorithm = new AssumptionCollectorAlgorithm(algorithm, cpa, pConfig, singleLogger);
        }
        if (pOptions.unknownIfUnrestrictedProgram) {
            algorithm = new RestrictedProgramDomainAlgorithm(algorithm, cpa, this.cfa, singleLogger, pConfig, this.shutdownNotifier);
        }
        return algorithm;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.currentAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.currentAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    @Options
    private static class RestartAlgorithmOptions {
        @Option(secure=true, name="analysis.collectAssumptions", description="use assumption collecting algorithm")
        boolean collectAssumptions = false;
        @Option(secure=true, name="analysis.algorithm.CEGAR", description="use CEGAR algorithm for lazy counter-example guided analysis\nYou need to specify a refiner with the cegar.refiner option.\nCurrently all refiner require the use of the ARGCPA.")
        boolean useCEGAR = false;
        @Option(secure=true, name="analysis.checkCounterexamples", description="use a second model checking run (e.g., with CBMC or a different CPAchecker configuration) to double-check counter-examples")
        boolean checkCounterexamples = false;
        @Option(secure=true, name="analysis.algorithm.BMC", description="use a BMC like algorithm that checks for satisfiability after the analysis has finished, works only with PredicateCPA")
        boolean useBMC = false;
        @Option(secure=true, name="analysis.algorithm.CBMC", description="use CBMC as an external tool from CPAchecker")
        boolean runCBMCasExternalTool = false;
        @Option(secure=true, name="analysis.unknownIfUnrestrictedProgram", description="stop the analysis with the result unknown if the program does not satisfies certain restrictions.")
        private boolean unknownIfUnrestrictedProgram = false;

        private RestartAlgorithmOptions() {
        }
    }

    private static class RestartAlgorithmStatistics
    implements Statistics {
        private final int noOfAlgorithms;
        private final Collection<Statistics> subStats;
        private int noOfAlgorithmsUsed = 0;
        private Timer totalTime = new Timer();

        public RestartAlgorithmStatistics(int pNoOfAlgorithms) {
            this.noOfAlgorithms = pNoOfAlgorithms;
            this.subStats = new ArrayList<Statistics>();
        }

        public Collection<Statistics> getSubStatistics() {
            return this.subStats;
        }

        public void resetSubStatistics() {
            this.subStats.clear();
            this.totalTime = new Timer();
        }

        @Override
        public String getName() {
            return "Restart Algorithm";
        }

        private void printIntermediateStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            String text = "Statistics for algorithm " + this.noOfAlgorithmsUsed + " of " + this.noOfAlgorithms;
            out.println(text);
            out.println(Strings.repeat((String)"=", (int)text.length()));
            this.printSubStatistics(out, result, reached);
            out.println();
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            out.println("Number of algorithms provided:    " + this.noOfAlgorithms);
            out.println("Number of algorithms used:        " + this.noOfAlgorithmsUsed);
            this.printSubStatistics(out, result, reached);
        }

        private void printSubStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
            out.println("Total time for algorithm " + this.noOfAlgorithmsUsed + ": " + this.totalTime);
            for (Statistics s : this.subStats) {
                String name = s.getName();
                if (!Strings.isNullOrEmpty((String)name)) {
                    name = name + " statistics";
                    out.println("");
                    out.println(name);
                    out.println(Strings.repeat((String)"-", (int)name.length()));
                }
                s.printStatistics(out, result, reached);
            }
        }

        static /* synthetic */ Timer access$000(RestartAlgorithmStatistics x0) {
            return x0.totalTime;
        }

        static /* synthetic */ int access$108(RestartAlgorithmStatistics x0) {
            return x0.noOfAlgorithmsUsed++;
        }

        static /* synthetic */ void access$200(RestartAlgorithmStatistics x0, PrintStream x1, CPAcheckerResult.Result x2, ReachedSet x3) {
            x0.printIntermediateStatistics(x1, x2, x3);
        }
    }
}

