/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.util.VariableClassification;

public class RestrictedProgramDomainAlgorithm
implements Algorithm {
    private final Algorithm innerAlgorithm;
    private final CFA cfa;

    public RestrictedProgramDomainAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, CFA pCfa, LogManager pLogger, Configuration pConfig, ShutdownNotifier pShutdownNotifier) {
        this.innerAlgorithm = pAlgorithm;
        this.cfa = pCfa;
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException, PredicatedAnalysisPropertyViolationException {
        if (this.cfa.getVarClassification().isPresent() && ((VariableClassification)this.cfa.getVarClassification().get()).hasRelevantNonIntAddVars()) {
            return false;
        }
        return this.innerAlgorithm.run(pReachedSet);
    }
}

