/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Builder;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.EdgeFormulaNegation;
import org.sosy_lab.cpachecker.core.algorithm.bmc.KInductionProver;
import org.sosy_lab.cpachecker.core.algorithm.bmc.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.CPAInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.DoNothingInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.KInductionInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.UpdateListener;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.ReachedSetUtils;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;

@Options(prefix="bmc")
public class BMCAlgorithm
implements Algorithm,
StatisticsProvider {
    private static final Predicate<AbstractState> IS_STOP_STATE = Predicates.compose((Predicate)new Predicate<AssumptionStorageState>(){

        public boolean apply(AssumptionStorageState pArg0) {
            return pArg0 != null && pArg0.isStop();
        }
    }, AbstractStates.toState(AssumptionStorageState.class));
    private static final Set<String> CONCURRENT_FUNCTIONS = ImmutableSet.of((Object)"pthread_create");
    @Option(secure=true, description="If BMC did not find a bug, check whether the bounding did actually remove parts of the state space (this is similar to CBMC's unwinding assertions).")
    private boolean boundingAssertions = true;
    @Option(secure=true, description="Check reachability of target states after analysis (classical BMC). The alternative is to check the reachability as soon as the target states are discovered, which is done if cpa.predicate.targetStateSatCheck=true.")
    private boolean checkTargetStates = true;
    @Option(secure=true, description="try using induction to verify programs with loops")
    private boolean induction = false;
    @Option(secure=true, description="Generate invariants and add them to the induction hypothesis.")
    private boolean addInvariantsByAI = false;
    @Option(secure=true, description="Generate additional invariants by induction and add them to the induction hypothesis.")
    private boolean addInvariantsByInduction = true;
    @Option(secure=true, description="Adds pre-loop information to the induction hypothesis. This is unsound and should generally not be used; however it is provided as an implementation of the technique introduced in the SV-COMP 2013 competition contribution of ESBMC 1.20.")
    private boolean havocLoopTerminationConditionVariablesOnly = false;
    @Option(secure=true, description="dump counterexample formula to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dumpCounterexampleFormula = PathTemplate.ofFormatString((String)"ErrorPath.%d.smt2");
    private final BMCStatistics stats = new BMCStatistics();
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final ConfigurableProgramAnalysis stepCaseCPA;
    private final Algorithm stepCaseAlgorithm;
    private final InvariantGenerator invariantGenerator;
    private final FormulaManagerView fmgr;
    private final PathFormulaManager pmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final Solver solver;
    private final MachineModel machineModel;
    private final Configuration config;
    private final LogManager logger;
    private final ReachedSetFactory reachedSetFactory;
    private final CFA cfa;
    private final ShutdownNotifier shutdownNotifier;
    private final TargetLocationProvider targetLocationProvider;
    private final boolean isProgramConcurrent;
    private final List<UpdateListener> updateListeners = new CopyOnWriteArrayList<UpdateListener>();
    private final boolean isInvariantGenerator;
    private Function<Triple<CFANode, FormulaManagerView, PathFormulaManager>, BooleanFormula> locationInvariantsProvider = new Function<Triple<CFANode, FormulaManagerView, PathFormulaManager>, BooleanFormula>(){

        public BooleanFormula apply(Triple<CFANode, FormulaManagerView, PathFormulaManager> pArg0) {
            return ((FormulaManagerView)pArg0.getSecond()).getBooleanFormulaManager().makeBoolean(true);
        }
    };

    public BMCAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, CFA pCFA) throws InvalidConfigurationException, CPAException {
        this(pAlgorithm, pCPA, pConfig, pLogger, pReachedSetFactory, pShutdownNotifier, pCFA, false);
    }

    public BMCAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, Configuration pConfig, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, CFA pCFA, boolean pIsInvariantGenerator) throws InvalidConfigurationException, CPAException {
        pConfig.inject((Object)this);
        this.algorithm = pAlgorithm;
        this.cpa = pCPA;
        this.config = pConfig;
        this.logger = pLogger;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCFA;
        CPABuilder builder = new CPABuilder(pConfig, pLogger, pShutdownNotifier, pReachedSetFactory);
        this.stepCaseCPA = builder.buildCPAWithSpecAutomatas(this.cfa);
        this.stepCaseAlgorithm = CPAAlgorithm.create(this.stepCaseCPA, pLogger, pConfig, pShutdownNotifier);
        this.isInvariantGenerator = pIsInvariantGenerator;
        if (!this.isInvariantGenerator && this.induction && this.addInvariantsByInduction) {
            this.addInvariantsByInduction = false;
            ShutdownNotifier invGenBMCShutdownNotfier = ShutdownNotifier.createWithParent(pShutdownNotifier);
            ConfigurationBuilder invGenBMCConfigBuilder = new Builder().copyFrom(pConfig);
            if (pLogger.wouldBeLogged(Level.INFO)) {
                invGenBMCConfigBuilder.setOption("log.consoleLevel", Level.FINE.getName());
            }
            Configuration invGenBMCConfig = invGenBMCConfigBuilder.build();
            CPABuilder invGenBMCBuilder = new CPABuilder(invGenBMCConfig, pLogger, invGenBMCShutdownNotfier, pReachedSetFactory);
            ConfigurableProgramAnalysis invGenBMCCPA = invGenBMCBuilder.buildCPAWithSpecAutomatas(this.cfa);
            CPAAlgorithm invGenBMCCPAAlgorithm = CPAAlgorithm.create(invGenBMCCPA, pLogger, invGenBMCConfig, invGenBMCShutdownNotfier);
            BMCAlgorithm invGenBMC = new BMCAlgorithm(invGenBMCCPAAlgorithm, invGenBMCCPA, invGenBMCConfig, pLogger, pReachedSetFactory, invGenBMCShutdownNotfier, pCFA, true);
            PredicateCPA stepCasePredicateCPA = CPAs.retrieveCPA(this.stepCaseCPA, PredicateCPA.class);
            KInductionInvariantGenerator kIndInvGen = new KInductionInvariantGenerator(invGenBMC, pReachedSetFactory, invGenBMCCPA, pLogger, invGenBMCShutdownNotfier, pCFA, stepCasePredicateCPA.getPathFormulaManager(), true);
            this.invariantGenerator = kIndInvGen;
            this.invariantGenerator.addUpdateListener(new UpdateListener(){

                @Override
                public void updated() {
                    BMCAlgorithm.this.notifyUpdateListeners();
                }
            });
        } else {
            this.invariantGenerator = this.induction && this.addInvariantsByAI ? new CPAInvariantGenerator(pConfig, pLogger, this.reachedSetFactory, pShutdownNotifier, this.cfa) : new DoNothingInvariantGenerator(this.reachedSetFactory);
        }
        this.invariantGenerator.addUpdateListener(new UpdateListener(){

            @Override
            public void updated() {
                BMCAlgorithm.this.notifyUpdateListeners();
            }
        });
        this.stats.invariantGeneration = this.invariantGenerator.getTimeOfExecution();
        PredicateCPA predCpa = CPAs.retrieveCPA(this.cpa, PredicateCPA.class);
        if (predCpa == null) {
            throw new InvalidConfigurationException("PredicateCPA needed for BMCAlgorithm");
        }
        this.solver = predCpa.getSolver();
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pmgr = predCpa.getPathFormulaManager();
        this.shutdownNotifier = pShutdownNotifier;
        this.machineModel = predCpa.getMachineModel();
        this.targetLocationProvider = new TargetLocationProvider(this.reachedSetFactory, this.shutdownNotifier, this.logger, pConfig, this.cfa);
        this.isProgramConcurrent = FluentIterable.from(this.cfa.getAllFunctionNames()).anyMatch(Predicates.in(CONCURRENT_FUNCTIONS));
    }

    public BooleanFormula getCurrentLocationInvariants(CFANode pLocation, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) {
        return (BooleanFormula)this.locationInvariantsProvider.apply((Object)Triple.of((Object)pLocation, (Object)pFMGR, (Object)pPFMGR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        ReachedSet reachedSet = pReachedSet;
        CFANode initialLocation = AbstractStates.extractLocation(reachedSet.getFirstState());
        this.invariantGenerator.start(initialLocation);
        Set<CandidateInvariant> candidateInvariants = this.getCandidateInvariants();
        try {
            if (candidateInvariants.isEmpty()) {
                Iterator i$2 = FluentIterable.from(reachedSet.getWaitlist()).toList().iterator();
                while (true) {
                    if (!i$2.hasNext()) {
                        boolean i$2 = true;
                        return i$2;
                    }
                    AbstractState state = (AbstractState)i$2.next();
                    reachedSet.removeOnlyFromWaitlist(state);
                }
            }
            try (ProverEnvironment prover = this.solver.newProverEnvironmentWithModelGeneration();
                 final KInductionProver kInductionProver = this.createInductionProver();){
                boolean soundInner;
                if (this.induction) {
                    kInductionProver.setCandidateInvariants((Set<CandidateInvariant>)ImmutableSet.of((Object)TargetLocationCandidateInvariant.INSTANCE));
                    this.locationInvariantsProvider = new Function<Triple<CFANode, FormulaManagerView, PathFormulaManager>, BooleanFormula>(){

                        public BooleanFormula apply(Triple<CFANode, FormulaManagerView, PathFormulaManager> pArg0) {
                            CFANode location = (CFANode)pArg0.getFirst();
                            FormulaManagerView fmgr = (FormulaManagerView)pArg0.getSecond();
                            PathFormulaManager pfmgr = (PathFormulaManager)pArg0.getThird();
                            try {
                                return kInductionProver.getCurrentLocationInvariants(location, fmgr, pfmgr);
                            }
                            catch (InterruptedException | CPAException e) {
                                return fmgr.getBooleanFormulaManager().makeBoolean(true);
                            }
                        }
                    };
                }
                do {
                    this.shutdownNotifier.shutdownIfNecessary();
                    this.logger.log(Level.INFO, new Object[]{"Creating formula for program"});
                    soundInner = BMCHelper.unroll(this.logger, reachedSet, this.algorithm, this.cpa);
                    if (FluentIterable.from((Iterable)reachedSet).skip(1).transform(AbstractStates.toState(PredicateAbstractState.class)).anyMatch(PredicateAbstractState.FILTER_ABSTRACTION_STATES)) {
                        this.logger.log(Level.WARNING, new Object[]{"BMC algorithm does not work with abstractions. Could not check for satisfiability!"});
                        boolean bl = soundInner;
                        return bl;
                    }
                    Iterator<CandidateInvariant> candidateInvariantIterator = candidateInvariants.iterator();
                    while (candidateInvariantIterator.hasNext()) {
                        boolean safe;
                        CandidateInvariant candidateInvariant = candidateInvariantIterator.next();
                        if (!this.checkTargetStates && candidateInvariant.violationIndicatesError() || (safe = this.boundedModelCheck(reachedSet, prover, candidateInvariant))) continue;
                        candidateInvariantIterator.remove();
                        if (!candidateInvariant.violationIndicatesError()) continue;
                        boolean bl = soundInner;
                        return bl;
                    }
                    boolean sound = false;
                    if (!soundInner) continue;
                    sound = this.checkBoundingAssertions(reachedSet, prover);
                    if (this.induction) {
                        kInductionProver.setCandidateInvariants(candidateInvariants);
                        boolean bl = sound = sound || kInductionProver.check();
                        if (candidateInvariants.removeAll(kInductionProver.getConfirmedCandidates())) {
                            this.notifyUpdateListeners();
                        }
                    }
                    if (!sound) continue;
                    boolean bl = true;
                    return bl;
                } while (soundInner && this.adjustConditions());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.isInvariantGenerator) {
                this.invariantGenerator.cancel();
            }
            if (reachedSet != pReachedSet) {
                pReachedSet.clear();
                ReachedSetUtils.addReachedStatesToOtherReached(reachedSet, pReachedSet);
            }
        }
    }

    private Set<CandidateInvariant> getCandidateInvariants() {
        Collection<CFANode> targetLocations;
        HashSet result = Sets.newHashSet();
        if (this.isProgramConcurrent) {
            targetLocations = this.cfa.getAllNodes();
        } else {
            boolean skipRecursion = Boolean.parseBoolean(this.config.getProperty("cpa.callstack.skipRecursion"));
            targetLocations = this.targetLocationProvider.tryGetAutomatonTargetLocations(this.cfa.getMainFunction(), skipRecursion);
            if (targetLocations == null) {
                targetLocations = this.cfa.getAllNodes();
            }
        }
        if (!this.isInvariantGenerator) {
            if (!targetLocations.isEmpty()) {
                result.add(TargetLocationCandidateInvariant.INSTANCE);
            }
        } else if (this.cfa.getLoopStructure().isPresent()) {
            LoopStructure loopStructure = (LoopStructure)this.cfa.getLoopStructure().get();
            for (CFAEdge assumeEdge : this.getRelevantAssumeEdges(targetLocations)) {
                result.add(new EdgeFormulaNegation((Set<CFANode>)loopStructure.getAllLoopHeads(), assumeEdge));
            }
        }
        return result;
    }

    private Set<CFAEdge> getRelevantAssumeEdges(Collection<CFANode> pTargetLocations) {
        HashSet<CFAEdge> assumeEdges = new HashSet<CFAEdge>();
        HashSet<CFANode> visited = new HashSet<CFANode>(pTargetLocations);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>(pTargetLocations);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(current)) {
                CFANode predecessor = enteringEdge.getPredecessor();
                if (enteringEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                    assumeEdges.add(enteringEdge);
                    continue;
                }
                if (!visited.add(predecessor)) continue;
                waitlist.add(predecessor);
            }
        }
        return assumeEdges;
    }

    private boolean adjustConditions() {
        FluentIterable conditionCPAs = CPAs.asIterable(this.cpa).filter(AdjustableConditionCPA.class);
        for (AdjustableConditionCPA condCpa : conditionCPAs) {
            if (condCpa.adjustPrecision()) continue;
            this.logger.log(Level.INFO, new Object[]{"Terminating because of", condCpa.getClass().getSimpleName()});
            return false;
        }
        return !Iterables.isEmpty((Iterable)conditionCPAs);
    }

    private void createErrorPath(ReachedSet pReachedSet, ProverEnvironment pProver) throws CPATransferException, InterruptedException {
        this.addCounterexampleTo(pReachedSet, pProver, new CounterexampleStorage(){

            @Override
            public void addCounterexample(ARGState pTargetState, CounterexampleInfo pCounterexample) {
                ((ARGCPA)BMCAlgorithm.this.cpa).addCounterexample(pTargetState, pCounterexample);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCounterexampleTo(ReachedSet pReachedSet, ProverEnvironment pProver, CounterexampleStorage pCounterexampleStorage) throws CPATransferException, InterruptedException {
        block32: {
            ARGPath targetPath;
            Model model;
            boolean shouldCheckBranching;
            if (!(this.cpa instanceof ARGCPA)) {
                this.logger.log(Level.INFO, new Object[]{"Error found, but error path cannot be created without ARGCPA"});
                return;
            }
            this.stats.errorPathCreation.start();
            this.logger.log(Level.INFO, new Object[]{"Error found, creating error path"});
            ImmutableSet targetStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates.IS_TARGET_STATE).filter(ARGState.class).toSet();
            if (targetStates.size() == 1) {
                ARGState state = (ARGState)Iterables.getOnlyElement((Iterable)targetStates);
                while (state.getParents().size() == 1 && state.getChildren().size() <= 1) {
                    state = (ARGState)Iterables.getOnlyElement(state.getParents());
                }
                shouldCheckBranching = state.getParents().size() > 1 || state.getChildren().size() > 1;
            } else {
                shouldCheckBranching = true;
            }
            if (shouldCheckBranching) {
                FluentIterable arg = FluentIterable.from((Iterable)pReachedSet).filter(ARGState.class);
                BooleanFormula branchingFormula = this.pmgr.buildBranchingFormula((Iterable<ARGState>)arg);
                if (this.bfmgr.isTrue(branchingFormula)) {
                    this.logger.log(Level.WARNING, new Object[]{"Could not create error path because of missing branching information!"});
                    return;
                }
                pProver.push(branchingFormula);
            }
            try {
                boolean stillSatisfiable;
                boolean bl = stillSatisfiable = !pProver.isUnsat();
                if (!stillSatisfiable) {
                    this.logger.log(Level.WARNING, new Object[]{"Could not create error path information because of inconsistent branching information!"});
                    return;
                }
                model = pProver.getModel();
            }
            catch (SolverException e) {
                this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, cannot create error path."});
                this.logger.logDebugException((Throwable)e);
                this.stats.errorPathCreation.stop();
                return;
            }
            finally {
                if (shouldCheckBranching) {
                    pProver.pop();
                }
            }
            Map<Integer, Boolean> branchingInformation = this.pmgr.getBranchingPredicateValuesFromModel(model);
            ARGState root = (ARGState)pReachedSet.getFirstState();
            try {
                targetPath = ARGUtils.getPathFromBranchingInformation(root, pReachedSet.asCollection(), branchingInformation);
            }
            catch (IllegalArgumentException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not create error path");
                this.stats.errorPathCreation.stop();
                return;
            }
            {
                CounterexampleInfo counterexample;
                Solver solver = this.solver;
                PathFormulaManager pmgr = this.pmgr;
                if (solver.getFormulaManager().getVersion().toLowerCase().contains("smtinterpol")) {
                    try {
                        solver = Solver.create(this.config, this.logger, this.shutdownNotifier);
                        FormulaManagerView formulaManager = solver.getFormulaManager();
                        pmgr = new PathFormulaManagerImpl(formulaManager, this.config, this.logger, this.shutdownNotifier, this.cfa, AnalysisDirection.FORWARD);
                    }
                    catch (InvalidConfigurationException e) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path to get a more precise model");
                        this.stats.errorPathCreation.stop();
                        return;
                    }
                }
                PathChecker pathChecker = new PathChecker(this.logger, this.shutdownNotifier, pmgr, solver, this.machineModel);
                try {
                    CounterexampleTraceInfo info = pathChecker.checkPath(targetPath.getInnerEdges());
                    if (info.isSpurious()) {
                        this.logger.log(Level.WARNING, new Object[]{"Inconsistent replayed error path!"});
                        counterexample = CounterexampleInfo.feasible(targetPath, model);
                    } else {
                        counterexample = CounterexampleInfo.feasible(targetPath, info.getModel());
                        counterexample.addFurtherInformation(this.fmgr.dumpFormula(this.bfmgr.and(info.getCounterExampleFormulas())), this.dumpCounterexampleFormula);
                    }
                }
                catch (CPATransferException | SolverException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not replay error path to get a more precise model");
                    counterexample = CounterexampleInfo.feasible(targetPath, model);
                }
                pCounterexampleStorage.addCounterexample(targetPath.getLastState(), counterexample);
                break block32;
            }
            finally {
                this.stats.errorPathCreation.stop();
            }
        }
    }

    private boolean boundedModelCheck(ReachedSet pReachedSet, ProverEnvironment pProver, CandidateInvariant pInductionProblem) throws CPATransferException, InterruptedException, SolverException {
        BooleanFormula program = this.bfmgr.not(pInductionProblem.getAssertion(pReachedSet, this.fmgr, this.pmgr));
        this.logger.log(Level.INFO, new Object[]{"Starting satisfiability check..."});
        this.stats.satCheck.start();
        pProver.push(program);
        boolean safe = pProver.isUnsat();
        this.stats.satCheck.stop();
        if (pInductionProblem.violationIndicatesError()) {
            this.logger.log(Level.FINER, new Object[]{"Program is safe?:", safe});
            if (!safe) {
                this.createErrorPath(pReachedSet, pProver);
            }
        }
        if (safe) {
            pInductionProblem.assumeTruth(pReachedSet);
        }
        pProver.pop();
        return safe;
    }

    private boolean checkBoundingAssertions(ReachedSet pReachedSet, ProverEnvironment prover) throws SolverException, InterruptedException {
        FluentIterable stopStates = FluentIterable.from((Iterable)pReachedSet).filter(IS_STOP_STATE);
        if (this.boundingAssertions) {
            BooleanFormula assertions = BMCHelper.createFormulaFor((Iterable<AbstractState>)stopStates, this.bfmgr);
            this.logger.log(Level.INFO, new Object[]{"Starting assertions check..."});
            this.stats.assertionsCheck.start();
            prover.push(assertions);
            boolean sound = prover.isUnsat();
            prover.pop();
            this.stats.assertionsCheck.stop();
            this.logger.log(Level.FINER, new Object[]{"Soundness after assertion checks:", sound});
            return sound;
        }
        return stopStates.isEmpty();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.algorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.algorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private KInductionProver createInductionProver() {
        Supplier<Integer> bmcKAccessor = new Supplier<Integer>(){

            public Integer get() {
                LoopstackCPA loopstackCPA = CPAs.retrieveCPA(BMCAlgorithm.this.cpa, LoopstackCPA.class);
                return loopstackCPA.getMaxLoopIterations();
            }
        };
        return this.induction ? new KInductionProver(this.cfa, this.logger, this.stepCaseAlgorithm, this.stepCaseCPA, this.invariantGenerator, this.stats, this.reachedSetFactory, this.targetLocationProvider, this.havocLoopTerminationConditionVariablesOnly, bmcKAccessor, this.shutdownNotifier) : null;
    }

    public void addUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.add(pUpdateListener);
    }

    public void removeUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.remove(pUpdateListener);
    }

    private void notifyUpdateListeners() {
        for (UpdateListener updateListener : this.updateListeners) {
            updateListener.updated();
        }
    }

    static List<BooleanFormula> transform(Collection<EdgeFormulaNegation> pCandidates, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>(pCandidates.size());
        for (EdgeFormulaNegation candidate : pCandidates) {
            formulas.add(candidate.getCandidate(pFMGR, pPFMGR));
        }
        return formulas;
    }

    private static interface CounterexampleStorage {
        public void addCounterexample(ARGState var1, CounterexampleInfo var2);
    }
}

