/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ReachedSetInitializer;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

final class BMCHelper {
    private BMCHelper() {
    }

    public static Iterable<BooleanFormula> assertAt(Iterable<AbstractState> pStates, final BooleanFormula pUninstantiatedFormula, final FormulaManagerView pFMGR) {
        return FluentIterable.from(pStates).transform((Function)new Function<AbstractState, BooleanFormula>(){

            public BooleanFormula apply(AbstractState pInput) {
                return BMCHelper.assertAt(pInput, pUninstantiatedFormula, pFMGR, 1);
            }
        });
    }

    public static Iterable<BooleanFormula> assertAtWithIncrementingDefaultIndex(Iterable<AbstractState> pStates, BooleanFormula pUninstantiatedFormula, FormulaManagerView pFMGR, int firstDefault) {
        ImmutableSet.Builder formulas = ImmutableSet.builder();
        int defaultIndex = firstDefault;
        for (AbstractState state : pStates) {
            formulas.add((Object)BMCHelper.assertAt(state, pUninstantiatedFormula, pFMGR, defaultIndex));
            ++defaultIndex;
        }
        return formulas.build();
    }

    public static BooleanFormula assertAt(AbstractState pState, BooleanFormula pUninstantiatedFormula, FormulaManagerView pFMGR, int pDefaultIndex) {
        PredicateAbstractState pas = AbstractStates.extractStateByType(pState, PredicateAbstractState.class);
        PathFormula pathFormula = pas.getPathFormula();
        BooleanFormula instantiatedFormula = pFMGR.instantiate(pUninstantiatedFormula, pathFormula.getSsa().withDefault(pDefaultIndex));
        BooleanFormula stateFormula = pathFormula.getFormula();
        BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        return bfmgr.or(bfmgr.not(stateFormula), instantiatedFormula);
    }

    public static BooleanFormula createFormulaFor(Iterable<AbstractState> states, BooleanFormulaManager pBFMGR) {
        BooleanFormula f = pBFMGR.makeBoolean(false);
        for (PredicateAbstractState e : AbstractStates.projectToType(states, PredicateAbstractState.class)) {
            f = pBFMGR.or(f, e.getPathFormula().getFormula());
        }
        return f;
    }

    public static boolean unroll(LogManager pLogger, ReachedSet pReachedSet, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA) throws CPAException, InterruptedException {
        return BMCHelper.unroll(pLogger, pReachedSet, new ReachedSetInitializer(){

            @Override
            public void initialize(ReachedSet pReachedSet) {
            }
        }, pAlgorithm, pCPA);
    }

    public static boolean unroll(LogManager pLogger, ReachedSet pReachedSet, ReachedSetInitializer pInitializer, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA) throws CPAException, InterruptedException {
        BMCHelper.adjustReachedSet(pLogger, pReachedSet, pInitializer, pCPA);
        return pAlgorithm.run(pReachedSet);
    }

    public static void adjustReachedSet(LogManager pLogger, ReachedSet pReachedSet, ReachedSetInitializer pInitializer, ConfigurableProgramAnalysis pCPA) throws CPAException, InterruptedException {
        Preconditions.checkArgument((!pReachedSet.isEmpty() ? 1 : 0) != 0);
        CFANode initialLocation = AbstractStates.extractLocation(pReachedSet.getFirstState());
        for (AdjustableConditionCPA conditionCPA : CPAs.asIterable(pCPA).filter(AdjustableConditionCPA.class)) {
            if (conditionCPA instanceof ReachedSetAdjustingCPA) {
                ((ReachedSetAdjustingCPA)conditionCPA).adjustReachedSet(pReachedSet);
                continue;
            }
            pReachedSet.clear();
            pLogger.log(Level.WARNING, new Object[]{"Completely clearing the reached set after condition adjustment due to " + conditionCPA.getClass() + ". This may drastically impede the efficiency of iterative deepening. Implement ReachedSetAdjustingCPA to avoid this problem."});
            break;
        }
        if (pReachedSet.isEmpty()) {
            pInitializer.initialize(pReachedSet);
            pReachedSet.add(pCPA.getInitialState(initialLocation, StateSpacePartition.getDefaultPartition()), pCPA.getInitialPrecision(initialLocation, StateSpacePartition.getDefaultPartition()));
        }
    }
}

