/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import java.io.PrintStream;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;

class BMCStatistics
implements Statistics {
    final Timer satCheck = new Timer();
    final Timer errorPathCreation = new Timer();
    final Timer assertionsCheck = new Timer();
    final Timer inductionPreparation = new Timer();
    final Timer inductionCheck = new Timer();
    Timer invariantGeneration;
    private int inductionCutPoints = 0;

    BMCStatistics() {
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        if (this.satCheck.getNumberOfIntervals() > 0) {
            out.println("Time for final sat check:            " + this.satCheck);
        }
        if (this.errorPathCreation.getNumberOfIntervals() > 0) {
            out.println("Time for error path creation:        " + this.errorPathCreation);
        }
        if (this.assertionsCheck.getNumberOfIntervals() > 0) {
            out.println("Time for bounding assertions check:  " + this.assertionsCheck);
        }
        if (this.inductionCheck.getNumberOfIntervals() > 0) {
            out.println("Number of cut points for induction:  " + this.inductionCutPoints);
            out.println("Time for induction formula creation: " + this.inductionPreparation);
            if (this.invariantGeneration.getNumberOfIntervals() > 0) {
                out.println("  Time for invariant generation:     " + this.invariantGeneration);
            }
            out.println("Time for induction check:            " + this.inductionCheck);
        }
    }

    @Override
    public String getName() {
        return "BMC algorithm";
    }
}

