/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.CPAInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class EdgeFormulaNegation
implements CandidateInvariant {
    private final CFAEdge edge;
    private final Set<CFANode> locations;

    public EdgeFormulaNegation(Set<CFANode> pLocations, CFAEdge pEdge) {
        Preconditions.checkNotNull(pLocations);
        Preconditions.checkNotNull((Object)pEdge);
        this.locations = pLocations;
        this.edge = pEdge;
    }

    private Optional<AssumeEdge> getAssumeEdge() {
        if (this.edge instanceof AssumeEdge) {
            AssumeEdge assumeEdge = (AssumeEdge)this.edge;
            CFANode predecessor = assumeEdge.getPredecessor();
            AssumeEdge otherEdge = (AssumeEdge)CFAUtils.leavingEdges(predecessor).filter(Predicates.not((Predicate)Predicates.equalTo((Object)this.edge))).filter(AssumeEdge.class).iterator().next();
            return Optional.of((Object)otherEdge);
        }
        return Optional.absent();
    }

    public BooleanFormula getCandidate(FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        PathFormula invariantPathFormula = pPFMGR.makeFormulaForPath(Collections.singletonList(this.edge));
        return pFMGR.getBooleanFormulaManager().not(pFMGR.uninstantiate(invariantPathFormula.getFormula()));
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof EdgeFormulaNegation) {
            EdgeFormulaNegation other = (EdgeFormulaNegation)pO;
            return this.edge.equals(other.edge);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getAssumeEdge()});
    }

    public String toString() {
        Optional<AssumeEdge> assumeEdge = this.getAssumeEdge();
        if (assumeEdge.isPresent()) {
            return ((AssumeEdge)assumeEdge.get()).toString();
        }
        return String.format("not (%s)", this.edge);
    }

    @Override
    public BooleanFormula getAssertion(ReachedSet pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        FluentIterable<AbstractState> locationStates = AbstractStates.filterLocations(pReachedSet, this.locations);
        FluentIterable assertions = FluentIterable.from(BMCHelper.assertAt(locationStates, this.getCandidate(pFMGR, pPFMGR), pFMGR));
        return pFMGR.getBooleanFormulaManager().and((List<BooleanFormula>)assertions.toList());
    }

    @Override
    public boolean violationIndicatesError() {
        return false;
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        if (this.locations.contains(this.edge.getPredecessor())) {
            ImmutableList infeasibleStates = FluentIterable.from(AbstractStates.filterLocation(pReachedSet, this.edge.getSuccessor())).toList();
            pReachedSet.removeAll((Iterable<? extends AbstractState>)infeasibleStates);
            for (ARGState s : FluentIterable.from((Iterable)infeasibleStates).filter(ARGState.class)) {
                s.removeFromARG();
            }
        }
    }

    @Override
    public Set<CFANode> getLocations(CFA pCFA) {
        return Collections.unmodifiableSet(this.locations);
    }

    @Override
    public void attemptInjection(InvariantGenerator pInvariantGenerator) throws UnrecognizedCodeException {
        Optional<AssumeEdge> assumption;
        CPAInvariantGenerator invGen;
        InvariantsCPA invariantsCPA;
        if (pInvariantGenerator instanceof CPAInvariantGenerator && (invariantsCPA = CPAs.retrieveCPA((invGen = (CPAInvariantGenerator)pInvariantGenerator).getCPAs(), InvariantsCPA.class)) != null && (assumption = this.getAssumeEdge()).isPresent()) {
            for (CFANode location : this.locations) {
                invariantsCPA.injectInvariant(location, (AssumeEdge)assumption.get());
            }
        }
    }
}

