/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import javax.annotation.concurrent.GuardedBy;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.EdgeFormulaNegation;
import org.sosy_lab.cpachecker.core.algorithm.bmc.ReachedSetInitializer;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.edgeexclusion.EdgeExclusionPrecision;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackCPA;
import org.sosy_lab.cpachecker.cpa.loopstack.LoopstackState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

class KInductionProver
implements AutoCloseable {
    private final CFA cfa;
    private final LogManager logger;
    private final Algorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final Boolean trivialResult;
    private final ReachedSet reachedSet;
    private final LoopStructure.Loop loop;
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PathFormulaManager pfmgr;
    private final BMCStatistics stats;
    private final ReachedSetFactory reachedSetFactory;
    private final ReachedSetInitializer reachedSetInitializer = new ReachedSetInitializer(){

        @Override
        public void initialize(ReachedSet pReachedSet) throws CPAException, InterruptedException {
            KInductionProver.this.ensureReachedSetInitialized(pReachedSet);
        }
    };
    private final InvariantGenerator invariantGenerator;
    private final boolean havocLoopTerminationConditionVariablesOnly;
    private final Supplier<Integer> bmcKAccessor;
    private ProverEnvironment prover = null;
    private UnmodifiableReachedSet invariantsReachedSet;
    private BooleanFormula loopHeadInvariants;
    private int stackDepth = 0;
    private final Map<CandidateInvariant, BooleanFormula> violationFormulas = Maps.newHashMap();
    private int previousK = -1;
    private final Set<CandidateInvariant> confirmedCandidates = new CopyOnWriteArraySet<CandidateInvariant>();
    @GuardedBy(value="this")
    private ImmutableSet<CandidateInvariant> candidateInvariants = ImmutableSet.of();
    private boolean invariantGenerationRunning = true;

    public KInductionProver(CFA pCFA, LogManager pLogger, Algorithm pAlgorithm, ConfigurableProgramAnalysis pCPA, InvariantGenerator pInvariantGenerator, BMCStatistics pStats, ReachedSetFactory pReachedSetFactory, TargetLocationProvider pTargetLocationProvider, boolean pHavocLoopTerminationConditionVariablesOnly, Supplier<Integer> pBMCKAccessor, ShutdownNotifier pShutdownNotifier) {
        Preconditions.checkNotNull((Object)pCFA);
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkNotNull((Object)pAlgorithm);
        Preconditions.checkNotNull((Object)pCPA);
        Preconditions.checkNotNull((Object)pInvariantGenerator);
        Preconditions.checkNotNull((Object)pStats);
        Preconditions.checkNotNull((Object)pReachedSetFactory);
        Preconditions.checkNotNull(pBMCKAccessor);
        Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.cfa = pCFA;
        this.logger = pLogger;
        this.algorithm = pAlgorithm;
        this.cpa = pCPA;
        this.invariantGenerator = pInvariantGenerator;
        this.stats = pStats;
        this.reachedSetFactory = pReachedSetFactory;
        this.havocLoopTerminationConditionVariablesOnly = pHavocLoopTerminationConditionVariablesOnly;
        this.bmcKAccessor = pBMCKAccessor;
        ImmutableList incomingEdges = null;
        ReachedSet reachedSet = null;
        LoopStructure.Loop loop = null;
        if (!this.cfa.getLoopStructure().isPresent()) {
            this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop structure of program could not be determined."});
            this.trivialResult = false;
        } else {
            LoopStructure loops = (LoopStructure)this.cfa.getLoopStructure().get();
            if (loops.getCount() > 1) {
                this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, program has too many loops"});
                this.invariantGenerator.cancel();
                this.trivialResult = false;
            } else if (loops.getCount() == 0) {
                this.invariantGenerator.cancel();
                this.trivialResult = true;
            } else {
                this.stats.inductionPreparation.start();
                loop = (LoopStructure.Loop)Iterables.getOnlyElement(loops.getAllLoops());
                incomingEdges = FluentIterable.from(loop.getIncomingEdges()).filter(Predicates.not((Predicate)Predicates.instanceOf(CFunctionReturnEdge.class))).toList();
                if (incomingEdges.size() > 1) {
                    this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop has too many incoming edges", incomingEdges});
                    this.trivialResult = false;
                } else if (loop.getLoopHeads().size() > 1) {
                    this.logger.log(Level.WARNING, new Object[]{"Could not use induction for proving program safety, loop has too many loop heads"});
                    this.trivialResult = false;
                } else {
                    this.trivialResult = null;
                    reachedSet = this.reachedSetFactory.create();
                }
                this.stats.inductionPreparation.stop();
            }
        }
        PredicateCPA stepCasePredicateCPA = CPAs.retrieveCPA(this.cpa, PredicateCPA.class);
        this.solver = stepCasePredicateCPA.getSolver();
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pfmgr = stepCasePredicateCPA.getPathFormulaManager();
        this.loopHeadInvariants = this.bfmgr.makeBoolean(true);
        this.invariantsReachedSet = this.reachedSetFactory.create();
        this.reachedSet = reachedSet;
        this.loop = loop;
    }

    public Collection<CandidateInvariant> getConfirmedCandidates() {
        return this.confirmedCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<CandidateInvariant> setCandidateInvariants(Set<CandidateInvariant> pCandidateInvariants) {
        KInductionProver kInductionProver = this;
        synchronized (kInductionProver) {
            this.candidateInvariants = FluentIterable.from(pCandidateInvariants).filter(Predicates.not((Predicate)Predicates.in(this.confirmedCandidates))).toSet();
            return this.candidateInvariants;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableSet<CandidateInvariant> getCandidateInvariants() {
        KInductionProver kInductionProver = this;
        synchronized (kInductionProver) {
            return FluentIterable.from(this.candidateInvariants).filter(Predicates.not((Predicate)Predicates.in(this.confirmedCandidates))).toSet();
        }
    }

    boolean isTrivial() {
        return this.trivialResult != null;
    }

    private boolean getTrivialResult() {
        Preconditions.checkState((boolean)this.isTrivial(), (Object)"The proof is non-trivial.");
        return this.trivialResult;
    }

    private ReachedSet getCurrentReachedSet() {
        Preconditions.checkState((!this.isTrivial() ? 1 : 0) != 0, (Object)"No reached set created, because the proof is trivial.");
        assert (this.reachedSet != null);
        return this.reachedSet;
    }

    LoopStructure.Loop getLoop() {
        Preconditions.checkState((!this.isTrivial() ? 1 : 0) != 0, (Object)"No loop computed, because the proof is trivial.");
        assert (this.loop != null);
        return this.loop;
    }

    private boolean isProverInitialized() {
        return this.prover != null;
    }

    private ProverEnvironment getProver() throws CPAException, InterruptedException {
        if (!this.isProverInitialized()) {
            this.prover = this.solver.newProverEnvironmentWithModelGeneration();
        }
        assert (this.isProverInitialized());
        return this.prover;
    }

    public UnmodifiableReachedSet getCurrentInvariantsReachedSet() {
        if (!this.invariantGenerationRunning) {
            return this.invariantsReachedSet;
        }
        try {
            return this.invariantGenerator.get();
        }
        catch (CPAException e) {
            this.logger.log(Level.FINE, new Object[]{"Invariant generation encountered an exception.", e});
            this.invariantGenerationRunning = false;
            return this.invariantsReachedSet;
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINE, new Object[]{"Invariant generation has terminated:", e});
            this.invariantGenerationRunning = false;
            return this.invariantsReachedSet;
        }
    }

    private BooleanFormula getCurrentLoopHeadInvariants() throws CPATransferException, InterruptedException {
        if (!this.bfmgr.isFalse(this.loopHeadInvariants) && this.invariantGenerationRunning) {
            CFANode loopHead = (CFANode)Iterables.getOnlyElement(this.getLoop().getLoopHeads());
            this.loopHeadInvariants = this.getCurrentLocationInvariants(loopHead, this.fmgr, this.pfmgr);
        }
        return this.loopHeadInvariants;
    }

    public BooleanFormula getCurrentLocationInvariants(CFANode pLocation, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        UnmodifiableReachedSet currentInvariantsReachedSet;
        if (this.invariantGenerationRunning && (currentInvariantsReachedSet = this.getCurrentInvariantsReachedSet()) != this.invariantsReachedSet) {
            return this.extractInvariantsAt(currentInvariantsReachedSet, pLocation, pFMGR, pPFMGR);
        }
        return this.extractInvariantsAt(this.invariantsReachedSet, pLocation, pFMGR, pPFMGR);
    }

    @Override
    public void close() {
        if (this.isProverInitialized()) {
            while (this.stackDepth-- > 0) {
                this.prover.pop();
            }
            this.prover.close();
        }
    }

    private void pop() {
        Preconditions.checkState((boolean)this.isProverInitialized());
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0);
        this.prover.pop();
        --this.stackDepth;
    }

    private void push(BooleanFormula pFormula) {
        Preconditions.checkState((boolean)this.isProverInitialized());
        this.prover.push(pFormula);
        ++this.stackDepth;
    }

    private BooleanFormula extractInvariantsAt(UnmodifiableReachedSet pReachedSet, CFANode pLocation, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) throws CPATransferException, InterruptedException {
        BooleanFormulaManagerView bfmgr = pFMGR.getBooleanFormulaManager();
        if (this.invariantGenerationRunning && pReachedSet.isEmpty()) {
            return bfmgr.makeBoolean(true);
        }
        BooleanFormula invariant = bfmgr.makeBoolean(false);
        for (AbstractState locState : AbstractStates.filterLocation(pReachedSet, pLocation)) {
            BooleanFormula f = AbstractStates.extractReportedFormulas(pFMGR, locState);
            this.logger.log(Level.ALL, new Object[]{"Invariant:", f});
            invariant = bfmgr.or(invariant, f);
        }
        for (EdgeFormulaNegation ci : FluentIterable.from(this.getConfirmedCandidates()).filter(EdgeFormulaNegation.class)) {
            if (!ci.getLocations(this.cfa).contains(pLocation)) continue;
            invariant = bfmgr.and(invariant, ci.getCandidate(pFMGR, pPFMGR));
        }
        return invariant;
    }

    public final boolean check() throws CPAException, InterruptedException {
        if (this.isTrivial()) {
            return this.getTrivialResult();
        }
        if (this.bfmgr.isFalse(this.getCurrentLoopHeadInvariants())) {
            return true;
        }
        this.stats.inductionPreparation.start();
        this.logger.log(Level.INFO, new Object[]{"Running algorithm to create induction hypothesis"});
        int k = (Integer)this.bmcKAccessor.get();
        LoopstackCPA stepCaseLoopstackCPA = CPAs.retrieveCPA(this.cpa, LoopstackCPA.class);
        ReachedSet reached = this.getCurrentReachedSet();
        this.ensureReachedSetInitialized(reached);
        HashMap<CandidateInvariant, BooleanFormula> assertions = new HashMap<CandidateInvariant, BooleanFormula>();
        ReachedSet predecessorReachedSet = null;
        ImmutableSet<CandidateInvariant> candidateInvariants = this.getCandidateInvariants();
        for (CandidateInvariant candidateInvariant : candidateInvariants) {
            BooleanFormula predecessorAssertion;
            BooleanFormula previousViolation = this.violationFormulas.get(candidateInvariant);
            if (previousViolation != null && this.previousK == k) {
                predecessorAssertion = this.bfmgr.not(previousViolation);
            } else {
                if (predecessorReachedSet == null) {
                    if (k < 1) {
                        predecessorReachedSet = this.reachedSetFactory.create();
                    } else {
                        predecessorReachedSet = reached;
                        stepCaseLoopstackCPA.setMaxLoopIterations(k);
                        BMCHelper.unroll(this.logger, predecessorReachedSet, this.reachedSetInitializer, this.algorithm, this.cpa);
                    }
                }
                predecessorAssertion = candidateInvariant.getAssertion(predecessorReachedSet, this.fmgr, this.pfmgr);
            }
            assertions.put(candidateInvariant, predecessorAssertion);
        }
        FluentIterable loopHeadStates = AbstractStates.filterLocations(reached, this.loop.getLoopHeads()).filter((Predicate)new Predicate<AbstractState>(){

            public boolean apply(AbstractState pArg0) {
                if (pArg0 == null) {
                    return false;
                }
                LoopstackState ls = AbstractStates.extractStateByType(pArg0, LoopstackState.class);
                return ls != null && ls.getIteration() <= 1;
            }
        });
        BooleanFormula loopHeadInv = this.bfmgr.and((List<BooleanFormula>)FluentIterable.from(BMCHelper.assertAt((Iterable<AbstractState>)loopHeadStates, this.getCurrentLoopHeadInvariants(), this.fmgr)).toList());
        stepCaseLoopstackCPA.setMaxLoopIterations(k + 1);
        BMCHelper.unroll(this.logger, reached, this.reachedSetInitializer, this.algorithm, this.cpa);
        this.previousK = k + 1;
        ProverEnvironment prover = this.getProver();
        int numberOfSuccessfulProofs = 0;
        this.stats.inductionPreparation.stop();
        for (CandidateInvariant candidateInvariant : candidateInvariants) {
            BooleanFormula predecessorAssertion = (BooleanFormula)assertions.get(candidateInvariant);
            BooleanFormula successorViolation = this.bfmgr.not(candidateInvariant.getAssertion(reached, this.fmgr, this.pfmgr));
            this.violationFormulas.put(candidateInvariant, successorViolation);
            this.logger.log(Level.INFO, new Object[]{"Starting induction check..."});
            this.stats.inductionCheck.start();
            this.push(loopHeadInv);
            this.push(predecessorAssertion);
            this.push(successorViolation);
            boolean isInvariant = prover.isUnsat();
            if (!isInvariant && this.logger.wouldBeLogged(Level.ALL)) {
                this.logger.log(Level.ALL, new Object[]{"Model returned for induction check:", prover.getModel()});
            }
            UnmodifiableReachedSet localInvariantsReachedSet = this.invariantsReachedSet;
            UnmodifiableReachedSet currentInvariantsReachedSet = this.getCurrentInvariantsReachedSet();
            while (!isInvariant && currentInvariantsReachedSet != localInvariantsReachedSet) {
                localInvariantsReachedSet = currentInvariantsReachedSet;
                BooleanFormula invariants = this.getCurrentLoopHeadInvariants();
                invariants = this.fmgr.instantiate(invariants, SSAMap.emptySSAMap().withDefault(1));
                this.push(invariants);
                isInvariant = prover.isUnsat();
                if (!isInvariant && this.logger.wouldBeLogged(Level.ALL)) {
                    this.logger.log(Level.ALL, new Object[]{"Model returned for induction check:", prover.getModel()});
                }
                this.pop();
                currentInvariantsReachedSet = this.getCurrentInvariantsReachedSet();
            }
            if (isInvariant) {
                ++numberOfSuccessfulProofs;
                this.confirmedCandidates.add(candidateInvariant);
                this.violationFormulas.remove(candidateInvariant);
                candidateInvariant.attemptInjection(this.invariantGenerator);
            }
            this.pop();
            this.pop();
            this.pop();
            this.stats.inductionCheck.stop();
            this.logger.log(Level.FINER, new Object[]{"Soundness after induction check:", isInvariant});
        }
        return numberOfSuccessfulProofs == candidateInvariants.size();
    }

    private void ensureReachedSetInitialized(ReachedSet pReachedSet) throws InterruptedException, CPAException {
        if (pReachedSet.size() > 1) {
            return;
        }
        CFANode loopHead = (CFANode)Iterables.getOnlyElement(this.getLoop().getLoopHeads());
        if (this.havocLoopTerminationConditionVariablesOnly) {
            FunctionEntryNode mainEntryNode = this.cfa.getMainFunction();
            Precision precision = this.cpa.getInitialPrecision(mainEntryNode, StateSpacePartition.getDefaultPartition());
            precision = this.excludeEdges(precision, (Iterable<CFAEdge>)CFAUtils.leavingEdges(loopHead));
            pReachedSet.add(this.cpa.getInitialState(mainEntryNode, StateSpacePartition.getDefaultPartition()), precision);
            this.algorithm.run(pReachedSet);
            ArrayList loopHeadStates = new ArrayList();
            Iterables.addAll(loopHeadStates, AbstractStates.filterLocation(pReachedSet, loopHead));
            pReachedSet.clear();
            Collection<String> loopTerminationConditionVariables = this.getTerminationConditionVariables(this.loop);
            for (AbstractState loopHeadState : loopHeadStates) {
                PredicateAbstractState pas = AbstractStates.extractStateByType(loopHeadState, PredicateAbstractState.class);
                PathFormula pathFormula = pas.getPathFormula();
                SSAMap.SSAMapBuilder ssaMapBuilder = pathFormula.getSsa().builder();
                SortedSet<String> containedVariables = ssaMapBuilder.allVariables();
                for (String variable : loopTerminationConditionVariables) {
                    if (!containedVariables.contains(variable)) continue;
                    CType type = ssaMapBuilder.getType(variable);
                    int freshIndex = ssaMapBuilder.getFreshIndex(variable);
                    ssaMapBuilder.setIndex(variable, type, freshIndex);
                }
                AbstractState newLoopHeadState = this.cpa.getInitialState(loopHead, StateSpacePartition.getDefaultPartition());
                PredicateAbstractState newPAS = AbstractStates.extractStateByType(newLoopHeadState, PredicateAbstractState.class);
                newPAS.setPathFormula(this.pfmgr.makeNewPathFormula(pathFormula, ssaMapBuilder.build()));
                pReachedSet.add(newLoopHeadState, this.cpa.getInitialPrecision(loopHead, StateSpacePartition.getDefaultPartition()));
            }
        } else {
            Precision precision = this.cpa.getInitialPrecision(loopHead, StateSpacePartition.getDefaultPartition());
            pReachedSet.add(this.cpa.getInitialState(loopHead, StateSpacePartition.getDefaultPartition()), precision);
        }
    }

    private Collection<String> getTerminationConditionVariables(LoopStructure.Loop pLoop) throws CPATransferException, InterruptedException {
        HashSet<String> result = new HashSet<String>();
        result.add("___pc");
        CFANode loopHead = (CFANode)Iterables.getOnlyElement(pLoop.getLoopHeads());
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(loopHead);
        visited.add(loopHead);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            assert (pLoop.getLoopNodes().contains((Object)current));
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(current)) {
                CFANode successor = leavingEdge.getSuccessor();
                if (!KInductionProver.isLoopExitEdge(leavingEdge, pLoop)) {
                    if (!visited.add(successor)) continue;
                    waitlist.offer(successor);
                    continue;
                }
                PathFormula formula = this.pfmgr.makeFormulaForPath(Collections.singletonList(leavingEdge));
                result.addAll(this.fmgr.extractVariableNames(this.fmgr.uninstantiate(formula.getFormula())));
            }
        }
        return result;
    }

    private static boolean isLoopExitEdge(CFAEdge pEdge, LoopStructure.Loop pLoop) {
        return !pLoop.getLoopNodes().contains((Object)pEdge.getSuccessor());
    }

    private Precision excludeEdges(Precision pPrecision, Iterable<CFAEdge> pEdgesToIgnore) {
        EdgeExclusionPrecision oldPrecision = Precisions.extractPrecisionByType(pPrecision, EdgeExclusionPrecision.class);
        if (oldPrecision != null) {
            EdgeExclusionPrecision newPrecision = oldPrecision.excludeMoreEdges(pEdgesToIgnore);
            return Precisions.replaceByType(pPrecision, newPrecision, (Predicate<? super Precision>)Predicates.instanceOf(EdgeExclusionPrecision.class));
        }
        return pPrecision;
    }
}

