/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.bmc;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCHelper;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public enum TargetLocationCandidateInvariant implements CandidateInvariant
{
    INSTANCE;


    @Override
    public BooleanFormula getAssertion(ReachedSet pReachedSet, FormulaManagerView pFMGR, PathFormulaManager pPFMGR) {
        FluentIterable targetStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates.IS_TARGET_STATE);
        return pFMGR.getBooleanFormulaManager().not(BMCHelper.createFormulaFor((Iterable<AbstractState>)targetStates, pFMGR.getBooleanFormulaManager()));
    }

    @Override
    public boolean violationIndicatesError() {
        return true;
    }

    @Override
    public void assumeTruth(ReachedSet pReachedSet) {
        ImmutableList targetStates = FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates.IS_TARGET_STATE).toList();
        pReachedSet.removeAll((Iterable<? extends AbstractState>)targetStates);
        for (ARGState s : FluentIterable.from((Iterable)targetStates).filter(ARGState.class)) {
            s.removeFromARG();
        }
    }

    @Override
    public Set<CFANode> getLocations(CFA pCFA) {
        Optional<ImmutableSet<CFANode>> loopHeads = pCFA.getAllLoopHeads();
        if (loopHeads.isPresent()) {
            return (Set)loopHeads.get();
        }
        return Collections.emptySet();
    }

    @Override
    public void attemptInjection(InvariantGenerator pInvariantGenerator) {
    }
}

