/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.cbmctools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.exceptions.CounterexampleAnalysisFailed;
import org.sosy_lab.cpachecker.util.NativeLibraries;

public class CBMCExecutor
extends ProcessExecutor<CounterexampleAnalysisFailed> {
    private static final int MAX_CBMC_ERROR_OUTPUT_SHOWN = 10;
    private static final Map<String, String> CBMC_ENV_VARS = ImmutableMap.of((Object)"LANG", (Object)"C");
    private volatile Boolean result = null;
    private boolean unwindingAssertionFailed = false;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Written only by one thread")
    private volatile int errorOutputCount = 0;

    public CBMCExecutor(LogManager logger, List<String> args) throws IOException {
        super(logger, CounterexampleAnalysisFailed.class, CBMC_ENV_VARS, CBMCExecutor.getCommandLine(args));
    }

    private static String[] getCommandLine(List<String> args) {
        String[] cmd = new String[args.size() + 1];
        cmd[0] = NativeLibraries.getNativeLibraryPath().resolve("cbmc").toString();
        for (int i = 0; i < args.size(); ++i) {
            cmd[i + 1] = args.get(i);
        }
        return cmd;
    }

    protected synchronized void handleExitCode(int pCode) throws CounterexampleAnalysisFailed {
        switch (pCode) {
            case 0: {
                this.result = false;
                break;
            }
            case 10: {
                this.result = true;
                break;
            }
            default: {
                super.handleExitCode(pCode);
            }
        }
    }

    protected synchronized void handleErrorOutput(String pLine) throws CounterexampleAnalysisFailed {
        if (pLine.contains("Out of memory") || pLine.equals("terminate called after throwing an instance of 'Minisat::OutOfMemoryException'")) {
            throw new CounterexampleAnalysisFailed("CBMC run out of memory.");
        }
        if (!pLine.startsWith("**** WARNING: no body for function ") && !pLine.contains("warning: #pragma once in main file")) {
            if (this.errorOutputCount == 10) {
                this.logger.log(Level.WARNING, new Object[]{"Skipping further CBMC error output..."});
                ++this.errorOutputCount;
            } else if (this.errorOutputCount < 10) {
                ++this.errorOutputCount;
                super.handleErrorOutput(pLine);
            }
        }
    }

    protected synchronized void handleOutput(String pLine) throws CounterexampleAnalysisFailed {
        if (pLine.contains("unwinding assertion")) {
            this.unwindingAssertionFailed = true;
        }
        super.handleOutput(pLine);
    }

    public boolean didUnwindingAssertionFail() {
        return this.unwindingAssertionFailed;
    }

    boolean producedErrorOutput() {
        Preconditions.checkState((boolean)this.isFinished());
        return this.errorOutputCount > 0;
    }

    public synchronized Boolean getResult() {
        Preconditions.checkState((boolean)this.isFinished());
        if (this.errorOutputCount > 0) {
            this.logger.log(Level.WARNING, new Object[]{"CBMC returned successfully, but printed warnings, ignoring the result. Please check the log above!"});
            this.errorOutputCount = 0;
            this.result = null;
        }
        return this.result;
    }
}

