/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.impact;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
class Vertex
extends AbstractSingleWrapperState {
    private static final long serialVersionUID = -559038737L;
    private static int nextId = 0;
    private final int id = nextId++;
    private final Vertex parent;
    private final BooleanFormulaManager bfmgr;
    private final List<Vertex> children = new ArrayList<Vertex>(2);
    private BooleanFormula stateFormula;
    private Vertex coveredBy = null;
    private List<Vertex> coveredNodes = new ArrayList<Vertex>(0);

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    public Vertex(BooleanFormulaManager bfmgr, BooleanFormula pStateFormula, AbstractState pElement) {
        super(pElement);
        this.bfmgr = bfmgr;
        this.parent = null;
        assert (bfmgr.isTrue(pStateFormula));
        this.stateFormula = pStateFormula;
    }

    public Vertex(BooleanFormulaManager bfmgr, Vertex pParent, BooleanFormula pStateFormula, @Nullable AbstractState pElement) {
        super(pElement);
        this.bfmgr = bfmgr;
        this.parent = (Vertex)Preconditions.checkNotNull((Object)pParent);
        this.parent.children.add(this);
        this.stateFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pStateFormula);
    }

    public BooleanFormula getStateFormula() {
        return this.stateFormula;
    }

    public CFAEdge getIncomingEdge() {
        CFANode thisLocation = AbstractStates.extractLocation(this.getWrappedState());
        CFANode parentLocation = AbstractStates.extractLocation(this.parent.getWrappedState());
        return parentLocation.getEdgeTo(thisLocation);
    }

    public void setCoveredBy(Vertex pCoveredBy) {
        assert (!this.isCovered()) : "Cannot re-cover the covered node " + this;
        assert (!pCoveredBy.isCovered()) : "Covered node " + pCoveredBy + " cannot cover";
        this.coveredBy = (Vertex)Preconditions.checkNotNull((Object)pCoveredBy);
        pCoveredBy.coveredNodes.add(this);
    }

    public List<Vertex> cleanCoverage() {
        assert (!this.isCovered() || this.coveredNodes.isEmpty());
        if (this.coveredNodes.isEmpty()) {
            return Collections.emptyList();
        }
        List<Vertex> result = this.coveredNodes;
        this.coveredNodes = new ArrayList<Vertex>(0);
        for (Vertex v : result) {
            assert (v.coveredBy == this);
            v.coveredBy = null;
        }
        return result;
    }

    public void setStateFormula(BooleanFormula pStateFormula) {
        this.stateFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pStateFormula);
    }

    public Vertex getParent() {
        Preconditions.checkState((boolean)this.hasParent());
        return this.parent;
    }

    public List<Vertex> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Vertex> getSubtree() {
        ArrayList<Vertex> subtreeNodes = new ArrayList<Vertex>();
        subtreeNodes.add(this);
        this.getSubtree(subtreeNodes);
        return subtreeNodes;
    }

    private void getSubtree(List<Vertex> subtreeNodes) {
        subtreeNodes.addAll(this.children);
        for (Vertex v : this.children) {
            v.getSubtree(subtreeNodes);
        }
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isCovered() {
        if (this.coveredBy != null) {
            return true;
        }
        Vertex v = this;
        while (v.hasParent()) {
            v = v.getParent();
            if (v.coveredBy == null) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.children.isEmpty() && AbstractStates.extractLocation(this.getWrappedState()).getNumLeavingEdges() > 0;
    }

    @Override
    public boolean isTarget() {
        return !this.bfmgr.isFalse(this.stateFormula) && super.isTarget();
    }

    public boolean isAncestorOf(Vertex v) {
        if (this == v) {
            return true;
        }
        while (v.hasParent()) {
            if (this != (v = v.getParent())) continue;
            return true;
        }
        return false;
    }

    public boolean isOlderThan(Vertex v) {
        return this.id < v.id;
    }

    @Override
    public String toString() {
        return "Id: " + this.id + " " + this.stateFormula.toString() + "\n" + super.toString();
    }
}

