/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LazyFutureTask;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.UpdateListener;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.conditions.AdjustableConditionCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetWrapper;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;

@Options(prefix="invariantGeneration")
public class CPAInvariantGenerator
implements InvariantGenerator {
    @Option(secure=true, name="config", required=true, description="configuration file for invariant generation")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path configFile;
    @Option(secure=true, description="generate invariants in parallel to the normal analysis")
    private boolean async = false;
    @Option(secure=true, description="adjust invariant generation conditions if supported by the analysis")
    private boolean adjustConditions = false;
    private final Timer invariantGeneration = new Timer();
    private final LogManager logger;
    private final Algorithm invariantAlgorithm;
    private final ConfigurableProgramAnalysis invariantCPAs;
    private final ReachedSetFactory reachedSetFactory;
    private final ReachedSet reached;
    private final ShutdownNotifier shutdownNotifier;
    private Future<UnmodifiableReachedSet> invariantGenerationFuture = null;
    private volatile boolean cancelled = false;
    private final List<UpdateListener> updateListeners = new CopyOnWriteArrayList<UpdateListener>();
    private final ShutdownNotifier.ShutdownRequestListener shutdownListener = new ShutdownNotifier.ShutdownRequestListener(){

        @Override
        public void shutdownRequested(String pReason) {
            CPAInvariantGenerator.this.cancelled = true;
            CPAInvariantGenerator.this.invariantGenerationFuture.cancel(true);
        }
    };

    public ConfigurableProgramAnalysis getCPAs() {
        return this.invariantCPAs;
    }

    public CPAInvariantGenerator(Configuration config, LogManager pLogger, ReachedSetFactory reachedSetFactory, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException, CPAException {
        Configuration invariantConfig;
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = ShutdownNotifier.createWithParent(pShutdownNotifier);
        try {
            ConfigurationBuilder configBuilder = CPAInvariantGenerator.extractOptionFrom(config, "specification");
            configBuilder.loadFromFile(this.configFile);
            invariantConfig = configBuilder.build();
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("could not read configuration file for invariant generation: " + e.getMessage(), (Throwable)e);
        }
        this.invariantCPAs = new CPABuilder(invariantConfig, this.logger, this.shutdownNotifier, reachedSetFactory).buildCPAWithSpecAutomatas(cfa);
        this.invariantAlgorithm = CPAAlgorithm.create(this.invariantCPAs, this.logger, invariantConfig, this.shutdownNotifier);
        this.reachedSetFactory = new ReachedSetFactory(invariantConfig, this.logger);
        this.reached = reachedSetFactory.create();
    }

    @Override
    public void start(final CFANode initialLocation) {
        Preconditions.checkNotNull((Object)initialLocation);
        Preconditions.checkState((this.invariantGenerationFuture == null ? 1 : 0) != 0);
        Preconditions.checkState((!this.reached.hasWaitingState() ? 1 : 0) != 0);
        if (this.async) {
            this.invariantGenerationFuture = new AdjustingInvariantGenerationFuture(this.reachedSetFactory, initialLocation);
        } else {
            Callable<UnmodifiableReachedSet> task = new Callable<UnmodifiableReachedSet>(){

                @Override
                public UnmodifiableReachedSet call() throws Exception {
                    CPAInvariantGenerator.this.shutdownNotifier.shutdownIfNecessary();
                    UnmodifiableReachedSet result = new InvariantGenerationTask(CPAInvariantGenerator.this.reachedSetFactory, initialLocation).call();
                    CPAs.closeCpaIfPossible(CPAInvariantGenerator.this.invariantCPAs, CPAInvariantGenerator.this.logger);
                    CPAs.closeIfPossible(CPAInvariantGenerator.this.invariantAlgorithm, CPAInvariantGenerator.this.logger);
                    return result;
                }
            };
            this.invariantGenerationFuture = new LazyFutureTask((Callable)task);
        }
        this.shutdownNotifier.registerAndCheckImmediately(this.shutdownListener);
    }

    @Override
    public void cancel() {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        this.cancelled = true;
        this.shutdownNotifier.requestShutdown("Invariant generation cancel requested.");
    }

    @Override
    public UnmodifiableReachedSet get() throws CPAException, InterruptedException {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        this.shutdownNotifier.shutdownIfNecessary();
        if (this.cancelled) {
            throw new InterruptedException("Invariant generation was interrupted.");
        }
        try {
            return this.invariantGenerationFuture.get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("invariant generation", e.getCause());
        }
    }

    @Override
    public Timer getTimeOfExecution() {
        return this.invariantGeneration;
    }

    @Override
    public void addUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.add(pUpdateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.remove(pUpdateListener);
    }

    private void notifyUpdateListeners() {
        for (UpdateListener updateListener : this.updateListeners) {
            updateListener.updated();
        }
    }

    private static ConfigurationBuilder extractOptionFrom(Configuration pConfiguration, String pKey) {
        ConfigurationBuilder builder = Configuration.builder().copyFrom(pConfiguration);
        try (Scanner pairScanner = new Scanner(pConfiguration.asPropertiesString());){
            pairScanner.useDelimiter("\\s+");
            while (pairScanner.hasNext()) {
                String pair = pairScanner.next();
                Scanner keyScanner = new Scanner(pair);
                Throwable throwable = null;
                try {
                    String key;
                    keyScanner.useDelimiter("\\s*=\\s*.*");
                    if (!keyScanner.hasNext() || (key = keyScanner.next()).equals(pKey)) continue;
                    builder.clearOption(key);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (keyScanner == null) continue;
                    if (throwable != null) {
                        try {
                            keyScanner.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    keyScanner.close();
                }
            }
        }
        return builder;
    }

    private class AdjustingInvariantGenerationFuture
    implements Future<UnmodifiableReachedSet> {
        private final List<AdjustableConditionCPA> conditionCPAs;
        private final AtomicReference<Future<UnmodifiableReachedSet>> currentFuture = new AtomicReference();
        private final ExecutorService executorService = Executors.newSingleThreadExecutor(Threads.threadFactory());
        private boolean done = false;
        private boolean cancelledInner = false;

        public AdjustingInvariantGenerationFuture(final ReachedSetFactory pReachedSetFactory, CFANode pInitialLocation) {
            this.conditionCPAs = CPAs.asIterable(CPAInvariantGenerator.this.invariantCPAs).filter(AdjustableConditionCPA.class).toList();
            Callable<UnmodifiableReachedSet> initialTask = new Callable<UnmodifiableReachedSet>(){

                @Override
                public UnmodifiableReachedSet call() {
                    return pReachedSetFactory.create();
                }
            };
            this.currentFuture.set(this.executorService.submit(initialTask));
            if (!CPAInvariantGenerator.this.shutdownNotifier.shouldShutdown()) {
                this.scheduleTask(pReachedSetFactory, pInitialLocation);
            }
        }

        @Override
        public boolean cancel(boolean pMayInterruptIfRunning) {
            this.cancelledInner = true;
            boolean wasDone = this.done;
            this.setDone();
            Future<UnmodifiableReachedSet> currentFuture = this.currentFuture.get();
            if (currentFuture != null) {
                return currentFuture.cancel(pMayInterruptIfRunning);
            }
            return !wasDone;
        }

        @Override
        public UnmodifiableReachedSet get() throws InterruptedException, ExecutionException {
            return this.currentFuture.get().get();
        }

        @Override
        public UnmodifiableReachedSet get(long pTimeout, TimeUnit pUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.currentFuture.get().get(pTimeout, pUnit);
        }

        @Override
        public boolean isCancelled() {
            return this.cancelledInner;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        private Future<UnmodifiableReachedSet> scheduleTask(final ReachedSetFactory pReachedSetFactory, final CFANode pInitialLocation) {
            final AtomicReference<Object> ref = new AtomicReference<Object>();
            LazyFutureTask future = new LazyFutureTask((Callable)new InvariantGenerationTask(pReachedSetFactory, pInitialLocation){

                @Override
                public UnmodifiableReachedSet call() throws CPAException, InterruptedException {
                    UnmodifiableReachedSet result = super.call();
                    AdjustingInvariantGenerationFuture.this.currentFuture.set(ref.get());
                    CPAInvariantGenerator.this.notifyUpdateListeners();
                    if (AdjustingInvariantGenerationFuture.this.adjustConditions() && !CPAInvariantGenerator.this.shutdownNotifier.shouldShutdown()) {
                        AdjustingInvariantGenerationFuture.this.scheduleTask(pReachedSetFactory, pInitialLocation);
                    } else {
                        AdjustingInvariantGenerationFuture.this.setDone();
                        AdjustingInvariantGenerationFuture.this.cancelledInner = (byte)(AdjustingInvariantGenerationFuture.this.cancelledInner | (((Future)ref.get()).isCancelled() ? 1 : 0));
                    }
                    return result;
                }
            });
            ref.set(future);
            if (!CPAInvariantGenerator.this.shutdownNotifier.shouldShutdown() && !this.executorService.isShutdown()) {
                ref.set(this.executorService.submit(new Callable<UnmodifiableReachedSet>((Future)future){
                    final /* synthetic */ Future val$future;
                    {
                        this.val$future = future;
                    }

                    @Override
                    public UnmodifiableReachedSet call() throws ExecutionException, InterruptedException {
                        return (UnmodifiableReachedSet)this.val$future.get();
                    }
                }));
            }
            return future;
        }

        private void setDone() {
            if (!this.done) {
                this.done = true;
                CPAs.closeCpaIfPossible(CPAInvariantGenerator.this.invariantCPAs, CPAInvariantGenerator.this.logger);
                CPAs.closeIfPossible(CPAInvariantGenerator.this.invariantAlgorithm, CPAInvariantGenerator.this.logger);
                this.executorService.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean adjustConditions() {
            if (!CPAInvariantGenerator.this.adjustConditions) {
                return false;
            }
            if (this.conditionCPAs.isEmpty()) {
                CPAInvariantGenerator.this.logger.log(Level.INFO, new Object[]{"Cannot adjust invariant generation: No adjustable CPAs."});
                return false;
            }
            ConfigurableProgramAnalysis configurableProgramAnalysis = CPAInvariantGenerator.this.invariantCPAs;
            synchronized (configurableProgramAnalysis) {
                for (AdjustableConditionCPA cpa : this.conditionCPAs) {
                    if (cpa.adjustPrecision()) continue;
                    CPAInvariantGenerator.this.logger.log(Level.INFO, new Object[]{"Further invariant generation adjustments denied by", cpa.getClass().getSimpleName()});
                    return false;
                }
            }
            return true;
        }
    }

    private class InvariantGenerationTask
    implements Callable<UnmodifiableReachedSet> {
        private ReachedSet taskReached;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InvariantGenerationTask(ReachedSetFactory pReachedSetFactory, CFANode pInitialLocation) {
            this.taskReached = pReachedSetFactory.create();
            ConfigurableProgramAnalysis configurableProgramAnalysis = CPAInvariantGenerator.this.invariantCPAs;
            synchronized (configurableProgramAnalysis) {
                this.taskReached.add(CPAInvariantGenerator.this.invariantCPAs.getInitialState(pInitialLocation, StateSpacePartition.getDefaultPartition()), CPAInvariantGenerator.this.invariantCPAs.getInitialPrecision(pInitialLocation, StateSpacePartition.getDefaultPartition()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UnmodifiableReachedSet call() throws CPAException, InterruptedException {
            Preconditions.checkState((boolean)this.taskReached.hasWaitingState());
            CPAInvariantGenerator.this.invariantGeneration.start();
            CPAInvariantGenerator.this.logger.log(Level.INFO, new Object[]{"Finding invariants"});
            try {
                while (!this.taskReached.getWaitlist().isEmpty()) {
                    CPAInvariantGenerator.this.invariantAlgorithm.run(this.taskReached);
                }
                UnmodifiableReachedSetWrapper unmodifiableReachedSetWrapper = new UnmodifiableReachedSetWrapper(this.taskReached);
                return unmodifiableReachedSetWrapper;
            }
            finally {
                CPAInvariantGenerator.this.invariantGeneration.stop();
            }
        }
    }
}

