/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.common.LazyFutureTask;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.concurrency.Threads;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.UpdateListener;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class KInductionInvariantGenerator
implements InvariantGenerator {
    private final BMCAlgorithm bmcAlgorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final ReachedSetFactory reachedSetFactory;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private boolean async = true;
    private Future<UnmodifiableReachedSet> invariantGenerationFuture = null;
    private final Timer invariantGeneration = new Timer();
    private final List<UpdateListener> updateListeners = new CopyOnWriteArrayList<UpdateListener>();
    private final CFA cfa;
    private final PathFormulaManager clientPFM;
    private ReachedSet currentResults;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(Threads.threadFactory());
    private final ShutdownNotifier.ShutdownRequestListener shutdownListener;
    private final AtomicBoolean areNewInvariantsAvailable = new AtomicBoolean(true);

    public KInductionInvariantGenerator(BMCAlgorithm pBMCAlgorithm, ReachedSetFactory pReachedSetFactory, ConfigurableProgramAnalysis pCPA, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA, PathFormulaManager pClientPFM, boolean pAsync) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pBMCAlgorithm);
        PredicateCPA predicateCPA = CPAs.retrieveCPA(pCPA, PredicateCPA.class);
        if (predicateCPA == null) {
            throw new InvalidConfigurationException("Predicate CPA required");
        }
        if (this.async && !predicateCPA.getSolver().getFormulaManager().getVersion().toLowerCase().contains("smtinterpol")) {
            throw new InvalidConfigurationException("Solver does not support concurrent execution, use SMTInterpol instead.");
        }
        this.bmcAlgorithm = pBMCAlgorithm;
        this.cpa = pCPA;
        this.reachedSetFactory = pReachedSetFactory;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCFA;
        this.clientPFM = pClientPFM;
        this.currentResults = this.reachedSetFactory.create();
        this.shutdownListener = new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String pReason) {
                KInductionInvariantGenerator.this.executorService.shutdownNow();
            }
        };
        this.bmcAlgorithm.addUpdateListener(new UpdateListener(){

            @Override
            public void updated() {
                KInductionInvariantGenerator.this.areNewInvariantsAvailable.set(true);
            }
        });
    }

    @Override
    public void start(final CFANode pInitialLocation) {
        Preconditions.checkNotNull((Object)pInitialLocation);
        Preconditions.checkState((this.invariantGenerationFuture == null ? 1 : 0) != 0);
        Callable<UnmodifiableReachedSet> task = new Callable<UnmodifiableReachedSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UnmodifiableReachedSet call() throws InterruptedException, CPAException {
                KInductionInvariantGenerator.this.invariantGeneration.start();
                KInductionInvariantGenerator.this.shutdownNotifier.shutdownIfNecessary();
                try {
                    ReachedSet reachedSet = KInductionInvariantGenerator.this.reachedSetFactory.create();
                    AbstractState initialState = KInductionInvariantGenerator.this.cpa.getInitialState(pInitialLocation, StateSpacePartition.getDefaultPartition());
                    Precision initialPrecision = KInductionInvariantGenerator.this.cpa.getInitialPrecision(pInitialLocation, StateSpacePartition.getDefaultPartition());
                    reachedSet.add(initialState, initialPrecision);
                    KInductionInvariantGenerator.this.bmcAlgorithm.run(reachedSet);
                    UnmodifiableReachedSet unmodifiableReachedSet = KInductionInvariantGenerator.this.getResults();
                    return unmodifiableReachedSet;
                }
                finally {
                    CPAs.closeCpaIfPossible(KInductionInvariantGenerator.this.cpa, KInductionInvariantGenerator.this.logger);
                    CPAs.closeIfPossible(KInductionInvariantGenerator.this.bmcAlgorithm, KInductionInvariantGenerator.this.logger);
                    KInductionInvariantGenerator.this.invariantGeneration.stop();
                }
            }
        };
        if (this.async) {
            this.shutdownNotifier.registerAndCheckImmediately(this.shutdownListener);
            this.invariantGenerationFuture = this.executorService.submit(task);
        } else {
            this.invariantGenerationFuture = new LazyFutureTask((Callable)task);
        }
    }

    private UnmodifiableReachedSet getResults() throws CPATransferException, InterruptedException {
        if (this.areNewInvariantsAvailable.getAndSet(false)) {
            ReachedSet currentResults = this.reachedSetFactory.create();
            currentResults.addAll((Iterable<Pair<AbstractState, Precision>>)FluentIterable.from(this.cfa.getAllNodes()).transform((Function)new Function<CFANode, Pair<AbstractState, Precision>>(){

                public Pair<AbstractState, Precision> apply(CFANode pArg0) {
                    return Pair.of((Object)new ResultState(pArg0), (Object)SingletonPrecision.getInstance());
                }
            }));
            this.currentResults = currentResults;
        }
        return this.currentResults;
    }

    @Override
    public void cancel() {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        this.shutdownNotifier.requestShutdown("Invariant generation cancel requested.");
    }

    @Override
    public UnmodifiableReachedSet get() throws CPAException, InterruptedException {
        if (this.async) {
            return this.getResults();
        }
        try {
            return this.invariantGenerationFuture.get();
        }
        catch (ExecutionException e) {
            return this.reachedSetFactory.create();
        }
    }

    @Override
    public Timer getTimeOfExecution() {
        return this.invariantGeneration;
    }

    @Override
    public void addUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.add(pUpdateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener pUpdateListener) {
        Preconditions.checkNotNull((Object)pUpdateListener);
        this.updateListeners.remove(pUpdateListener);
    }

    private class ResultState
    implements FormulaReportingState,
    AbstractStateWithLocation,
    Partitionable {
        private final CFANode location;

        public ResultState(CFANode pLocation) {
            this.location = pLocation;
        }

        @Override
        public Iterable<CFAEdge> getOutgoingEdges() {
            return CFAUtils.leavingEdges(this.getLocationNode());
        }

        @Override
        public CFANode getLocationNode() {
            return this.location;
        }

        @Override
        public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
            return KInductionInvariantGenerator.this.bmcAlgorithm.getCurrentLocationInvariants(this.location, pManager, KInductionInvariantGenerator.this.clientPFM);
        }

        @Override
        public Object getPartitionKey() {
            return this.getLocationNode();
        }
    }
}

