/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;

public class AlgorithmWithPropertyCheck
implements Algorithm,
StatisticsProvider {
    private final Algorithm analysis;
    private final LogManager logger;
    private PropertyCheckerCPA cpa;

    public AlgorithmWithPropertyCheck(Algorithm analysisAlgorithm, LogManager logger, PropertyCheckerCPA cpa) {
        this.analysis = analysisAlgorithm;
        this.logger = logger;
        this.cpa = cpa;
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        boolean result = false;
        this.logger.log(Level.INFO, new Object[]{"Start analysis."});
        result = this.analysis.run(pReachedSet);
        if (result) {
            this.logger.log(Level.INFO, new Object[]{"Start property checking."});
            result = this.cpa.getPropChecker().satisfiesProperty(pReachedSet.asCollection());
            if (!result) {
                pReachedSet.add(new DummyErrorState(pReachedSet.getLastState()), SingletonPrecision.getInstance());
            }
        }
        this.logger.log(Level.INFO, new Object[]{"Finished analysis"});
        return result;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.analysis instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.analysis)).collectStatistics(pStatsCollection);
        }
    }
}

