/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.PCCStrategyBuilder;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;

@Options
public class ProofCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CPAStatistics stats = new CPAStatistics();
    private final LogManager logger;
    @Option(secure=true, name="pcc.strategy", description="Qualified name for class which implements proof checking strategy to be used.")
    private String pccStrategy = "org.sosy_lab.cpachecker.pcc.strategy.ARGProofCheckerStrategy";
    private PCCStrategy checkingStrategy;

    public ProofCheckAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(this.pccStrategy, pConfig, logger, pShutdownNotifier, cpa);
        this.logger = logger;
        logger.log(Level.INFO, new Object[]{"Start reading proof."});
        try {
            this.stats.totalTimer.start();
            this.stats.readTimer.start();
            this.checkingStrategy.readProof();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed reading proof.", e);
        }
        finally {
            this.stats.readTimer.stop();
            this.stats.totalTimer.stop();
        }
        logger.log(Level.INFO, new Object[]{"Finished reading proof."});
    }

    protected ProofCheckAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, LogManager logger, ShutdownNotifier pShutdownNotifier, ReachedSet pReachedSet) throws InvalidConfigurationException, InterruptedException {
        pConfig.inject((Object)this);
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(this.pccStrategy, pConfig, logger, pShutdownNotifier, cpa);
        this.logger = logger;
        if (pReachedSet == null || pReachedSet.hasWaitingState()) {
            throw new IllegalArgumentException("Parameter pReachedSet may not be null and may not have any states in its waitlist.");
        }
        this.stats.totalTimer.start();
        this.checkingStrategy.constructInternalProofRepresentation(pReachedSet);
        this.stats.totalTimer.stop();
    }

    @Override
    public boolean run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm started."});
        this.stats.totalTimer.start();
        boolean result = false;
        result = this.checkingStrategy.checkCertificate(reachedSet);
        this.stats.totalTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm finished."});
        if (!result) {
            reachedSet.add(new DummyErrorState(reachedSet.getFirstState()), SingletonPrecision.getInstance());
        }
        return result;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        if (this.checkingStrategy instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.checkingStrategy)).collectStatistics(pStatsCollection);
        }
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer readTimer = new Timer();

        private CPAStatistics() {
        }

        @Override
        public String getName() {
            return "Proof Check algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            out.println();
            out.println("Total time for proof check algorithm:     " + this.totalTimer);
            out.println("  Time for reading in proof (not complete time in interleaved modes):  " + this.readTimer);
        }
    }
}

