/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.pcc.strategy.PCCStrategyBuilder;

@Options
public class ProofGenerator {
    @Option(secure=true, name="pcc.strategy", description="Qualified name for class which implements certification strategy, hence proof writing, to be used.")
    private String pccStrategy = "org.sosy_lab.cpachecker.pcc.strategy.ARGProofCheckerStrategy";
    private PCCStrategy checkingStrategy;
    private final LogManager logger;
    private final Timer writingTimer = new Timer();
    private final Statistics proofGeneratorStats = new Statistics(){

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            pOut.println();
            pOut.println(this.getName() + " statistics");
            pOut.println("------------------------------------");
            pOut.println("Time for proof writing: " + ProofGenerator.this.writingTimer);
        }

        @Override
        public String getName() {
            return "Proof Generation";
        }
    };

    public ProofGenerator(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(this.pccStrategy, pConfig, pLogger, pShutdownNotifier, null);
    }

    public void generateProof(CPAcheckerResult pResult) {
        UnmodifiableReachedSet reached = pResult.getReached();
        if (pResult.getResult() != CPAcheckerResult.Result.TRUE) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
            return;
        }
        this.logger.log(Level.INFO, new Object[]{"Proof Generation started."});
        this.writingTimer.start();
        this.checkingStrategy.writeProof(reached);
        this.writingTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Writing proof took " + this.writingTimer.getMaxTime().formatAs(TimeUnit.SECONDS)});
        pResult.addProofGeneratorStatistics(this.proofGeneratorStats);
    }
}

