/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ResultCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    private LogManager logger;
    private Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private Algorithm analysisAlgorithm;
    private ConfigurableProgramAnalysis cpa;
    private CFA analyzedProgram;
    private ResultCheckStatistics stats;

    public ResultCheckAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.analysisAlgorithm = pAlgorithm;
        this.analyzedProgram = pCfa;
        this.cpa = pCpa;
        this.logger = pLogger;
        this.config = pConfig;
        this.shutdownNotifier = pShutdownNotifier;
        this.stats = new ResultCheckStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        block11: {
            block9: {
                boolean result = false;
                this.logger.log(Level.INFO, new Object[]{"Start analysis."});
                try {
                    this.stats.analysisTimer.start();
                    result = this.analysisAlgorithm.run(pReachedSet);
                }
                catch (Throwable throwable) {
                    this.stats.analysisTimer.stop();
                    this.logger.log(Level.INFO, new Object[]{"Analysis stopped."});
                    throw throwable;
                }
                this.stats.analysisTimer.stop();
                this.logger.log(Level.INFO, new Object[]{"Analysis stopped."});
                if (!result || pReachedSet.getWaitlist().size() != 0) break block9;
                this.logger.log(Level.INFO, new Object[]{"Analysis successful.", "Start checking analysis result"});
                try {
                    this.stats.checkTimer.start();
                    ProofCheckAlgorithm checker = new ProofCheckAlgorithm(this.cpa, this.config, this.logger, this.shutdownNotifier, pReachedSet);
                    CoreComponentsFactory factory = new CoreComponentsFactory(this.config, this.logger, this.shutdownNotifier);
                    ReachedSet reached = factory.createReachedSet();
                    reached.add(this.cpa.getInitialState(this.analyzedProgram.getMainFunction(), StateSpacePartition.getDefaultPartition()), this.cpa.getInitialPrecision(this.analyzedProgram.getMainFunction(), StateSpacePartition.getDefaultPartition()));
                    result = checker.run(reached);
                }
                catch (InvalidConfigurationException e) {
                    result = false;
                    this.stats.checkTimer.stop();
                    this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                }
                catch (InterruptedException e1) {
                    this.logger.log(Level.INFO, new Object[]{"Timed out. Checking incomplete."});
                    boolean bl = false;
                    {
                        catch (Throwable throwable) {
                            this.stats.checkTimer.stop();
                            this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                            throw throwable;
                        }
                    }
                    this.stats.checkTimer.stop();
                    this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                    return bl;
                }
                this.stats.checkTimer.stop();
                this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                if (result) {
                    this.logger.log(Level.INFO, new Object[]{"Analysis result checked successfully."});
                    return true;
                }
                this.logger.log(Level.INFO, new Object[]{"Analysis result could not be checked."});
                break block11;
            }
            this.logger.log(Level.WARNING, new Object[]{"Analysis incomplete."});
        }
        return false;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.analysisAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.analysisAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private static class ResultCheckStatistics
    implements Statistics {
        private Timer checkTimer = new Timer();
        private Timer analysisTimer = new Timer();
        private int stopChecks = 0;

        private ResultCheckStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            pOut.println("Number of checks:           " + this.stopChecks);
            pOut.println("Time for Analysis:          " + this.analysisTimer);
            pOut.println("Time for Result Check:      " + this.checkTimer);
            if (this.checkTimer.getNumberOfIntervals() > 0) {
                pOut.println("Speed up checking:        " + (float)this.analysisTimer.getSumTime().asNanos() / (float)this.checkTimer.getSumTime().asNanos());
            }
        }

        @Override
        public String getName() {
            return "ResultCheckAlgorithm";
        }
    }
}

