/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.precondition;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionPartition;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.partitioning.PartitioningCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;

public final class PreconditionHelper {
    private final FormulaManagerView mgrv;
    private final BooleanFormulaManagerView bmgr;
    private final PathFormulaManager pfmBwd;
    public static final Predicate<AbstractState> IS_FROM_VIOLATING_PARTITION = new Predicate<AbstractState>(){

        public boolean apply(AbstractState pArg0) {
            return PreconditionHelper.isStateFromPartition(pArg0, PreconditionPartition.VIOLATING);
        }
    };
    public static final Predicate<AbstractState> IS_FROM_VALID_PARTITION = new Predicate<AbstractState>(){

        public boolean apply(AbstractState pArg0) {
            return PreconditionHelper.isStateFromPartition(pArg0, PreconditionPartition.VALID);
        }
    };
    static final Function<PredicateAbstractState, PathFormula> GET_BLOCK_FORMULA = new Function<PredicateAbstractState, PathFormula>(){

        public PathFormula apply(PredicateAbstractState e) {
            assert (e.isAbstractionState());
            return e.getAbstractionFormula().getBlockFormula();
        }
    };

    public PreconditionHelper(FormulaManagerView pMgrv, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        this.mgrv = pMgrv;
        this.bmgr = pMgrv.getBooleanFormulaManager();
        this.pfmBwd = new PathFormulaManagerImpl(this.mgrv, pConfig, pLogger, pShutdownNotifier, pCfa, AnalysisDirection.BACKWARD);
    }

    public static PreconditionPartition spacePartitionToPreconditionPartition(StateSpacePartition pPartition) {
        return pPartition.getPartitionKey().equals((Object)CPAchecker.InitialStatesFor.TARGET) ? PreconditionPartition.VIOLATING : PreconditionPartition.VALID;
    }

    public static boolean isStateFromPartition(AbstractState pState, PreconditionPartition pP) {
        PartitioningCPA.PartitionState state = AbstractStates.extractStateByType(pState, PartitioningCPA.PartitionState.class);
        StateSpacePartition partition = state.getStateSpacePartition();
        return PreconditionHelper.spacePartitionToPreconditionPartition(partition).equals((Object)pP);
    }

    static List<ARGState> transformPath(ARGPath pPath) {
        ImmutableList result = FluentIterable.from(pPath.asStatesList()).skip(1).filter(Predicates.compose(PredicateAbstractState.FILTER_ABSTRACTION_STATES, AbstractStates.toState(PredicateAbstractState.class))).toList();
        assert (pPath.getLastState() == result.get(result.size() - 1));
        return result;
    }

    public BooleanFormula uninstanciatePathFormula(PathFormula pPf) throws SolverException, InterruptedException {
        return this.mgrv.uninstantiate(this.mgrv.eliminateDeadVariables(pPf.getFormula(), pPf.getSsa()));
    }

    public BooleanFormula getPreconditionOfPath(ARGPath pPathToEntryLocation, ARGPath.PathPosition pTraceValWpPos) throws CPATransferException, SolverException, InterruptedException {
        return this.getPreconditionOfPath(pPathToEntryLocation, pTraceValWpPos, true);
    }

    public PathFormula computePathformulaForArbitraryTrace(ARGPath pAbstractPathToEntryLocation, ARGPath.PathPosition pWpPos) throws CPATransferException, InterruptedException, SolverException {
        Preconditions.checkNotNull((Object)pAbstractPathToEntryLocation);
        Preconditions.checkNotNull((Object)pWpPos);
        PathFormula pf = this.pfmBwd.makeEmptyPathFormula();
        ARGPath.PathIterator it = pAbstractPathToEntryLocation.pathIterator();
        while (it.hasNext()) {
            CFAEdge t = it.getOutgoingEdge();
            ARGPath.PathPosition currentPos = it.getPosition();
            it.advance();
            if (t == null) continue;
            if (pWpPos.equals(currentPos)) break;
            if (t.getEdgeType() == CFAEdgeType.BlankEdge) continue;
            pf = this.pfmBwd.makeAnd(pf, t);
        }
        return pf;
    }

    public BooleanFormula getPreconditionOfPath(ARGPath pAbstractPathToEntryLocation, ARGPath.PathPosition pWpPos, boolean uninstanciate) throws CPATransferException, InterruptedException, SolverException {
        Preconditions.checkNotNull((Object)pAbstractPathToEntryLocation);
        Preconditions.checkNotNull((Object)pWpPos);
        PathFormula pf = this.computePathformulaForArbitraryTrace(pAbstractPathToEntryLocation, pWpPos);
        return uninstanciate ? this.uninstanciatePathFormula(pf) : pf.getFormula();
    }

    public BooleanFormula getPreconditionFromReached(ReachedSet pReached, PreconditionPartition pPartition, CFANode pSpecificTargetLocation) {
        Preconditions.checkNotNull((Object)pReached);
        Preconditions.checkNotNull((Object)((Object)pPartition));
        List<BooleanFormula> abstractions = this.getAbstractionsOnLocationFromReached(pReached, pPartition, pSpecificTargetLocation);
        return this.mgrv.simplify(this.bmgr.or(abstractions));
    }

    private PredicateAbstractState getTargetAbstractionState(ARGPath pPathToEntryLocation, CFANode pTargetLocation) {
        Preconditions.checkNotNull((Object)pTargetLocation);
        Preconditions.checkNotNull((Object)pPathToEntryLocation);
        ImmutableList relevantStates = FluentIterable.from(pPathToEntryLocation.asStatesList()).skip(1).filter(Predicates.compose(PredicateAbstractState.FILTER_ABSTRACTION_STATES, AbstractStates.toState(PredicateAbstractState.class))).filter(Predicates.compose((Predicate)Predicates.equalTo((Object)pTargetLocation), AbstractStates.EXTRACT_LOCATION)).toList();
        Verify.verify((relevantStates.size() == 1 ? 1 : 0) != 0);
        return AbstractStates.extractStateByType((AbstractState)relevantStates.get(0), PredicateAbstractState.class);
    }

    private List<BooleanFormula> getAbstractionsOnLocationFromReached(ReachedSet pReached, PreconditionPartition pPartition, CFANode pTargetLocation) {
        Preconditions.checkNotNull((Object)pTargetLocation);
        Preconditions.checkNotNull((Object)((Object)pPartition));
        Preconditions.checkNotNull((Object)pReached);
        ArrayList result = Lists.newArrayList();
        FluentIterable targetStates = FluentIterable.from((Iterable)pReached).filter(Predicates.compose(PredicateAbstractState.FILTER_ABSTRACTION_STATES, AbstractStates.toState(PredicateAbstractState.class))).filter(Predicates.compose((Predicate)Predicates.equalTo((Object)pTargetLocation), AbstractStates.EXTRACT_LOCATION));
        for (AbstractState s : targetStates) {
            if (!PreconditionHelper.isStateFromPartition(s, pPartition)) continue;
            ARGState target = (ARGState)s;
            ARGPath pathToEntryLocation = ARGUtils.getOnePathTo(target);
            Verify.verify((pathToEntryLocation != null ? 1 : 0) != 0, (String)"The abstract target-state must be on an abstract path!", (Object[])new Object[0]);
            PredicateAbstractState state = this.getTargetAbstractionState(pathToEntryLocation, pTargetLocation);
            result.add(this.mgrv.uninstantiate(state.getAbstractionFormula().asFormula()));
        }
        return result;
    }
}

