/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.precondition;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.Ignore;
import org.mockito.Mockito;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionHelper;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@Ignore
public class PreconditionHelperTest
extends SolverBasedTest0 {
    private PreconditionHelper helper;
    private FormulaManagerView mgrv;
    private CFAEdge _label_error;
    private CFAEdge _assume_i_geq_al;
    private CFAEdge _assume_b_at_i_neq_0;
    private CFAEdge _while;
    private CFAEdge _stmt_i_assign_0;
    private CFAEdge _stmt_declare_i;
    private CFAEdge _dummy;
    private CFAEdge _function_declaration;
    private CFAEdge _stmt_al_assign_0;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() throws InvalidConfigurationException {
        ConfigurationBuilder result = super.createTestConfigBuilder();
        result.setOption("cpa.predicate.handlePointerAliasing", "false");
        result.setOption("cpa.predicate.handleArrays", "true");
        return result;
    }

    @Before
    public void setUp() throws Exception {
        CFA cfa = (CFA)Mockito.mock(CFA.class);
        Mockito.when((Object)((Object)cfa.getMachineModel())).thenReturn((Object)MachineModel.LINUX64);
        Mockito.when(cfa.getVarClassification()).thenReturn((Object)Optional.absent());
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.helper = new PreconditionHelper(this.mgrv, this.config, this.logger, ShutdownNotifier.create(), cfa);
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(MachineModel.LINUX64, TestLogManager.getInstance());
        CArrayType unlimitedIntArrayType = new CArrayType(false, false, CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _i_decl = TestDataTools.makeDeclaration("i", CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _al_decl = TestDataTools.makeDeclaration("al", CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _a = TestDataTools.makeDeclaration("a", unlimitedIntArrayType, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _b = TestDataTools.makeDeclaration("b", unlimitedIntArrayType, null);
        Triple<CDeclarationEdge, CFunctionDeclaration, CFunctionType> _funct_decl = TestDataTools.makeFunctionDeclaration("copy", CVoidType.VOID, Lists.newArrayList((Object[])new CParameterDeclaration[]{new CParameterDeclaration(FileLocation.DUMMY, unlimitedIntArrayType, "a"), new CParameterDeclaration(FileLocation.DUMMY, unlimitedIntArrayType, "b")}));
        CIdExpression _i = (CIdExpression)_i_decl.getThird();
        CIdExpression _al = TestDataTools.makeVariable("al", CNumericTypes.INT);
        CIntegerLiteralExpression _0 = CIntegerLiteralExpression.createDummyLiteral(0L, CNumericTypes.INT);
        CIntegerLiteralExpression _1 = CIntegerLiteralExpression.createDummyLiteral(1L, CNumericTypes.INT);
        CArraySubscriptExpression _b_at_i = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)_b.getThird(), _i);
        this._label_error = TestDataTools.makeBlankEdge("ERROR");
        this._assume_i_geq_al = (CFAEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_i, _al, CBinaryExpression.BinaryOperator.GREATER_EQUAL)).getFirst();
        this._assume_b_at_i_neq_0 = (CFAEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_b_at_i, _0, CBinaryExpression.BinaryOperator.NOT_EQUALS)).getFirst();
        this._while = TestDataTools.makeBlankEdge("while");
        this._stmt_i_assign_0 = (CFAEdge)TestDataTools.makeAssignment(_i, _0).getFirst();
        this._stmt_declare_i = (CFAEdge)_i_decl.getFirst();
        this._dummy = TestDataTools.makeBlankEdge("dummy");
        this._function_declaration = (CFAEdge)_funct_decl.getFirst();
        this._stmt_al_assign_0 = (CFAEdge)TestDataTools.makeAssignment(_al, _0).getFirst();
    }
}

