/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.precondition;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionHelper;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionPartition;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionToSmtlibWriter;
import org.sosy_lab.cpachecker.core.algorithm.precondition.interfaces.PreconditionWriter;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.ReachedSetUtils;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.partitioning.PartitioningCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.precondition.segkro.ExtractNewPreds;
import org.sosy_lab.cpachecker.util.precondition.segkro.MinCorePrio;
import org.sosy_lab.cpachecker.util.precondition.segkro.Refine;
import org.sosy_lab.cpachecker.util.precondition.segkro.RefineSolverBasedItp;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.PreconditionRefiner;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.RuleEngine;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;

@Options(prefix="precondition")
public class PreconditionRefinerAlgorithm
implements Algorithm,
StatisticsProvider {
    PreconditionRefinerStatistics stats = new PreconditionRefinerStatistics();
    @Option(secure=true, name="export.type", description="(How) should the precondition be exported?")
    private PreconditionExportType exportPreciditionsAs = PreconditionExportType.NONE;
    @Option(secure=true, name="export.target", description="Where should the precondition be exported to?")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportPreciditionsTo = Paths.get((String)"precondition.txt", (String[])new String[0]);
    @Option(secure=true, description="Use the refiner that uses a solver-based interpolation mechanism.")
    private boolean solverbasedInterpolation = false;
    private final ReachedSetFactory reachedSetFactory;
    private final Algorithm wrappedAlgorithm;
    private final AbstractionManager amgr;
    private final FormulaManagerView mgrv;
    private final LogManager logger;
    private final Solver solver;
    private final CFA cfa;
    private final PredicateCPA predcpa;
    private final ARGCPA argcpa;
    private final PreconditionRefiner refiner;
    private final RuleEngine ruleEngine;
    private final PreconditionHelper helper;
    private final Optional<PreconditionWriter> writer;

    public PreconditionRefinerAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        ((Configuration)Preconditions.checkNotNull((Object)pConfig)).inject((Object)this);
        Preconditions.checkNotNull((Object)CPAs.retrieveCPA(pCpa, PartitioningCPA.class), (Object)"The CPA must be composed of a PartitioningCPA in order to provide a precondition!");
        this.argcpa = (ARGCPA)Preconditions.checkNotNull((Object)CPAs.retrieveCPA(pCpa, ARGCPA.class), (Object)"The CPA must be composed of an ARG CPA in order to provide a precondition!");
        this.predcpa = (PredicateCPA)Preconditions.checkNotNull((Object)CPAs.retrieveCPA(pCpa, PredicateCPA.class), (Object)"The CPA must be composed of a predicate analysis in order to provide a precondition!");
        this.cfa = pCfa;
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.wrappedAlgorithm = (Algorithm)Preconditions.checkNotNull((Object)pAlgorithm);
        this.reachedSetFactory = new ReachedSetFactory(pConfig, pLogger);
        this.amgr = this.predcpa.getAbstractionManager();
        this.mgrv = this.predcpa.getSolver().getFormulaManager();
        this.solver = this.predcpa.getSolver();
        this.helper = new PreconditionHelper(this.mgrv, pConfig, this.logger, pShutdownNotifier, pCfa);
        this.ruleEngine = new RuleEngine(this.logger, this.solver);
        this.refiner = this.createRefiner(pConfig, pShutdownNotifier);
        this.writer = this.exportPreciditionsAs == PreconditionExportType.SMTLIB ? Optional.of((Object)new PreconditionToSmtlibWriter(pCfa, pConfig, pLogger, this.mgrv)) : Optional.absent();
    }

    private PreconditionRefiner createRefiner(Configuration pConfig, ShutdownNotifier pShutdown) throws InvalidConfigurationException {
        if (this.solverbasedInterpolation) {
            return new RefineSolverBasedItp(pConfig, this.logger, pShutdown, this.cfa, this.solver, this.amgr, new ExtractNewPreds(this.solver, this.ruleEngine), new MinCorePrio(this.logger, this.cfa, this.solver));
        }
        return new Refine(pConfig, this.logger, pShutdown, this.cfa, this.solver, this.amgr, new ExtractNewPreds(this.solver, this.ruleEngine), new MinCorePrio(this.logger, this.cfa, this.solver));
    }

    private BooleanFormula getPreconditionForViolation(ReachedSet pReachedSet, CFANode pWpLoc) {
        return this.helper.getPreconditionFromReached(pReachedSet, PreconditionPartition.VIOLATING, pWpLoc);
    }

    private BooleanFormula getPreconditionForValidity(ReachedSet pReachedSet, CFANode pWpLoc) {
        return this.helper.getPreconditionFromReached(pReachedSet, PreconditionPartition.VALID, pWpLoc);
    }

    private Set<ARGState> getStatesAtLocation(ReachedSet pReachedSet, Predicate<AbstractState> pPartitionFilterPredicate, CFANode pLoc) throws NoTraceFoundException {
        Preconditions.checkNotNull(pPartitionFilterPredicate);
        Preconditions.checkNotNull((Object)pReachedSet);
        Preconditions.checkNotNull((Object)pLoc);
        ImmutableSet statesAtWpLoc = FluentIterable.from((Iterable)pReachedSet).filter(Predicates.compose((Predicate)Predicates.equalTo((Object)pLoc), AbstractStates.EXTRACT_LOCATION)).filter(pPartitionFilterPredicate).transform(AbstractStates.toState(ARGState.class)).toSet();
        HashSet relevantStates = Sets.newHashSet((Iterable)statesAtWpLoc);
        for (ARGState e : statesAtWpLoc) {
            relevantStates.addAll(e.getCoveredByThis());
        }
        if (relevantStates.isEmpty()) {
            throw new NoTraceFoundException("No trace to the target location found!");
        }
        return relevantStates;
    }

    private boolean isDisjoint(BooleanFormula pP1, BooleanFormula pP2) throws SolverException, InterruptedException {
        return this.solver.isUnsat(this.mgrv.getBooleanFormulaManager().and(pP1, pP2));
    }

    private CFANode getFirstNodeInEntryFunctionBody() {
        CFANode next = this.cfa.getMainFunction();
        boolean isEntryFunctionDeclEdge = false;
        do {
            ADeclarationEdge declEdge;
            if (next.getNumLeavingEdges() > 1) {
                throw new AssertionError((Object)"getFirstNodeInEntryFunctionBody: More than one leaving edge!");
            }
            if (next.getNumLeavingEdges() == 0) {
                next = null;
                continue;
            }
            CFAEdge edge = next.getLeavingEdge(0);
            next = edge.getSuccessor();
            if (edge.getEdgeType() != CFAEdgeType.DeclarationEdge || !((declEdge = (ADeclarationEdge)edge).getDeclaration() instanceof AFunctionDeclaration)) continue;
            AFunctionDeclaration fnDecl = (AFunctionDeclaration)declEdge.getDeclaration();
            isEntryFunctionDeclEdge = fnDecl.getName().equals(this.cfa.getMainFunction().getFunctionName());
        } while (!isEntryFunctionDeclEdge && next != null);
        return next;
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException, PredicatedAnalysisPropertyViolationException {
        ReachedSet initialReachedSet = this.reachedSetFactory.create();
        ReachedSetUtils.addReachedStatesToOtherReached(pReachedSet, initialReachedSet);
        CFANode wpLoc = this.getFirstNodeInEntryFunctionBody();
        boolean precisionFixpointReached = false;
        boolean preconditionFixpointReached = false;
        BooleanFormula lastIterationPcViolation = null;
        BooleanFormula lastIterationPcValid = null;
        PredicatePrecision lastPrecision = null;
        HashSet coveredViolationTraces = Sets.newHashSet();
        HashSet coveredValidTraces = Sets.newHashSet();
        HashMultimap coveredTracePairs = HashMultimap.create();
        PredicatePrecision newPrecision = null;
        while (true) {
            this.wrappedAlgorithm.run(pReachedSet);
            BooleanFormula pcViolation = this.getPreconditionForViolation(pReachedSet, wpLoc);
            BooleanFormula pcValid = this.getPreconditionForValidity(pReachedSet, wpLoc);
            if (lastIterationPcViolation != null && lastIterationPcViolation.equals(pcViolation) && lastIterationPcValid.equals(pcValid)) {
                preconditionFixpointReached = true;
            }
            lastIterationPcViolation = pcViolation;
            lastIterationPcValid = pcValid;
            if (this.isDisjoint(pcViolation, pcValid)) {
                this.logger.log(Level.INFO, new Object[]{"Necessary and sufficient precondition found!"});
                if (this.writer.isPresent()) {
                    try {
                        BooleanFormula weakestPrecondition = pcValid;
                        ((PreconditionWriter)this.writer.get()).writePrecondition(this.exportPreciditionsTo, weakestPrecondition);
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, new Object[]{"Writing the precondition failed!", e});
                    }
                }
                return true;
            }
            try {
                Pair<ARGPath, ARGPath> tracesWithIntersectInAbstr = this.getTracesWithIntersectInAbstr(pReachedSet, wpLoc, (Multimap<ARGPath, ARGPath>)coveredTracePairs);
                ARGPath traceFromViolation = (ARGPath)tracesWithIntersectInAbstr.getFirst();
                ARGPath traceFromValid = (ARGPath)tracesWithIntersectInAbstr.getSecond();
                coveredTracePairs.put((Object)traceFromViolation, (Object)traceFromValid);
                ARGPath.PathPosition traceVioWpPos = traceFromViolation.reversePathIterator().getPosition();
                ARGPath.PathPosition traceValWpPos = traceFromValid.reversePathIterator().getPosition();
                ++this.stats.tracesToError;
                ++this.stats.tracesToExit;
                BooleanFormula pcViolatingTrace = this.helper.getPreconditionOfPath(traceFromViolation, traceVioWpPos);
                BooleanFormula pcValidTrace = this.helper.getPreconditionOfPath(traceFromValid, traceValWpPos);
                if (!this.isDisjoint(pcViolatingTrace, pcValidTrace)) {
                    this.logger.log(Level.WARNING, new Object[]{"Non-determinism in the program!"});
                    return true;
                }
                if (this.mgrv.getBooleanFormulaManager().isFalse(pcViolatingTrace)) {
                    ++this.stats.infeasibleTracesToError;
                }
                if (this.mgrv.getBooleanFormulaManager().isFalse(pcValidTrace)) {
                    ++this.stats.infeasibleTracesToExit;
                }
                if (this.mgrv.getBooleanFormulaManager().isFalse(pcViolatingTrace) && this.mgrv.getBooleanFormulaManager().isFalse(pcValidTrace)) {
                    this.logger.log(Level.WARNING, new Object[]{"Infeasible traces during the precondition refinement! CEGAR applicable!"});
                }
                PredicatePrecision newPrecFromTracePair = this.refiner.refine(traceVioWpPos, traceValWpPos);
                newPrecision = newPrecision == null ? newPrecFromTracePair : newPrecision.mergeWith(newPrecFromTracePair);
                ++this.stats.refinements;
                if (lastPrecision != null && lastPrecision.equals(newPrecision)) {
                    precisionFixpointReached = true;
                }
                lastPrecision = newPrecision;
                if (precisionFixpointReached && preconditionFixpointReached) {
                    this.logger.log(Level.WARNING, new Object[]{"Terminated because of a fixpoint in the set of predicates and the precondition!"});
                    return true;
                }
                Verify.verify((newPrecision != null ? 1 : 0) != 0);
                this.refinePrecisionForNextIteration(initialReachedSet, pReachedSet, newPrecision);
            }
            catch (NoTraceFoundException e) {
                this.logger.log(Level.WARNING, new Object[]{e.getMessage()});
                return true;
            }
        }
    }

    private Pair<ARGPath, ARGPath> getTracesWithIntersectInAbstr(ReachedSet pReachedSet, CFANode pWpLoc, Multimap<ARGPath, ARGPath> pCoveredPairs) throws NoTraceFoundException, SolverException, InterruptedException {
        Set<ARGState> violatingStates = this.getStatesAtLocation(pReachedSet, PreconditionHelper.IS_FROM_VIOLATING_PARTITION, pWpLoc);
        Set<ARGState> validStates = this.getStatesAtLocation(pReachedSet, PreconditionHelper.IS_FROM_VALID_PARTITION, pWpLoc);
        for (ARGState violating : violatingStates) {
            PredicateAbstractState violatingAbstState = AbstractStates.extractStateByType(violating, PredicateAbstractState.class);
            for (ARGState valid : validStates) {
                PredicateAbstractState validAbstState = AbstractStates.extractStateByType(valid, PredicateAbstractState.class);
                HashSet handledViolatingTraces = Sets.newHashSet();
                HashSet handledValidTraces = Sets.newHashSet();
                if (this.isDisjoint(violatingAbstState.getAbstractionFormula().asFormula(), validAbstState.getAbstractionFormula().asFormula())) continue;
                Optional<ARGPath> violatingTrace = Optional.absent();
                Optional<ARGPath> validTrace = Optional.absent();
                do {
                    if (!(violatingTrace = ARGUtils.getOnePathTo(violating, handledViolatingTraces)).isPresent()) continue;
                    handledViolatingTraces.add(violatingTrace.get());
                    validTrace = ARGUtils.getOnePathTo(valid, pCoveredPairs.get(violatingTrace.get()));
                    if (!validTrace.isPresent()) continue;
                    handledValidTraces.add(validTrace.get());
                    if (pCoveredPairs.containsEntry(violatingTrace, validTrace)) continue;
                    return Pair.of((Object)violatingTrace.get(), (Object)validTrace.get());
                } while (violatingTrace.isPresent() && validTrace.isPresent());
            }
        }
        throw new NoTraceFoundException("No new pair of disjoint abstract traces found! The choosen predicate abstraction method might be too imprecise!");
    }

    private void refinePrecisionForNextIteration(ReachedSet pInitialStates, ReachedSet pTo, PredicatePrecision pPredPrecision) {
        ARGReachedSet argReachedSetTo = new ARGReachedSet(pTo, this.argcpa);
        for (AbstractState rootState : pInitialStates) {
            ARGState as = AbstractStates.extractStateByType(rootState, ARGState.class);
            ArrayList childsToRemove = Lists.newArrayList(as.getChildren());
            for (ARGState childWithSubTreeToRemove : childsToRemove) {
                argReachedSetTo.removeSubtree(childWithSubTreeToRemove, pPredPrecision, (Predicate<? super Precision>)Predicates.instanceOf(PredicatePrecision.class));
            }
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.ruleEngine.collectStatistics(pStatsCollection);
        if (this.wrappedAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.wrappedAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    public static enum PreconditionExportType {
        NONE,
        SMTLIB;

    }

    private static class PreconditionRefinerStatistics
    extends AbstractStatistics {
        public int refinements = 0;
        public int tracesToExit = 0;
        public int tracesToError = 0;
        public int infeasibleTracesToExit = 0;
        public int infeasibleTracesToError = 0;

        private PreconditionRefinerStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            this.put(pOut, "Number of precondition refinements", this.refinements);
            this.put(pOut, "Analyzed traces to the ERROR location", this.tracesToError);
            this.put(pOut, "Analyzed traces to the EXIT location", this.tracesToExit);
            this.put(pOut, "Infeasible traces to the ERROR location", this.infeasibleTracesToError);
            this.put(pOut, "Infeasible traces to the EXIT location", this.infeasibleTracesToExit);
        }
    }

    private static class NoTraceFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoTraceFoundException(String pMessage) {
            super(pMessage);
        }
    }
}

