/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.precondition;

import com.google.common.base.Preconditions;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.precondition.interfaces.PreconditionWriter;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options
public class PreconditionToSmtlibWriter
implements PreconditionWriter {
    private final FormulaManagerView fmgr;

    public PreconditionToSmtlibWriter(CFA pCfa, Configuration pConfig, LogManager pLogger, FormulaManagerView pFormulaManager) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.fmgr = pFormulaManager;
    }

    public void writePrecondition(@Nonnull Appendable pWriteTo, @Nonnull BooleanFormula pPrecondition) throws IOException, CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)pWriteTo);
        BooleanFormula precondition = this.fmgr.simplify(pPrecondition);
        if (this.fmgr.getBooleanFormulaManager().isTrue(precondition)) {
            pWriteTo.append("(assert true)");
        } else {
            this.fmgr.dumpFormula(precondition).appendTo(pWriteTo);
        }
    }

    public void writePrecondition(Path pWriteTo, BooleanFormula pPrecondition, @Nonnull LogManager pCatchExceptionsTo) {
        Preconditions.checkNotNull((Object)pCatchExceptionsTo);
        try {
            this.writePrecondition(pWriteTo, pPrecondition);
        }
        catch (Exception e) {
            pCatchExceptionsTo.logException(Level.WARNING, (Throwable)e, "Writing reaching paths failed!");
        }
    }

    @Override
    public void writePrecondition(Path pWriteTo, BooleanFormula pPrecondition) throws IOException, CPATransferException, InterruptedException {
        try (Writer w = Files.openOutputFile((Path)pWriteTo, (FileWriteMode[])new FileWriteMode[0]);){
            this.writePrecondition(w, pPrecondition);
        }
    }
}

