/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen;

import com.google.common.base.Joiner;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.IterationStrategyFactory;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.TestGenIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelectorFactory;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

@Options(prefix="testgen")
public class TestGenAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="simulationStrategy", description="Selects the simulation Strategy for TestGenAlgorithm")
    private IterationStrategySelector iterationStrategySelector = IterationStrategySelector.AUTOMATON_CONTROLLED;
    @Option(secure=true, name="pathSelector", description="The path selector for TestGenAlgorithm")
    private AnalysisStrategySelector analysisStrategySelector = AnalysisStrategySelector.CUTE_PATH_SELECTOR;
    @Option(secure=true, name="produceDebugFiles", description="Set this to true to get the automaton files for exploring new Paths. You also get the ARG as dot file and the local reached set for every algoritm iteration in subdirs under output.")
    private boolean produceDebugFiles = false;
    @Option(secure=true, name="testcaseOutputFile", description="Output file Template under which the testcase automatons will be stored. Must include one %s somewhere.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path testcaseOutputFile = Paths.get((String)"testcase%s.spc", (String[])new String[0]);
    @Option(secure=true, name="stopOnError", description="algorithm stops on first found error path. Otherwise the algorithms tries to reach 100% coverage")
    private boolean stopOnError = false;
    @Option(secure=true, description="Where to write the reached sets to.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate reachedSetExportPaths = PathCounterTemplate.ofFormatString((String)"reachedsets/reached%d.txt");
    @Option(secure=true, description="Where to write the ARGS to.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate argExportPaths = PathCounterTemplate.ofFormatString((String)"args/arg%d.dot");
    private TestGenIterationStrategy iterationStrategy;
    private PathSelector pathSelector;
    private CFA cfa;
    private TestGenStatistics stats;
    private StartupConfig startupConfig;
    private StartupConfig singleRunConfig;
    private LogManager logger;
    private int testCaseCounter = 0;

    public TestGenAlgorithm(Algorithm pAlgorithm, ConfigurableProgramAnalysis pCpa, ShutdownNotifier pShutdownNotifier, CFA pCfa, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException, CPAException {
        this.startupConfig = new StartupConfig(pConfig, pLogger, pShutdownNotifier);
        this.startupConfig.getConfig().inject((Object)this);
        this.singleRunConfig = StartupConfig.createWithParent(this.startupConfig);
        this.stats = new TestGenStatistics(this.iterationStrategySelector == IterationStrategySelector.AUTOMATON_CONTROLLED, pCfa);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.iterationStrategy = new IterationStrategyFactory(this.singleRunConfig, this.cfa, new ReachedSetFactory(this.startupConfig.getConfig(), this.logger), this.stats, this.produceDebugFiles).createStrategy(this.iterationStrategySelector, pAlgorithm);
        this.pathSelector = new PathSelectorFactory(this.startupConfig).createPathSelector(this.analysisStrategySelector, pCfa, this.stats);
    }

    @Override
    public boolean run(ReachedSet pReachedSet) throws CPAException, InterruptedException, PredicatedAnalysisPropertyViolationException {
        this.startupConfig.getShutdownNotifier().shutdownIfNecessary();
        this.stats.getTotalTimer().start();
        this.iterationStrategy.initializeModel(pReachedSet);
        long loopCounter = 0L;
        while (true) {
            this.startupConfig.getShutdownNotifier().shutdownIfNecessary();
            this.logger.logf(Level.FINER, "TestGen iteration %d", new Object[]{loopCounter++});
            try {
                this.iterationStrategy.runAlgorithm();
            }
            catch (InterruptedException e) {
                this.startupConfig.getShutdownNotifier().shutdownIfNecessary();
            }
            if (!(this.iterationStrategy.getLastState() instanceof ARGState)) {
                throw new IllegalStateException("wrong configuration of explicit cpa, because concolicAlg needs ARGState");
            }
            ARGState pseudoTarget = (ARGState)this.iterationStrategy.getLastState();
            ARGPath executedPath = ARGUtils.getOnePathTo(pseudoTarget);
            CounterexampleTraceInfo traceInfo = this.pathSelector.computePredicateCheck(executedPath);
            if (this.produceDebugFiles) {
                this.dumpReachedAndARG(this.iterationStrategy.getModel().getLocalReached());
            }
            if (traceInfo.isSpurious()) {
                this.logger.log(Level.FINER, new Object[]{"Current execution path is spurious."});
            } else {
                this.dumpTestCase(executedPath, traceInfo);
                if (pseudoTarget.isTarget()) {
                    this.logger.log(Level.FINER, new Object[]{"Identified error path."});
                    if (this.stopOnError) {
                        this.stats.getTotalTimer().stop();
                        return true;
                    }
                }
            }
            this.logger.log(Level.FINE, new Object[]{"Starting predicate path check..."});
            PredicatePathAnalysisResult result = this.pathSelector.findNewFeasiblePathUsingPredicates(executedPath, this.iterationStrategy.getModel().getLocalReached());
            this.logger.log(Level.FINE, new Object[]{"predicate path check DONE"});
            if (result.isEmpty()) {
                this.stats.getTotalTimer().stop();
                return true;
            }
            this.iterationStrategy.updateIterationModelForNextIteration(result);
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private void dumpTestCase(ARGPath pExecutedPath, CounterexampleTraceInfo pTraceInfo) {
        if (this.testcaseOutputFile == null) {
            return;
        }
        String fileName = String.format(this.testcaseOutputFile.toAbsolutePath().toString(), this.testCaseCounter);
        Path filePath = Paths.get((String)fileName, (String[])new String[0]);
        String automatonName = String.format("Testcase%s", this.testCaseCounter);
        ARGState rootState = pExecutedPath.getFirstState();
        CounterexampleInfo ceInfo = CounterexampleInfo.feasible(pExecutedPath, pTraceInfo.getModel());
        try (Writer w = Files.openOutputFile((Path)filePath, (FileWriteMode[])new FileWriteMode[0]);){
            ARGUtils.producePathAutomaton(w, rootState, pExecutedPath.getStateSet(), automatonName, ceInfo);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write " + automatonName + " to file");
        }
        ++this.testCaseCounter;
    }

    private void dumpReachedAndARG(ReachedSet pReached) {
        Throwable throwable;
        Writer w;
        try {
            w = Files.openOutputFile((Path)this.reachedSetExportPaths.getFreshPath(), (FileWriteMode[])new FileWriteMode[0]);
            throwable = null;
            try {
                Joiner.on((char)'\n').appendTo((Appendable)w, (Iterable)pReached);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write reached set to file");
        }
        try {
            w = Files.openOutputFile((Path)this.argExportPaths.getFreshPath(), (FileWriteMode[])new FileWriteMode[0]);
            throwable = null;
            try {
                ARGUtils.writeARGAsDot(w, (ARGState)pReached.getFirstState());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (w != null) {
                    if (throwable != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write ARG to file");
        }
    }

    public static enum AnalysisStrategySelector {
        LOCATION_AND_VALUE_STATE_TRACKING,
        CFA_TRACKING,
        CUTE_PATH_SELECTOR,
        CUTE_LIKE;

    }

    public static enum IterationStrategySelector {
        AUTOMATON_CONTROLLED,
        SAME_ALGORITHM_RESTART,
        SAME_ALGORITHM_FILTER_WAITLIST;

    }
}

