/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public class TestGenStatistics
implements Statistics {
    private final Timer totalTimer = new Timer();
    private final Timer cpaAlogorithmTimer = new Timer();
    private final Timer pathCheckTimer = new Timer();
    private final Timer automatonFileGenerationTimer = new Timer();
    private volatile int cpaAlgorithmCount = 0;
    private volatile int countPathChecks = 0;
    private final boolean printAutomatonFileGenerationStats;
    private final List<Statistics> cpaAlgorithmStatistics = new ArrayList<Statistics>();
    private final List<MutableARGPath> testCases = new ArrayList<MutableARGPath>();
    private CFA cfa;

    public TestGenStatistics(boolean pPrintAutomatonFileGenerationStats, CFA pCfa) {
        this.printAutomatonFileGenerationStats = pPrintAutomatonFileGenerationStats;
        this.cfa = pCfa;
    }

    @Override
    public String getName() {
        return "TestGen algorithm";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        int locs = this.calculateTestedLocations();
        out.println("Number of CPA algorithm runs:         " + this.cpaAlgorithmCount);
        out.println("Locations covered by testcases:       " + locs);
        out.println("Testcase location coverage:           " + StatisticsUtils.toPercent(locs, this.cfa.getAllNodes().size()));
        if (this.cpaAlgorithmCount > 0) {
            out.println("Number of PathChecker querys:         " + this.countPathChecks);
            out.println("");
            out.println("Average time CPA algorithm runs:      " + this.cpaAlogorithmTimer.getAvgTime().formatAs(TimeUnit.SECONDS));
            out.println("Max time for CPA algorithm runs:      " + this.cpaAlogorithmTimer.getMaxTime().formatAs(TimeUnit.SECONDS));
            out.println("Time for CPA Algorithm runs:          " + this.cpaAlogorithmTimer);
            out.println("Time for PathChecker querys:          " + this.pathCheckTimer);
            out.println("Total time for TestGen algorithm:     " + this.totalTimer);
            if (this.printAutomatonFileGenerationStats) {
                out.println("Time next automaton file generation:  " + this.automatonFileGenerationTimer);
            }
            out.println();
            for (int i = 0; i < this.cpaAlgorithmStatistics.size(); ++i) {
                out.println("-> Statistics for CPA algorithm run #" + i + ":");
                out.println();
                this.cpaAlgorithmStatistics.get(i).printStatistics(out, pResult, pReached);
                out.println();
            }
        }
    }

    private void collectStatisticsForAlgorithm(Algorithm pAlgorithm) {
        if (pAlgorithm instanceof StatisticsProvider) {
            StatisticsProvider sProvider = (StatisticsProvider)((Object)pAlgorithm);
            sProvider.collectStatistics(this.cpaAlgorithmStatistics);
        }
    }

    public void addTestCase(MutableARGPath pARGPath) {
        this.testCases.add(pARGPath);
    }

    public void beforeAutomationFileGeneration() {
        this.automatonFileGenerationTimer.start();
    }

    public void afterAutomatonFileGeneration() {
        this.automatonFileGenerationTimer.stop();
    }

    public void beforePathCheck() {
        ++this.countPathChecks;
        this.pathCheckTimer.start();
    }

    public void afterPathCheck() {
        this.pathCheckTimer.stop();
    }

    public void beforeCpaAlgortihm() {
        ++this.cpaAlgorithmCount;
        this.cpaAlogorithmTimer.start();
    }

    public void afterCpaAlgortihm(Algorithm pAlgorithm) {
        this.cpaAlogorithmTimer.stop();
        this.collectStatisticsForAlgorithm(pAlgorithm);
    }

    private int calculateTestedLocations() {
        HashSet locations = new HashSet();
        for (MutableARGPath path : this.testCases) {
            ImmutableSet currentLocs = FluentIterable.from(path.getStateSet()).transform(AbstractStates.EXTRACT_LOCATION).filter(Predicates.notNull()).toSet();
            locations.addAll(currentLocs);
        }
        return locations.size();
    }

    Timer getTotalTimer() {
        return this.totalTimer;
    }
}

