/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.iteration;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.TestGenIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.PredicatedAnalysisPropertyViolationException;

public abstract class AbstractIterationStrategy
implements TestGenIterationStrategy {
    protected final Configuration config;
    protected final LogManager logger;
    protected final ShutdownNotifier shutdownNotifier;
    protected final ReachedSetFactory reachedSetFactory;
    private final TestGenIterationStrategy.IterationModel model;
    protected TestGenStatistics stats;

    public AbstractIterationStrategy(StartupConfig pConfig, TestGenIterationStrategy.IterationModel pModel, ReachedSetFactory pReachedSetFactory, TestGenStatistics pStats) {
        this.config = pConfig.getConfig();
        this.logger = pConfig.getLog();
        this.shutdownNotifier = pConfig.getShutdownNotifier();
        this.model = pModel;
        this.reachedSetFactory = pReachedSetFactory;
        this.stats = pStats;
    }

    @Override
    public void initializeModel(ReachedSet pReachedSet) {
        this.getModel().setGlobalReached(pReachedSet);
        ReachedSet currentReached = this.reachedSetFactory.create();
        this.getModel().setLocalReached(currentReached);
        AbstractState initialState = this.getGlobalReached().getFirstState();
        currentReached.add(initialState, this.getGlobalReached().getPrecision(initialState));
    }

    @Override
    public boolean runAlgorithm() throws PredicatedAnalysisPropertyViolationException, CPAException, InterruptedException {
        this.stats.beforeCpaAlgortihm();
        boolean ret = this.model.getAlgorithm().run(this.model.getLocalReached());
        this.stats.afterCpaAlgortihm(this.model.getAlgorithm());
        this.updateReached();
        return ret;
    }

    @Override
    public AbstractState getLastState() {
        return this.model.getLocalReached().getLastState();
    }

    @Override
    public TestGenIterationStrategy.IterationModel getModel() {
        return this.model;
    }

    protected ReachedSet getGlobalReached() {
        return this.getModel().getGlobalReached();
    }

    protected ReachedSet getLocalReached() {
        return this.getModel().getLocalReached();
    }

    protected abstract void updateReached();
}

