/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.iteration;

import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.AbstractIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.TestGenIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.ReachedSetUtils;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="testgen")
public class AutomatonControlledIterationStrategy
extends AbstractIterationStrategy {
    private CFA cfa;
    private ConfigurableProgramAnalysis currentCPA;
    private List<Pair<AbstractState, Precision>> wrongStates;
    @Option(secure=true, description="Where to write the automata to.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate automatonExportPaths = PathTemplate.ofFormatString((String)"automaton/next_automaton%s_%s.spc");
    private int automatonCounter = 0;
    private static final String automatonSuffix = UUID.randomUUID().toString();
    private boolean produceDebugFiles;

    public AutomatonControlledIterationStrategy(StartupConfig startupConfig, CFA pCfa, TestGenIterationStrategy.IterationModel model, ReachedSetFactory pReachedSetFactory, TestGenStatistics pStats, boolean pProduceDebugFiles) throws InvalidConfigurationException {
        super(startupConfig, model, pReachedSetFactory, pStats);
        startupConfig.getConfig().inject((Object)this);
        this.cfa = pCfa;
        this.produceDebugFiles = pProduceDebugFiles;
        this.wrongStates = Lists.newLinkedList();
    }

    @Override
    public void updateIterationModelForNextIteration(PredicatePathAnalysisResult pResult) {
        this.getModel().setAlgorithm(this.createAlgorithmForNextIteration(pResult));
        if (this.automatonCounter > 1) {
            this.wrongStates.add((Pair<AbstractState, Precision>)Pair.of((Object)pResult.getWrongState(), (Object)this.getLocalReached().getPrecision(pResult.getWrongState())));
        }
        ReachedSet newReached = this.reachedSetFactory.create();
        AbstractState initialState = this.getModel().getGlobalReached().getFirstState();
        CFANode initialLoc = AbstractStates.extractLocation(initialState);
        initialState = this.currentCPA.getInitialState(initialLoc, StateSpacePartition.getDefaultPartition());
        newReached.add(initialState, this.currentCPA.getInitialPrecision(initialLoc, StateSpacePartition.getDefaultPartition()));
        this.getModel().setLocalReached(newReached);
    }

    @Override
    protected void updateReached() {
        ReachedSetUtils.addReachedStatesToOtherReached(this.getModel().getLocalReached(), this.getModel().getGlobalReached());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Algorithm createAlgorithmForNextIteration(PredicatePathAnalysisResult pResult) {
        if (this.produceDebugFiles) {
            Path path = this.automatonExportPaths.getPath(new Object[]{this.automatonCounter++, automatonSuffix});
            this.generateAutomatonFileForNextIteration(pResult, path);
            return this.createNewAlgorithm(path);
        }
        try (Files.DeleteOnCloseFile tempFile = Files.createTempFile((String)"next-automaton", (String)".spc");){
            this.generateAutomatonFileForNextIteration(pResult, tempFile.toPath().toAbsolutePath());
            Algorithm algorithm = this.createNewAlgorithm(tempFile.toPath().toAbsolutePath());
            return algorithm;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create the Algorithm for next Iteration", e);
        }
    }

    private Algorithm createNewAlgorithm(Path pAutomatonPath) {
        try {
            Configuration lConfig = Configuration.builder().copyFrom(this.config).clearOption("analysis.algorithm.testGen").setOption("EvalOnlyOnePathAutomaton.cpa.automaton.inputFile", pAutomatonPath.getAbsolutePath()).build();
            CPABuilder localBuilder = new CPABuilder(lConfig, this.logger, ShutdownNotifier.createWithParent(this.shutdownNotifier), this.reachedSetFactory);
            this.currentCPA = localBuilder.buildCPAWithSpecAutomatas(this.cfa);
            if (this.getModel().getAlgorithm() instanceof CPAAlgorithm) {
                return CPAAlgorithm.create(this.currentCPA, this.logger, lConfig, this.shutdownNotifier);
            }
            throw new InvalidConfigurationException("Generating a new Algorithm here only Works if the Algorithm is a CPAAlgorithm");
        }
        catch (InvalidConfigurationException | CPAException e) {
            throw new IllegalStateException("Unable to create the Algorithm for next Iteration", e);
        }
    }

    private void generateAutomatonFileForNextIteration(PredicatePathAnalysisResult pResult, Path pFilePath) {
        this.stats.beforeAutomationFileGeneration();
        try (Writer w = Files.openOutputFile((Path)pFilePath.toAbsolutePath(), (Charset)Charset.forName("UTF8"), (FileWriteMode[])new FileWriteMode[0]);){
            ARGPath argPath = pResult.getPath();
            CounterexampleInfo ci = CounterexampleInfo.feasible(argPath, pResult.getTrace().getModel());
            ARGUtils.produceTestGenPathAutomaton(w, argPath.getFirstState(), argPath.getStateSet(), "nextPathAutomaton", ci, true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create the Algorithm for next Iteration", e);
        }
        this.stats.afterAutomatonFileGeneration();
    }
}

