/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.iteration;

import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.AbstractIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.AutomatonControlledIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.RestartAtDecisionIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.RestartAtRootIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.TestGenIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;

public class IterationStrategyFactory {
    private StartupConfig startupConfig;
    private CFA cfa;
    private ReachedSetFactory reachedSetFactory;
    private TestGenStatistics stats;
    private boolean produceDebugFiles;

    public IterationStrategyFactory(StartupConfig pStartupConfig, CFA pCfa, ReachedSetFactory pReachedSetFactory, TestGenStatistics pStats, boolean pProduceDebugFiles) {
        this.startupConfig = pStartupConfig;
        this.cfa = pCfa;
        this.reachedSetFactory = pReachedSetFactory;
        this.stats = pStats;
        this.produceDebugFiles = pProduceDebugFiles;
    }

    public TestGenIterationStrategy createStrategy(TestGenAlgorithm.IterationStrategySelector pIterationStrategySelector, Algorithm pAlgorithm) throws InvalidConfigurationException {
        AbstractIterationStrategy iterationStrategy;
        TestGenIterationStrategy.IterationModel model = new TestGenIterationStrategy.IterationModel(pAlgorithm, null, null);
        switch (pIterationStrategySelector) {
            case AUTOMATON_CONTROLLED: {
                iterationStrategy = new AutomatonControlledIterationStrategy(this.startupConfig, this.cfa, model, this.reachedSetFactory, this.stats, this.produceDebugFiles);
                break;
            }
            case SAME_ALGORITHM_RESTART: {
                iterationStrategy = new RestartAtRootIterationStrategy(this.startupConfig, this.reachedSetFactory, model, this.stats);
                break;
            }
            case SAME_ALGORITHM_FILTER_WAITLIST: {
                iterationStrategy = new RestartAtDecisionIterationStrategy(this.startupConfig, this.reachedSetFactory, model, this.stats);
                break;
            }
            default: {
                throw new InvalidConfigurationException("Invald iteration strategy selected");
            }
        }
        return iterationStrategy;
    }
}

