/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.iteration;

import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class PredicatePathAnalysisResult {
    public static final PredicatePathAnalysisResult INVALID = new PredicatePathAnalysisResult(null, null, null, null);
    private CounterexampleTraceInfo trace;
    private ARGState decidingState;
    private ARGState wrongState;
    private ARGPath argPath;

    public PredicatePathAnalysisResult(CounterexampleTraceInfo pTrace, ARGState pDecidingState, ARGState pWrongState, ARGPath pArgPath) {
        this.trace = pTrace;
        this.decidingState = pDecidingState;
        this.wrongState = pWrongState;
        this.argPath = pArgPath;
    }

    public CounterexampleTraceInfo getTrace() {
        this.checkValid();
        return this.trace;
    }

    public ARGState getDecidingState() {
        this.checkValid();
        return this.decidingState;
    }

    public ARGState getWrongState() {
        this.checkValid();
        return this.wrongState;
    }

    public CFANode getDecidingNode() {
        this.checkValid();
        return AbstractStates.extractLocation(this.decidingState);
    }

    @Nullable
    public CFANode getWrongNode() {
        ARGState wState = this.getWrongState();
        return AbstractStates.extractLocation(wState);
    }

    public CFAEdge getSelectedLastEdge() {
        this.checkValid();
        List<CFAEdge> edges = this.argPath.asEdgesList();
        CFAEdge edge = edges.get(edges.size() - 1);
        if (edge == null && edges.size() > 1) {
            edge = edges.get(edges.size() - 2);
        }
        return edge;
    }

    public ARGPath getPath() {
        this.checkValid();
        return this.argPath;
    }

    public boolean isValid() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.trace == null;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("this is not a valid result. It is not allowed to access data of an invalid result");
        }
    }
}

