/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.iteration;

import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.AbstractIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.TestGenIterationStrategy;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.ReachedSetUtils;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;

public class RestartAtDecisionIterationStrategy
extends AbstractIterationStrategy {
    public RestartAtDecisionIterationStrategy(StartupConfig pStartupConfig, ReachedSetFactory pReachedSetFactory, TestGenIterationStrategy.IterationModel pModel, TestGenStatistics pStats) {
        super(pStartupConfig, pModel, pReachedSetFactory, pStats);
    }

    @Override
    public void updateIterationModelForNextIteration(PredicatePathAnalysisResult pResult) {
        this.reinitializeLocalReachedWithInitial(pResult.getWrongState(), pResult.getDecidingState());
    }

    protected void reinitializeLocalReachedWithInitial(AbstractState wrongState, AbstractState rootState) {
        Precision wrongStatePrec = this.getModel().getGlobalReached().getPrecision(wrongState);
        Precision rootStatePrec = this.getModel().getGlobalReached().getPrecision(rootState);
        ReachedSet newReached = this.reachedSetFactory.create();
        this.getModel().setLocalReached(newReached);
        this.getModel().getLocalReached().add(rootState, rootStatePrec);
        ReachedSetUtils.addToReachedOnly(this.getModel().getLocalReached(), wrongState, wrongStatePrec);
    }

    @Override
    protected void updateReached() {
        ReachedSetUtils.addReachedStatesToOtherReached(this.getModel().getLocalReached(), this.getModel().getGlobalReached());
    }
}

