/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.testgen.TestGenStatistics;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathSelector;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.PathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.CFAUtils2;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class BasicPathSelector
implements PathSelector {
    private TestGenStatistics stats;
    ConfigurableProgramAnalysis cpa;
    private LogManager logger;
    protected PathValidator pathValidator;

    public BasicPathSelector(PathValidator pPathValidator, StartupConfig config, TestGenStatistics pStats) {
        this.pathValidator = pPathValidator;
        this.logger = config.getLog();
        this.stats = pStats;
    }

    @Override
    public PredicatePathAnalysisResult findNewFeasiblePathUsingPredicates(ARGPath pExecutedPath, ReachedSet reachedStates) throws CPAException, InterruptedException {
        MutableARGPath newARGPath = pExecutedPath.mutableCopy();
        PathInfo pathInfo = new PathInfo(newARGPath.size());
        ArrayList newPath = Lists.newArrayList(newARGPath.asEdgesList());
        Pair lastElement = null;
        Iterator descendingPathElements = Iterators.consumingIterator(newARGPath.descendingIterator());
        this.pathValidator.handleNewCheck(pExecutedPath);
        while (descendingPathElements.hasNext()) {
            pathInfo.increaseNodeCount();
            Pair currentElement = (Pair)descendingPathElements.next();
            CFAEdge edge = (CFAEdge)currentElement.getSecond();
            if (edge == null) {
                lastElement = currentElement;
                continue;
            }
            this.pathValidator.handleNext(pathInfo, edge);
            CFANode node = edge.getPredecessor();
            if (node.getNumLeavingEdges() != 2) {
                this.pathValidator.handleSinglePathElement((Pair<ARGState, CFAEdge>)currentElement);
                lastElement = currentElement;
                continue;
            }
            pathInfo.increaseBranchCount();
            CFANode decidingNode = node;
            CFAEdge wrongEdge = edge;
            Optional<CFAEdge> otherEdge = CFAUtils2.getAlternativeLeavingEdge(decidingNode, wrongEdge);
            assert (otherEdge.isPresent());
            if (this.pathValidator.isVisitedBranching(newARGPath, (Pair<ARGState, CFAEdge>)currentElement, node, (CFAEdge)otherEdge.get())) {
                this.logger.log(Level.FINER, new Object[]{"Branch on path was handled in an earlier iteration -> skipping branching."});
                lastElement = currentElement;
                this.pathValidator.handleVisitedBranching(newARGPath, (Pair<ARGState, CFAEdge>)currentElement);
                continue;
            }
            if (lastElement == null) {
                this.logger.log(Level.FINER, new Object[]{"encountered an executed path that continues into an already reached region. -> Skipping"});
                lastElement = currentElement;
                continue;
            }
            this.logger.logf(Level.FINER, "identified new path candidate (visited branchings: %d, nodes: %d)", new Object[]{pathInfo.getBranchCount(), pathInfo.getNodeCount()});
            newPath = Lists.newArrayList(newARGPath.asEdgesList());
            newPath.add(otherEdge.get());
            this.stats.beforePathCheck();
            CounterexampleTraceInfo traceInfo = this.pathValidator.validatePathCandidate((Pair<ARGState, CFAEdge>)currentElement, newPath);
            this.stats.afterPathCheck();
            if (!traceInfo.isSpurious()) {
                newARGPath.add(Pair.of((Object)currentElement.getFirst(), (Object)otherEdge.get()));
                this.logger.logf(Level.FINEST, "selected new path %s", new Object[]{((Object)newPath).toString()});
                PredicatePathAnalysisResult result = new PredicatePathAnalysisResult(traceInfo, (ARGState)currentElement.getFirst(), (ARGState)lastElement.getFirst(), newARGPath.immutableCopy());
                this.pathValidator.handleValidPath(result);
                return result;
            }
            lastElement = currentElement;
            this.logger.logf(Level.FINER, "path candidate is infeasible", new Object[0]);
        }
        this.logger.logf(Level.FINER, "No possible path left to explore", new Object[0]);
        return PredicatePathAnalysisResult.INVALID;
    }

    @Override
    public CounterexampleTraceInfo computePredicateCheck(ARGPath pExecutedPath) throws CPAException, InterruptedException {
        return this.pathValidator.validatePath(pExecutedPath.getInnerEdges());
    }

    public class PathInfo {
        private final long pathSize;
        private long currentPathSize;
        private long branchCount = 0L;
        private long nodeCount = 0L;

        public PathInfo(long pPathSize) {
            this.currentPathSize = this.pathSize = pPathSize;
            this.branchCount = 0L;
            this.nodeCount = 0L;
        }

        public long getPathSize() {
            return this.pathSize;
        }

        public long getCurrentPathSize() {
            return this.currentPathSize;
        }

        public long getBranchCount() {
            return this.branchCount;
        }

        public long getNodeCount() {
            return this.nodeCount;
        }

        protected long increaseNodeCount() {
            ++this.nodeCount;
            this.currentPathSize = this.pathSize - this.nodeCount;
            return this.nodeCount;
        }

        protected long increaseBranchCount() {
            return ++this.branchCount;
        }
    }
}

