/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis;

import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.testgen.iteration.PredicatePathAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.testgen.pathanalysis.AbstractPathValidator;
import org.sosy_lab.cpachecker.core.algorithm.testgen.util.StartupConfig;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;

public class CFATrackingPathValidator
extends AbstractPathValidator {
    private final PathChecker pathChecker;
    private final List<CFANode> handledDecisions;

    public CFATrackingPathValidator(PathChecker pPathChecker, StartupConfig pConfig) {
        super(pConfig);
        this.pathChecker = pPathChecker;
        this.handledDecisions = Lists.newLinkedList();
    }

    @Override
    public CounterexampleTraceInfo validatePath(List<CFAEdge> pPath) throws CPAException, InterruptedException {
        return this.pathChecker.checkPath(pPath);
    }

    @Override
    public boolean isVisitedBranching(MutableARGPath pNewARGPath, Pair<ARGState, CFAEdge> pCurrentElement, CFANode pNode, CFAEdge pOtherEdge) {
        return this.handledDecisions.contains(pNode);
    }

    @Override
    public void handleValidPath(PredicatePathAnalysisResult result) {
        this.handledDecisions.add(result.getDecidingNode());
    }
}

